/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to enable change tracking on the table. Default false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#change_tracking Table#change_tracking}
    */
    readonly changeTracking?: boolean | cdktf.IResolvable;
    /**
    * A list of one or more table columns/expressions to be used as clustering key(s) for the table
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#cluster_by Table#cluster_by}
    */
    readonly clusterBy?: string[];
    /**
    * Specifies a comment for the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#comment Table#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the retention period for the table so that Time Travel actions (SELECT, CLONE, UNDROP) can be performed on historical data in the table. If you wish to inherit the parent schema setting then pass in the schema attribute to this argument or do not fill this parameter at all; the default value for this field is -1, which is a fallback to use Snowflake default - in this case the schema value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#data_retention_time_in_days Table#data_retention_time_in_days}
    */
    readonly dataRetentionTimeInDays?: number;
    /**
    * The database in which to create the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#database Table#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#id Table#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the table; must be unique for the database and schema in which the table is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#name Table#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#schema Table#schema}
    */
    readonly schema: string;
    /**
    * column block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#column Table#column}
    */
    readonly column: TableColumn[] | cdktf.IResolvable;
    /**
    * primary_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#primary_key Table#primary_key}
    */
    readonly primaryKey?: TablePrimaryKey;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#tag Table#tag}
    */
    readonly tag?: TableTag[] | cdktf.IResolvable;
}
export interface TableColumnDefault {
    /**
    * The default constant value for the column
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#constant Table#constant}
    */
    readonly constant?: string;
    /**
    * The default expression value for the column
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#expression Table#expression}
    */
    readonly expression?: string;
    /**
    * The default sequence to use for the column
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#sequence Table#sequence}
    */
    readonly sequence?: string;
}
export declare function tableColumnDefaultToTerraform(struct?: TableColumnDefaultOutputReference | TableColumnDefault): any;
export declare function tableColumnDefaultToHclTerraform(struct?: TableColumnDefaultOutputReference | TableColumnDefault): any;
export declare class TableColumnDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TableColumnDefault | undefined;
    set internalValue(value: TableColumnDefault | undefined);
    private _constant?;
    get constant(): string;
    set constant(value: string);
    resetConstant(): void;
    get constantInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    resetExpression(): void;
    get expressionInput(): string | undefined;
    private _sequence?;
    get sequence(): string;
    set sequence(value: string);
    resetSequence(): void;
    get sequenceInput(): string | undefined;
}
export interface TableColumnIdentity {
    /**
    * The number to start incrementing at.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#start_num Table#start_num}
    */
    readonly startNum?: number;
    /**
    * Step size to increment by.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#step_num Table#step_num}
    */
    readonly stepNum?: number;
}
export declare function tableColumnIdentityToTerraform(struct?: TableColumnIdentityOutputReference | TableColumnIdentity): any;
export declare function tableColumnIdentityToHclTerraform(struct?: TableColumnIdentityOutputReference | TableColumnIdentity): any;
export declare class TableColumnIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TableColumnIdentity | undefined;
    set internalValue(value: TableColumnIdentity | undefined);
    private _startNum?;
    get startNum(): number;
    set startNum(value: number);
    resetStartNum(): void;
    get startNumInput(): number | undefined;
    private _stepNum?;
    get stepNum(): number;
    set stepNum(value: number);
    resetStepNum(): void;
    get stepNumInput(): number | undefined;
}
export interface TableColumn {
    /**
    * Column collation, e.g. utf8
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#collate Table#collate}
    */
    readonly collate?: string;
    /**
    * Column comment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#comment Table#comment}
    */
    readonly comment?: string;
    /**
    * Masking policy to apply on column. It has to be a fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#masking_policy Table#masking_policy}
    */
    readonly maskingPolicy?: string;
    /**
    * Column name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#name Table#name}
    */
    readonly name: string;
    /**
    * Whether this column can contain null values. **Note**: Depending on your Snowflake version, the default value will not suffice if this column is used in a primary key constraint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#nullable Table#nullable}
    */
    readonly nullable?: boolean | cdktf.IResolvable;
    /**
    * Column type, e.g. VARIANT. For a full list of column types, see [Summary of Data Types](https://docs.snowflake.com/en/sql-reference/intro-summary-data-types).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#type Table#type}
    */
    readonly type: string;
    /**
    * default block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#default Table#default}
    */
    readonly default?: TableColumnDefault;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#identity Table#identity}
    */
    readonly identity?: TableColumnIdentity;
}
export declare function tableColumnToTerraform(struct?: TableColumn | cdktf.IResolvable): any;
export declare function tableColumnToHclTerraform(struct?: TableColumn | cdktf.IResolvable): any;
export declare class TableColumnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TableColumn | cdktf.IResolvable | undefined;
    set internalValue(value: TableColumn | cdktf.IResolvable | undefined);
    private _collate?;
    get collate(): string;
    set collate(value: string);
    resetCollate(): void;
    get collateInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _maskingPolicy?;
    get maskingPolicy(): string;
    set maskingPolicy(value: string);
    resetMaskingPolicy(): void;
    get maskingPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullable?;
    get nullable(): boolean | cdktf.IResolvable;
    set nullable(value: boolean | cdktf.IResolvable);
    resetNullable(): void;
    get nullableInput(): boolean | cdktf.IResolvable | undefined;
    get schemaEvolutionRecord(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _default;
    get default(): TableColumnDefaultOutputReference;
    putDefault(value: TableColumnDefault): void;
    resetDefault(): void;
    get defaultInput(): TableColumnDefault | undefined;
    private _identity;
    get identity(): TableColumnIdentityOutputReference;
    putIdentity(value: TableColumnIdentity): void;
    resetIdentity(): void;
    get identityInput(): TableColumnIdentity | undefined;
}
export declare class TableColumnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TableColumn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TableColumnOutputReference;
}
export interface TablePrimaryKey {
    /**
    * Columns to use in primary key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#keys Table#keys}
    */
    readonly keys: string[];
    /**
    * Name of constraint
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#name Table#name}
    */
    readonly name?: string;
}
export declare function tablePrimaryKeyToTerraform(struct?: TablePrimaryKeyOutputReference | TablePrimaryKey): any;
export declare function tablePrimaryKeyToHclTerraform(struct?: TablePrimaryKeyOutputReference | TablePrimaryKey): any;
export declare class TablePrimaryKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TablePrimaryKey | undefined;
    set internalValue(value: TablePrimaryKey | undefined);
    private _keys?;
    get keys(): string[];
    set keys(value: string[]);
    get keysInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface TableTag {
    /**
    * Name of the database that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#database Table#database}
    */
    readonly database?: string;
    /**
    * Tag name, e.g. department.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#name Table#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#schema Table#schema}
    */
    readonly schema?: string;
    /**
    * Tag value, e.g. marketing_info.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#value Table#value}
    */
    readonly value: string;
}
export declare function tableTagToTerraform(struct?: TableTag | cdktf.IResolvable): any;
export declare function tableTagToHclTerraform(struct?: TableTag | cdktf.IResolvable): any;
export declare class TableTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TableTag | cdktf.IResolvable | undefined;
    set internalValue(value: TableTag | cdktf.IResolvable | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class TableTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TableTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TableTagOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table snowflake_table}
*/
export declare class Table extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_table";
    /**
    * Generates CDKTF code for importing a Table resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Table to import
    * @param importFromId The id of the existing Table that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Table to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/table snowflake_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TableConfig
    */
    constructor(scope: Construct, id: string, config: TableConfig);
    private _changeTracking?;
    get changeTracking(): boolean | cdktf.IResolvable;
    set changeTracking(value: boolean | cdktf.IResolvable);
    resetChangeTracking(): void;
    get changeTrackingInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterBy?;
    get clusterBy(): string[];
    set clusterBy(value: string[]);
    resetClusterBy(): void;
    get clusterByInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataRetentionTimeInDays?;
    get dataRetentionTimeInDays(): number;
    set dataRetentionTimeInDays(value: number);
    resetDataRetentionTimeInDays(): void;
    get dataRetentionTimeInDaysInput(): number | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get owner(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _column;
    get column(): TableColumnList;
    putColumn(value: TableColumn[] | cdktf.IResolvable): void;
    get columnInput(): cdktf.IResolvable | TableColumn[] | undefined;
    private _primaryKey;
    get primaryKey(): TablePrimaryKeyOutputReference;
    putPrimaryKey(value: TablePrimaryKey): void;
    resetPrimaryKey(): void;
    get primaryKeyInput(): TablePrimaryKey | undefined;
    private _tag;
    get tag(): TableTagList;
    putTag(value: TableTag[] | cdktf.IResolvable): void;
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | TableTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
