import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "cdktf-cdktf-provider-snowflake",
    "version": "11.15.0",
    "description": "Prebuilt snowflake Provider for Terraform CDK (cdktf)",
    "license": "MPL-2.0",
    "url": "https://github.com/cdktf/cdktf-provider-snowflake.git",
    "long_description_content_type": "text/markdown",
    "author": "HashiCorp",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/cdktf/cdktf-provider-snowflake.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "cdktf_cdktf_provider_snowflake",
        "cdktf_cdktf_provider_snowflake._jsii",
        "cdktf_cdktf_provider_snowflake.account",
        "cdktf_cdktf_provider_snowflake.account_authentication_policy_attachment",
        "cdktf_cdktf_provider_snowflake.account_parameter",
        "cdktf_cdktf_provider_snowflake.account_password_policy_attachment",
        "cdktf_cdktf_provider_snowflake.account_role",
        "cdktf_cdktf_provider_snowflake.alert",
        "cdktf_cdktf_provider_snowflake.api_authentication_integration_with_authorization_code_grant",
        "cdktf_cdktf_provider_snowflake.api_authentication_integration_with_client_credentials",
        "cdktf_cdktf_provider_snowflake.api_authentication_integration_with_jwt_bearer",
        "cdktf_cdktf_provider_snowflake.api_integration",
        "cdktf_cdktf_provider_snowflake.authentication_policy",
        "cdktf_cdktf_provider_snowflake.cortex_search_service",
        "cdktf_cdktf_provider_snowflake.data_snowflake_accounts",
        "cdktf_cdktf_provider_snowflake.data_snowflake_alerts",
        "cdktf_cdktf_provider_snowflake.data_snowflake_connections",
        "cdktf_cdktf_provider_snowflake.data_snowflake_cortex_search_services",
        "cdktf_cdktf_provider_snowflake.data_snowflake_current_account",
        "cdktf_cdktf_provider_snowflake.data_snowflake_current_role",
        "cdktf_cdktf_provider_snowflake.data_snowflake_database",
        "cdktf_cdktf_provider_snowflake.data_snowflake_database_role",
        "cdktf_cdktf_provider_snowflake.data_snowflake_database_roles",
        "cdktf_cdktf_provider_snowflake.data_snowflake_databases",
        "cdktf_cdktf_provider_snowflake.data_snowflake_dynamic_tables",
        "cdktf_cdktf_provider_snowflake.data_snowflake_external_functions",
        "cdktf_cdktf_provider_snowflake.data_snowflake_external_tables",
        "cdktf_cdktf_provider_snowflake.data_snowflake_failover_groups",
        "cdktf_cdktf_provider_snowflake.data_snowflake_file_formats",
        "cdktf_cdktf_provider_snowflake.data_snowflake_functions",
        "cdktf_cdktf_provider_snowflake.data_snowflake_grants",
        "cdktf_cdktf_provider_snowflake.data_snowflake_masking_policies",
        "cdktf_cdktf_provider_snowflake.data_snowflake_materialized_views",
        "cdktf_cdktf_provider_snowflake.data_snowflake_network_policies",
        "cdktf_cdktf_provider_snowflake.data_snowflake_parameters",
        "cdktf_cdktf_provider_snowflake.data_snowflake_pipes",
        "cdktf_cdktf_provider_snowflake.data_snowflake_procedures",
        "cdktf_cdktf_provider_snowflake.data_snowflake_resource_monitors",
        "cdktf_cdktf_provider_snowflake.data_snowflake_role",
        "cdktf_cdktf_provider_snowflake.data_snowflake_roles",
        "cdktf_cdktf_provider_snowflake.data_snowflake_row_access_policies",
        "cdktf_cdktf_provider_snowflake.data_snowflake_schemas",
        "cdktf_cdktf_provider_snowflake.data_snowflake_secrets",
        "cdktf_cdktf_provider_snowflake.data_snowflake_security_integrations",
        "cdktf_cdktf_provider_snowflake.data_snowflake_sequences",
        "cdktf_cdktf_provider_snowflake.data_snowflake_shares",
        "cdktf_cdktf_provider_snowflake.data_snowflake_stages",
        "cdktf_cdktf_provider_snowflake.data_snowflake_storage_integrations",
        "cdktf_cdktf_provider_snowflake.data_snowflake_streamlits",
        "cdktf_cdktf_provider_snowflake.data_snowflake_streams",
        "cdktf_cdktf_provider_snowflake.data_snowflake_system_generate_scim_access_token",
        "cdktf_cdktf_provider_snowflake.data_snowflake_system_get_aws_sns_iam_policy",
        "cdktf_cdktf_provider_snowflake.data_snowflake_system_get_privatelink_config",
        "cdktf_cdktf_provider_snowflake.data_snowflake_system_get_snowflake_platform_info",
        "cdktf_cdktf_provider_snowflake.data_snowflake_tables",
        "cdktf_cdktf_provider_snowflake.data_snowflake_tags",
        "cdktf_cdktf_provider_snowflake.data_snowflake_tasks",
        "cdktf_cdktf_provider_snowflake.data_snowflake_users",
        "cdktf_cdktf_provider_snowflake.data_snowflake_views",
        "cdktf_cdktf_provider_snowflake.data_snowflake_warehouses",
        "cdktf_cdktf_provider_snowflake.database",
        "cdktf_cdktf_provider_snowflake.database_old",
        "cdktf_cdktf_provider_snowflake.database_role",
        "cdktf_cdktf_provider_snowflake.dynamic_table",
        "cdktf_cdktf_provider_snowflake.email_notification_integration",
        "cdktf_cdktf_provider_snowflake.external_function",
        "cdktf_cdktf_provider_snowflake.external_oauth_integration",
        "cdktf_cdktf_provider_snowflake.external_table",
        "cdktf_cdktf_provider_snowflake.external_volume",
        "cdktf_cdktf_provider_snowflake.failover_group",
        "cdktf_cdktf_provider_snowflake.file_format",
        "cdktf_cdktf_provider_snowflake.function_resource",
        "cdktf_cdktf_provider_snowflake.grant_account_role",
        "cdktf_cdktf_provider_snowflake.grant_application_role",
        "cdktf_cdktf_provider_snowflake.grant_database_role",
        "cdktf_cdktf_provider_snowflake.grant_ownership",
        "cdktf_cdktf_provider_snowflake.grant_privileges_to_account_role",
        "cdktf_cdktf_provider_snowflake.grant_privileges_to_database_role",
        "cdktf_cdktf_provider_snowflake.grant_privileges_to_share",
        "cdktf_cdktf_provider_snowflake.legacy_service_user",
        "cdktf_cdktf_provider_snowflake.managed_account",
        "cdktf_cdktf_provider_snowflake.masking_policy",
        "cdktf_cdktf_provider_snowflake.materialized_view",
        "cdktf_cdktf_provider_snowflake.network_policy",
        "cdktf_cdktf_provider_snowflake.network_policy_attachment",
        "cdktf_cdktf_provider_snowflake.network_rule",
        "cdktf_cdktf_provider_snowflake.notification_integration",
        "cdktf_cdktf_provider_snowflake.oauth_integration",
        "cdktf_cdktf_provider_snowflake.oauth_integration_for_custom_clients",
        "cdktf_cdktf_provider_snowflake.oauth_integration_for_partner_applications",
        "cdktf_cdktf_provider_snowflake.object_parameter",
        "cdktf_cdktf_provider_snowflake.password_policy",
        "cdktf_cdktf_provider_snowflake.pipe",
        "cdktf_cdktf_provider_snowflake.primary_connection",
        "cdktf_cdktf_provider_snowflake.procedure",
        "cdktf_cdktf_provider_snowflake.provider",
        "cdktf_cdktf_provider_snowflake.resource_monitor",
        "cdktf_cdktf_provider_snowflake.role",
        "cdktf_cdktf_provider_snowflake.row_access_policy",
        "cdktf_cdktf_provider_snowflake.saml_integration",
        "cdktf_cdktf_provider_snowflake.saml2_integration",
        "cdktf_cdktf_provider_snowflake.schema",
        "cdktf_cdktf_provider_snowflake.scim_integration",
        "cdktf_cdktf_provider_snowflake.secondary_connection",
        "cdktf_cdktf_provider_snowflake.secondary_database",
        "cdktf_cdktf_provider_snowflake.secret_with_authorization_code_grant",
        "cdktf_cdktf_provider_snowflake.secret_with_basic_authentication",
        "cdktf_cdktf_provider_snowflake.secret_with_client_credentials",
        "cdktf_cdktf_provider_snowflake.secret_with_generic_string",
        "cdktf_cdktf_provider_snowflake.sequence",
        "cdktf_cdktf_provider_snowflake.service_user",
        "cdktf_cdktf_provider_snowflake.session_parameter",
        "cdktf_cdktf_provider_snowflake.share",
        "cdktf_cdktf_provider_snowflake.shared_database",
        "cdktf_cdktf_provider_snowflake.stage",
        "cdktf_cdktf_provider_snowflake.storage_integration",
        "cdktf_cdktf_provider_snowflake.stream",
        "cdktf_cdktf_provider_snowflake.stream_on_directory_table",
        "cdktf_cdktf_provider_snowflake.stream_on_external_table",
        "cdktf_cdktf_provider_snowflake.stream_on_table",
        "cdktf_cdktf_provider_snowflake.stream_on_view",
        "cdktf_cdktf_provider_snowflake.streamlit",
        "cdktf_cdktf_provider_snowflake.table",
        "cdktf_cdktf_provider_snowflake.table_column_masking_policy_application",
        "cdktf_cdktf_provider_snowflake.table_constraint",
        "cdktf_cdktf_provider_snowflake.tag",
        "cdktf_cdktf_provider_snowflake.tag_association",
        "cdktf_cdktf_provider_snowflake.tag_masking_policy_association",
        "cdktf_cdktf_provider_snowflake.task",
        "cdktf_cdktf_provider_snowflake.unsafe_execute",
        "cdktf_cdktf_provider_snowflake.user",
        "cdktf_cdktf_provider_snowflake.user_authentication_policy_attachment",
        "cdktf_cdktf_provider_snowflake.user_password_policy_attachment",
        "cdktf_cdktf_provider_snowflake.user_public_keys",
        "cdktf_cdktf_provider_snowflake.view",
        "cdktf_cdktf_provider_snowflake.warehouse"
    ],
    "package_data": {
        "cdktf_cdktf_provider_snowflake._jsii": [
            "provider-snowflake@11.15.0.jsii.tgz"
        ],
        "cdktf_cdktf_provider_snowflake": [
            "py.typed"
        ]
    },
    "python_requires": "~=3.8",
    "install_requires": [
        "cdktf>=0.20.0, <0.21.0",
        "constructs>=10.3.0, <11.0.0",
        "jsii>=1.105.0, <2.0.0",
        "publication>=0.0.3",
        "typeguard>=2.13.3,<4.3.0"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Typing :: Typed",
        "Development Status :: 5 - Production/Stable",
        "License :: OSI Approved"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
