# Sportradar Unofficial
## Disclaimer

This Python package provides access to sport data API offered by Sportradar. Please read and understand the following disclaimer before using this package:

### Usage

The use of this package requires valid API credentials issued by Sportradar. By using this package, you acknowledge and agree to the following:

1. This software is provided 'as is' and without any warranty, express or implied.
2. The developer is not responsible for any issues, damages, or consequences arising from the use of this package.
3. Any use of the API credentials is solely your responsibility, and you must comply with Sportradar's terms of service and usage policies.
4. The developer does not claim any endorsement or authorization from Sportradar for the development or distribution of this package.

### Recommendations

It is highly recommended to review Sportradar's terms of service and privacy policy before using this package. If you have any legal or privacy concerns, please refrain from using this software.

---

**An unofficial python package to access Sportradar NFL APIs**

This package allows you to easily extract sports data for analysis and predictive modeling with a simple interface to access NFL APIs.

## Installation

You can install the `sportradar-unofficial` python package via pip:
```bash
pip install sportradar-unofficial
```

## 📝 Notebooks

A list of notebooks and articles related to ETL pipelines.

### Tools

| Notebook              | Description                                      | Notebook |
|-----------------------|--------------------------------------------------|----------|
| 🧐 NFL-Stats Examples | Simulation and Game Feeds ETL pipeline           | <a href="https://colab.research.google.com/drive/1qKTaGMNYZBAve7JCDEhtISV_sAf0RcEy?usp=sharing"><img src="img/colab.svg" alt="Open In Colab"></a> |


More examples and features will be available on [GitHub](https://www.github.com/ggurjar333/sportradar-unofficial)

## Contributing

We absolutely love contributions! If you would like to contribute to `sportradar`, please follow these steps:

### Setting up the Project

1. Fork the repository: On the top-right of this page, click on the Fork button. This creates a copy of the `sportradar` repository in your own GitHub account.

2. Clone the repository: Now, clone this new repository onto your local machine. This creates a local copy that you can edit.

   ```bash
   git clone https://github.com/ggurjar333/sportradar-unofficial.git
   ```

3. Create a new branch for your changes: Use `git checkout -b branch-name` to create a new branch and switch to it. The branch name could be the feature you want to add or fix.

### Making the Changes

1. Make the changes in your local copy of the repository.

2. Test your changes thoroughly to ensure everything is working as expected.

3. Document your changes. Make sure your code is commented and the repository documentation is updated to reflect your changes.

### Submitting Contributions

1. Stage and commit your changes: Once you are satisfied with your changes, stage and commit them.

   ```bash
   git add .
   git commit -m "Your detailed commit message"
   ```

2. Push your changes to your forked repository on GitHub.

   ```bash
   git push origin branch-name
   ```

3. Create a Pull Request: Go to your forked repository on

## Author(s)
- [John Bonnett](https://www.linkedin.com/in/john-bonnett-ba89909b/)
- [Gaurav Gurjar](https://www.linkedin.com/in/ggurjarsocl/)
- [John Bassie](https://www.linkedin.com/in/john-bassey-991a99107)

## License

This project is licensed under the MIT License. Please see the [LICENSE.txt](LICENSE.txt) file for details.

## Acknowledgements

Shout out to all the Sports enthusiasts and Data Engineers/Scientists!

### Contact Information

For any inquiries or concerns, please contact:

Gaurav Gurjar
- [LinkedIn](https://www.linkedin.com/in/ggurjarsocl/)