import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermApiManagementProductConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product.html#api_management_name DataAzurermApiManagementProduct#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product.html#product_id DataAzurermApiManagementProduct#product_id}.
     *
     * @stability stable
     */
    readonly productId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product.html#resource_group_name DataAzurermApiManagementProduct#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product.html#timeouts DataAzurermApiManagementProduct#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermApiManagementProductTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermApiManagementProductTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product.html#read DataAzurermApiManagementProduct#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermApiManagementProductTimeoutsToTerraform(struct?: DataAzurermApiManagementProductTimeoutsOutputReference | DataAzurermApiManagementProductTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementProductTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermApiManagementProductTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermApiManagementProductTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product.html azurerm_api_management_product}.
 *
 * @stability stable
 */
export declare class DataAzurermApiManagementProduct extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product.html azurerm_api_management_product} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementProductConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get approvalRequired(): any;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _productId?;
    /**
     * @stability stable
     */
    get productId(): string;
    /**
     * @stability stable
     */
    set productId(value: string);
    /**
     * @stability stable
     */
    get productIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get published(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get subscriptionRequired(): any;
    /**
     * @stability stable
     */
    get subscriptionsLimit(): number;
    /**
     * @stability stable
     */
    get terms(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermApiManagementProductTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermApiManagementProductTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermApiManagementProductTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
