import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IotSecurityDeviceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#iothub_id IotSecurityDeviceGroup#iothub_id}.
     *
     * @stability stable
     */
    readonly iothubId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#name IotSecurityDeviceGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * allow_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#allow_rule IotSecurityDeviceGroup#allow_rule}
     *
     * @stability stable
     */
    readonly allowRule?: IotSecurityDeviceGroupAllowRule;
    /**
     * range_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#range_rule IotSecurityDeviceGroup#range_rule}
     *
     * @stability stable
     */
    readonly rangeRule?: IotSecurityDeviceGroupRangeRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#timeouts IotSecurityDeviceGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IotSecurityDeviceGroupTimeouts;
}
/**
 * @stability stable
 */
export interface IotSecurityDeviceGroupAllowRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#connection_from_ips_not_allowed IotSecurityDeviceGroup#connection_from_ips_not_allowed}.
     *
     * @stability stable
     */
    readonly connectionFromIpsNotAllowed?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#connection_to_ip_not_allowed IotSecurityDeviceGroup#connection_to_ip_not_allowed}.
     *
     * @stability stable
     */
    readonly connectionToIpNotAllowed?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#connection_to_ips_not_allowed IotSecurityDeviceGroup#connection_to_ips_not_allowed}.
     *
     * @stability stable
     */
    readonly connectionToIpsNotAllowed?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#local_user_not_allowed IotSecurityDeviceGroup#local_user_not_allowed}.
     *
     * @stability stable
     */
    readonly localUserNotAllowed?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#local_users_not_allowed IotSecurityDeviceGroup#local_users_not_allowed}.
     *
     * @stability stable
     */
    readonly localUsersNotAllowed?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#process_not_allowed IotSecurityDeviceGroup#process_not_allowed}.
     *
     * @stability stable
     */
    readonly processNotAllowed?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#processes_not_allowed IotSecurityDeviceGroup#processes_not_allowed}.
     *
     * @stability stable
     */
    readonly processesNotAllowed?: string[];
}
export declare function iotSecurityDeviceGroupAllowRuleToTerraform(struct?: IotSecurityDeviceGroupAllowRuleOutputReference | IotSecurityDeviceGroupAllowRule): any;
/**
 * @stability stable
 */
export declare class IotSecurityDeviceGroupAllowRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IotSecurityDeviceGroupAllowRule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IotSecurityDeviceGroupAllowRule | undefined);
    private _connectionFromIpsNotAllowed?;
    /**
     * @stability stable
     */
    get connectionFromIpsNotAllowed(): string[];
    /**
     * @stability stable
     */
    set connectionFromIpsNotAllowed(value: string[]);
    /**
     * @stability stable
     */
    resetConnectionFromIpsNotAllowed(): void;
    /**
     * @stability stable
     */
    get connectionFromIpsNotAllowedInput(): string[] | undefined;
    private _connectionToIpNotAllowed?;
    /**
     * @stability stable
     */
    get connectionToIpNotAllowed(): string[];
    /**
     * @stability stable
     */
    set connectionToIpNotAllowed(value: string[]);
    /**
     * @stability stable
     */
    resetConnectionToIpNotAllowed(): void;
    /**
     * @stability stable
     */
    get connectionToIpNotAllowedInput(): string[] | undefined;
    private _connectionToIpsNotAllowed?;
    /**
     * @stability stable
     */
    get connectionToIpsNotAllowed(): string[];
    /**
     * @stability stable
     */
    set connectionToIpsNotAllowed(value: string[]);
    /**
     * @stability stable
     */
    resetConnectionToIpsNotAllowed(): void;
    /**
     * @stability stable
     */
    get connectionToIpsNotAllowedInput(): string[] | undefined;
    private _localUserNotAllowed?;
    /**
     * @stability stable
     */
    get localUserNotAllowed(): string[];
    /**
     * @stability stable
     */
    set localUserNotAllowed(value: string[]);
    /**
     * @stability stable
     */
    resetLocalUserNotAllowed(): void;
    /**
     * @stability stable
     */
    get localUserNotAllowedInput(): string[] | undefined;
    private _localUsersNotAllowed?;
    /**
     * @stability stable
     */
    get localUsersNotAllowed(): string[];
    /**
     * @stability stable
     */
    set localUsersNotAllowed(value: string[]);
    /**
     * @stability stable
     */
    resetLocalUsersNotAllowed(): void;
    /**
     * @stability stable
     */
    get localUsersNotAllowedInput(): string[] | undefined;
    private _processNotAllowed?;
    /**
     * @stability stable
     */
    get processNotAllowed(): string[];
    /**
     * @stability stable
     */
    set processNotAllowed(value: string[]);
    /**
     * @stability stable
     */
    resetProcessNotAllowed(): void;
    /**
     * @stability stable
     */
    get processNotAllowedInput(): string[] | undefined;
    private _processesNotAllowed?;
    /**
     * @stability stable
     */
    get processesNotAllowed(): string[];
    /**
     * @stability stable
     */
    set processesNotAllowed(value: string[]);
    /**
     * @stability stable
     */
    resetProcessesNotAllowed(): void;
    /**
     * @stability stable
     */
    get processesNotAllowedInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface IotSecurityDeviceGroupRangeRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#duration IotSecurityDeviceGroup#duration}.
     *
     * @stability stable
     */
    readonly duration: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#max IotSecurityDeviceGroup#max}.
     *
     * @stability stable
     */
    readonly max: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#min IotSecurityDeviceGroup#min}.
     *
     * @stability stable
     */
    readonly min: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#type IotSecurityDeviceGroup#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function iotSecurityDeviceGroupRangeRuleToTerraform(struct?: IotSecurityDeviceGroupRangeRule): any;
/**
 * @stability stable
 */
export interface IotSecurityDeviceGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#create IotSecurityDeviceGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#delete IotSecurityDeviceGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#read IotSecurityDeviceGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html#update IotSecurityDeviceGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function iotSecurityDeviceGroupTimeoutsToTerraform(struct?: IotSecurityDeviceGroupTimeoutsOutputReference | IotSecurityDeviceGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class IotSecurityDeviceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IotSecurityDeviceGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IotSecurityDeviceGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html azurerm_iot_security_device_group}.
 *
 * @stability stable
 */
export declare class IotSecurityDeviceGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group.html azurerm_iot_security_device_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IotSecurityDeviceGroupConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _iothubId?;
    /**
     * @stability stable
     */
    get iothubId(): string;
    /**
     * @stability stable
     */
    set iothubId(value: string);
    /**
     * @stability stable
     */
    get iothubIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _allowRule;
    /**
     * @stability stable
     */
    get allowRule(): IotSecurityDeviceGroupAllowRuleOutputReference;
    /**
     * @stability stable
     */
    putAllowRule(value: IotSecurityDeviceGroupAllowRule): void;
    /**
     * @stability stable
     */
    resetAllowRule(): void;
    /**
     * @stability stable
     */
    get allowRuleInput(): IotSecurityDeviceGroupAllowRule | undefined;
    private _rangeRule?;
    /**
     * @stability stable
     */
    get rangeRule(): IotSecurityDeviceGroupRangeRule[];
    /**
     * @stability stable
     */
    set rangeRule(value: IotSecurityDeviceGroupRangeRule[]);
    /**
     * @stability stable
     */
    resetRangeRule(): void;
    /**
     * @stability stable
     */
    get rangeRuleInput(): IotSecurityDeviceGroupRangeRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IotSecurityDeviceGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IotSecurityDeviceGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IotSecurityDeviceGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
