# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 applications: Optional[pulumi.Input['ProjectApplicationsArgs']] = None,
                 attributes: Optional[pulumi.Input['ProjectAttributesArgs']] = None,
                 authentication: Optional[pulumi.Input['ProjectAuthenticationArgs']] = None,
                 authorization: Optional[pulumi.Input['ProjectAuthorizationArgs']] = None,
                 connectors: Optional[pulumi.Input['ProjectConnectorsArgs']] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 flows: Optional[pulumi.Input[Mapping[str, pulumi.Input['ProjectFlowsArgs']]]] = None,
                 jwt_templates: Optional[pulumi.Input['ProjectJwtTemplatesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_settings: Optional[pulumi.Input['ProjectProjectSettingsArgs']] = None,
                 styles: Optional[pulumi.Input['ProjectStylesArgs']] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input['ProjectApplicationsArgs'] applications: Applications that are registered with the project.
        :param pulumi.Input['ProjectAttributesArgs'] attributes: Custom attributes that can be attached to users and tenants.
        :param pulumi.Input['ProjectAuthenticationArgs'] authentication: Settings for each authentication method.
        :param pulumi.Input['ProjectAuthorizationArgs'] authorization: Define Role-Based Access Control (RBAC) for your users by creating roles and permissions.
        :param pulumi.Input['ProjectConnectorsArgs'] connectors: Enrich your flows by interacting with third party services.
        :param pulumi.Input[str] environment: This can be set to `production` to mark production projects, otherwise this should be left unset for development or staging projects.
        :param pulumi.Input[Mapping[str, pulumi.Input['ProjectFlowsArgs']]] flows: Custom authentication flows to use in this project.
        :param pulumi.Input['ProjectJwtTemplatesArgs'] jwt_templates: Defines templates for JSON Web Tokens (JWT) used for authentication.
        :param pulumi.Input[str] name: The name of the Descope project.
        :param pulumi.Input['ProjectProjectSettingsArgs'] project_settings: General settings for the Descope project.
        :param pulumi.Input['ProjectStylesArgs'] styles: Custom styles that can be applied to the project's authentication flows.
        """
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if connectors is not None:
            pulumi.set(__self__, "connectors", connectors)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if flows is not None:
            pulumi.set(__self__, "flows", flows)
        if jwt_templates is not None:
            pulumi.set(__self__, "jwt_templates", jwt_templates)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_settings is not None:
            pulumi.set(__self__, "project_settings", project_settings)
        if styles is not None:
            pulumi.set(__self__, "styles", styles)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input['ProjectApplicationsArgs']]:
        """
        Applications that are registered with the project.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input['ProjectApplicationsArgs']]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input['ProjectAttributesArgs']]:
        """
        Custom attributes that can be attached to users and tenants.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input['ProjectAttributesArgs']]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['ProjectAuthenticationArgs']]:
        """
        Settings for each authentication method.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['ProjectAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['ProjectAuthorizationArgs']]:
        """
        Define Role-Based Access Control (RBAC) for your users by creating roles and permissions.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['ProjectAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def connectors(self) -> Optional[pulumi.Input['ProjectConnectorsArgs']]:
        """
        Enrich your flows by interacting with third party services.
        """
        return pulumi.get(self, "connectors")

    @connectors.setter
    def connectors(self, value: Optional[pulumi.Input['ProjectConnectorsArgs']]):
        pulumi.set(self, "connectors", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        This can be set to `production` to mark production projects, otherwise this should be left unset for development or staging projects.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def flows(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ProjectFlowsArgs']]]]:
        """
        Custom authentication flows to use in this project.
        """
        return pulumi.get(self, "flows")

    @flows.setter
    def flows(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ProjectFlowsArgs']]]]):
        pulumi.set(self, "flows", value)

    @property
    @pulumi.getter(name="jwtTemplates")
    def jwt_templates(self) -> Optional[pulumi.Input['ProjectJwtTemplatesArgs']]:
        """
        Defines templates for JSON Web Tokens (JWT) used for authentication.
        """
        return pulumi.get(self, "jwt_templates")

    @jwt_templates.setter
    def jwt_templates(self, value: Optional[pulumi.Input['ProjectJwtTemplatesArgs']]):
        pulumi.set(self, "jwt_templates", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Descope project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectSettings")
    def project_settings(self) -> Optional[pulumi.Input['ProjectProjectSettingsArgs']]:
        """
        General settings for the Descope project.
        """
        return pulumi.get(self, "project_settings")

    @project_settings.setter
    def project_settings(self, value: Optional[pulumi.Input['ProjectProjectSettingsArgs']]):
        pulumi.set(self, "project_settings", value)

    @property
    @pulumi.getter
    def styles(self) -> Optional[pulumi.Input['ProjectStylesArgs']]:
        """
        Custom styles that can be applied to the project's authentication flows.
        """
        return pulumi.get(self, "styles")

    @styles.setter
    def styles(self, value: Optional[pulumi.Input['ProjectStylesArgs']]):
        pulumi.set(self, "styles", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 applications: Optional[pulumi.Input['ProjectApplicationsArgs']] = None,
                 attributes: Optional[pulumi.Input['ProjectAttributesArgs']] = None,
                 authentication: Optional[pulumi.Input['ProjectAuthenticationArgs']] = None,
                 authorization: Optional[pulumi.Input['ProjectAuthorizationArgs']] = None,
                 connectors: Optional[pulumi.Input['ProjectConnectorsArgs']] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 flows: Optional[pulumi.Input[Mapping[str, pulumi.Input['ProjectFlowsArgs']]]] = None,
                 jwt_templates: Optional[pulumi.Input['ProjectJwtTemplatesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_settings: Optional[pulumi.Input['ProjectProjectSettingsArgs']] = None,
                 styles: Optional[pulumi.Input['ProjectStylesArgs']] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input['ProjectApplicationsArgs'] applications: Applications that are registered with the project.
        :param pulumi.Input['ProjectAttributesArgs'] attributes: Custom attributes that can be attached to users and tenants.
        :param pulumi.Input['ProjectAuthenticationArgs'] authentication: Settings for each authentication method.
        :param pulumi.Input['ProjectAuthorizationArgs'] authorization: Define Role-Based Access Control (RBAC) for your users by creating roles and permissions.
        :param pulumi.Input['ProjectConnectorsArgs'] connectors: Enrich your flows by interacting with third party services.
        :param pulumi.Input[str] environment: This can be set to `production` to mark production projects, otherwise this should be left unset for development or staging projects.
        :param pulumi.Input[Mapping[str, pulumi.Input['ProjectFlowsArgs']]] flows: Custom authentication flows to use in this project.
        :param pulumi.Input['ProjectJwtTemplatesArgs'] jwt_templates: Defines templates for JSON Web Tokens (JWT) used for authentication.
        :param pulumi.Input[str] name: The name of the Descope project.
        :param pulumi.Input['ProjectProjectSettingsArgs'] project_settings: General settings for the Descope project.
        :param pulumi.Input['ProjectStylesArgs'] styles: Custom styles that can be applied to the project's authentication flows.
        """
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if connectors is not None:
            pulumi.set(__self__, "connectors", connectors)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if flows is not None:
            pulumi.set(__self__, "flows", flows)
        if jwt_templates is not None:
            pulumi.set(__self__, "jwt_templates", jwt_templates)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_settings is not None:
            pulumi.set(__self__, "project_settings", project_settings)
        if styles is not None:
            pulumi.set(__self__, "styles", styles)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input['ProjectApplicationsArgs']]:
        """
        Applications that are registered with the project.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input['ProjectApplicationsArgs']]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input['ProjectAttributesArgs']]:
        """
        Custom attributes that can be attached to users and tenants.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input['ProjectAttributesArgs']]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['ProjectAuthenticationArgs']]:
        """
        Settings for each authentication method.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['ProjectAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['ProjectAuthorizationArgs']]:
        """
        Define Role-Based Access Control (RBAC) for your users by creating roles and permissions.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['ProjectAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def connectors(self) -> Optional[pulumi.Input['ProjectConnectorsArgs']]:
        """
        Enrich your flows by interacting with third party services.
        """
        return pulumi.get(self, "connectors")

    @connectors.setter
    def connectors(self, value: Optional[pulumi.Input['ProjectConnectorsArgs']]):
        pulumi.set(self, "connectors", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        This can be set to `production` to mark production projects, otherwise this should be left unset for development or staging projects.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def flows(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ProjectFlowsArgs']]]]:
        """
        Custom authentication flows to use in this project.
        """
        return pulumi.get(self, "flows")

    @flows.setter
    def flows(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ProjectFlowsArgs']]]]):
        pulumi.set(self, "flows", value)

    @property
    @pulumi.getter(name="jwtTemplates")
    def jwt_templates(self) -> Optional[pulumi.Input['ProjectJwtTemplatesArgs']]:
        """
        Defines templates for JSON Web Tokens (JWT) used for authentication.
        """
        return pulumi.get(self, "jwt_templates")

    @jwt_templates.setter
    def jwt_templates(self, value: Optional[pulumi.Input['ProjectJwtTemplatesArgs']]):
        pulumi.set(self, "jwt_templates", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Descope project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectSettings")
    def project_settings(self) -> Optional[pulumi.Input['ProjectProjectSettingsArgs']]:
        """
        General settings for the Descope project.
        """
        return pulumi.get(self, "project_settings")

    @project_settings.setter
    def project_settings(self, value: Optional[pulumi.Input['ProjectProjectSettingsArgs']]):
        pulumi.set(self, "project_settings", value)

    @property
    @pulumi.getter
    def styles(self) -> Optional[pulumi.Input['ProjectStylesArgs']]:
        """
        Custom styles that can be applied to the project's authentication flows.
        """
        return pulumi.get(self, "styles")

    @styles.setter
    def styles(self, value: Optional[pulumi.Input['ProjectStylesArgs']]):
        pulumi.set(self, "styles", value)


class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applications: Optional[pulumi.Input[Union['ProjectApplicationsArgs', 'ProjectApplicationsArgsDict']]] = None,
                 attributes: Optional[pulumi.Input[Union['ProjectAttributesArgs', 'ProjectAttributesArgsDict']]] = None,
                 authentication: Optional[pulumi.Input[Union['ProjectAuthenticationArgs', 'ProjectAuthenticationArgsDict']]] = None,
                 authorization: Optional[pulumi.Input[Union['ProjectAuthorizationArgs', 'ProjectAuthorizationArgsDict']]] = None,
                 connectors: Optional[pulumi.Input[Union['ProjectConnectorsArgs', 'ProjectConnectorsArgsDict']]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 flows: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['ProjectFlowsArgs', 'ProjectFlowsArgsDict']]]]] = None,
                 jwt_templates: Optional[pulumi.Input[Union['ProjectJwtTemplatesArgs', 'ProjectJwtTemplatesArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_settings: Optional[pulumi.Input[Union['ProjectProjectSettingsArgs', 'ProjectProjectSettingsArgsDict']]] = None,
                 styles: Optional[pulumi.Input[Union['ProjectStylesArgs', 'ProjectStylesArgsDict']]] = None,
                 __props__=None):
        """
        Create a Project resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectApplicationsArgs', 'ProjectApplicationsArgsDict']] applications: Applications that are registered with the project.
        :param pulumi.Input[Union['ProjectAttributesArgs', 'ProjectAttributesArgsDict']] attributes: Custom attributes that can be attached to users and tenants.
        :param pulumi.Input[Union['ProjectAuthenticationArgs', 'ProjectAuthenticationArgsDict']] authentication: Settings for each authentication method.
        :param pulumi.Input[Union['ProjectAuthorizationArgs', 'ProjectAuthorizationArgsDict']] authorization: Define Role-Based Access Control (RBAC) for your users by creating roles and permissions.
        :param pulumi.Input[Union['ProjectConnectorsArgs', 'ProjectConnectorsArgsDict']] connectors: Enrich your flows by interacting with third party services.
        :param pulumi.Input[str] environment: This can be set to `production` to mark production projects, otherwise this should be left unset for development or staging projects.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['ProjectFlowsArgs', 'ProjectFlowsArgsDict']]]] flows: Custom authentication flows to use in this project.
        :param pulumi.Input[Union['ProjectJwtTemplatesArgs', 'ProjectJwtTemplatesArgsDict']] jwt_templates: Defines templates for JSON Web Tokens (JWT) used for authentication.
        :param pulumi.Input[str] name: The name of the Descope project.
        :param pulumi.Input[Union['ProjectProjectSettingsArgs', 'ProjectProjectSettingsArgsDict']] project_settings: General settings for the Descope project.
        :param pulumi.Input[Union['ProjectStylesArgs', 'ProjectStylesArgsDict']] styles: Custom styles that can be applied to the project's authentication flows.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Project resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applications: Optional[pulumi.Input[Union['ProjectApplicationsArgs', 'ProjectApplicationsArgsDict']]] = None,
                 attributes: Optional[pulumi.Input[Union['ProjectAttributesArgs', 'ProjectAttributesArgsDict']]] = None,
                 authentication: Optional[pulumi.Input[Union['ProjectAuthenticationArgs', 'ProjectAuthenticationArgsDict']]] = None,
                 authorization: Optional[pulumi.Input[Union['ProjectAuthorizationArgs', 'ProjectAuthorizationArgsDict']]] = None,
                 connectors: Optional[pulumi.Input[Union['ProjectConnectorsArgs', 'ProjectConnectorsArgsDict']]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 flows: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['ProjectFlowsArgs', 'ProjectFlowsArgsDict']]]]] = None,
                 jwt_templates: Optional[pulumi.Input[Union['ProjectJwtTemplatesArgs', 'ProjectJwtTemplatesArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_settings: Optional[pulumi.Input[Union['ProjectProjectSettingsArgs', 'ProjectProjectSettingsArgsDict']]] = None,
                 styles: Optional[pulumi.Input[Union['ProjectStylesArgs', 'ProjectStylesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["applications"] = applications
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["connectors"] = connectors
            __props__.__dict__["environment"] = environment
            __props__.__dict__["flows"] = flows
            __props__.__dict__["jwt_templates"] = jwt_templates
            __props__.__dict__["name"] = name
            __props__.__dict__["project_settings"] = project_settings
            __props__.__dict__["styles"] = styles
        super(Project, __self__).__init__(
            'descope:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applications: Optional[pulumi.Input[Union['ProjectApplicationsArgs', 'ProjectApplicationsArgsDict']]] = None,
            attributes: Optional[pulumi.Input[Union['ProjectAttributesArgs', 'ProjectAttributesArgsDict']]] = None,
            authentication: Optional[pulumi.Input[Union['ProjectAuthenticationArgs', 'ProjectAuthenticationArgsDict']]] = None,
            authorization: Optional[pulumi.Input[Union['ProjectAuthorizationArgs', 'ProjectAuthorizationArgsDict']]] = None,
            connectors: Optional[pulumi.Input[Union['ProjectConnectorsArgs', 'ProjectConnectorsArgsDict']]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            flows: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['ProjectFlowsArgs', 'ProjectFlowsArgsDict']]]]] = None,
            jwt_templates: Optional[pulumi.Input[Union['ProjectJwtTemplatesArgs', 'ProjectJwtTemplatesArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_settings: Optional[pulumi.Input[Union['ProjectProjectSettingsArgs', 'ProjectProjectSettingsArgsDict']]] = None,
            styles: Optional[pulumi.Input[Union['ProjectStylesArgs', 'ProjectStylesArgsDict']]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectApplicationsArgs', 'ProjectApplicationsArgsDict']] applications: Applications that are registered with the project.
        :param pulumi.Input[Union['ProjectAttributesArgs', 'ProjectAttributesArgsDict']] attributes: Custom attributes that can be attached to users and tenants.
        :param pulumi.Input[Union['ProjectAuthenticationArgs', 'ProjectAuthenticationArgsDict']] authentication: Settings for each authentication method.
        :param pulumi.Input[Union['ProjectAuthorizationArgs', 'ProjectAuthorizationArgsDict']] authorization: Define Role-Based Access Control (RBAC) for your users by creating roles and permissions.
        :param pulumi.Input[Union['ProjectConnectorsArgs', 'ProjectConnectorsArgsDict']] connectors: Enrich your flows by interacting with third party services.
        :param pulumi.Input[str] environment: This can be set to `production` to mark production projects, otherwise this should be left unset for development or staging projects.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['ProjectFlowsArgs', 'ProjectFlowsArgsDict']]]] flows: Custom authentication flows to use in this project.
        :param pulumi.Input[Union['ProjectJwtTemplatesArgs', 'ProjectJwtTemplatesArgsDict']] jwt_templates: Defines templates for JSON Web Tokens (JWT) used for authentication.
        :param pulumi.Input[str] name: The name of the Descope project.
        :param pulumi.Input[Union['ProjectProjectSettingsArgs', 'ProjectProjectSettingsArgsDict']] project_settings: General settings for the Descope project.
        :param pulumi.Input[Union['ProjectStylesArgs', 'ProjectStylesArgsDict']] styles: Custom styles that can be applied to the project's authentication flows.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["applications"] = applications
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["connectors"] = connectors
        __props__.__dict__["environment"] = environment
        __props__.__dict__["flows"] = flows
        __props__.__dict__["jwt_templates"] = jwt_templates
        __props__.__dict__["name"] = name
        __props__.__dict__["project_settings"] = project_settings
        __props__.__dict__["styles"] = styles
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def applications(self) -> pulumi.Output['outputs.ProjectApplications']:
        """
        Applications that are registered with the project.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output['outputs.ProjectAttributes']:
        """
        Custom attributes that can be attached to users and tenants.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.ProjectAuthentication']:
        """
        Settings for each authentication method.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output['outputs.ProjectAuthorization']:
        """
        Define Role-Based Access Control (RBAC) for your users by creating roles and permissions.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter
    def connectors(self) -> pulumi.Output['outputs.ProjectConnectors']:
        """
        Enrich your flows by interacting with third party services.
        """
        return pulumi.get(self, "connectors")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[str]:
        """
        This can be set to `production` to mark production projects, otherwise this should be left unset for development or staging projects.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def flows(self) -> pulumi.Output[Mapping[str, 'outputs.ProjectFlows']]:
        """
        Custom authentication flows to use in this project.
        """
        return pulumi.get(self, "flows")

    @property
    @pulumi.getter(name="jwtTemplates")
    def jwt_templates(self) -> pulumi.Output['outputs.ProjectJwtTemplates']:
        """
        Defines templates for JSON Web Tokens (JWT) used for authentication.
        """
        return pulumi.get(self, "jwt_templates")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Descope project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectSettings")
    def project_settings(self) -> pulumi.Output['outputs.ProjectProjectSettings']:
        """
        General settings for the Descope project.
        """
        return pulumi.get(self, "project_settings")

    @property
    @pulumi.getter
    def styles(self) -> pulumi.Output['outputs.ProjectStyles']:
        """
        Custom styles that can be applied to the project's authentication flows.
        """
        return pulumi.get(self, "styles")

