<a id="mypy-boto3-ssm-incidents"></a>

# mypy-boto3-ssm-incidents

[![PyPI - mypy-boto3-ssm-incidents](https://img.shields.io/pypi/v/mypy-boto3-ssm-incidents.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm-incidents)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ssm-incidents.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm-incidents)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-ssm-incidents?color=blue)](https://pypistats.org/packages/mypy-boto3-ssm-incidents)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SSMIncidents 1.17.105](https://boto3.amazonaws.com/v1/documentation/api/1.17.105/reference/services/ssm-incidents.html#SSMIncidents)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.22.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ssm-incidents docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ssm_incidents/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ssm-incidents](#mypy-boto3-ssm-incidents)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `SSMIncidents` service.

```bash
python -m pip install boto3-stubs[ssm-incidents]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ssm-incidents]` in your environment:
  `python -m pip install 'boto3-stubs[ssm-incidents]'`

Both type checking and auto-complete should work for `SSMIncidents` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[ssm-incidents]` in your environment:
  `python -m pip install 'boto3-stubs[ssm-incidents]'`

Both type checking and auto-complete should work for `SSMIncidents` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ssm-incidents]` in your environment:
  `python -m pip install 'boto3-stubs[ssm-incidents]'`
- Run `mypy` as usual

Type checking should work for `SSMIncidents` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ssm-incidents]` in your environment:
  `python -m pip install 'boto3-stubs[ssm-incidents]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SSMIncidents` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SSMIncidentsClient` provides annotations for `boto3.client("ssm-incidents")`.

```python
import boto3

from mypy_boto3_ssm_incidents import SSMIncidentsClient

client: SSMIncidentsClient = boto3.client("ssm-incidents")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SSMIncidentsClient = session.client("ssm-incidents")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ssm_incidents.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_ssm_incidents import SSMIncidentsClient
from mypy_boto3_ssm_incidents.paginator import (
    GetResourcePoliciesPaginator,
    ListIncidentRecordsPaginator,
    ListRelatedItemsPaginator,
    ListReplicationSetsPaginator,
    ListResponsePlansPaginator,
    ListTimelineEventsPaginator,
)

client: SSMIncidentsClient = boto3.client("ssm-incidents")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_resource_policies_paginator: GetResourcePoliciesPaginator = client.get_paginator("get_resource_policies")
list_incident_records_paginator: ListIncidentRecordsPaginator = client.get_paginator("list_incident_records")
list_related_items_paginator: ListRelatedItemsPaginator = client.get_paginator("list_related_items")
list_replication_sets_paginator: ListReplicationSetsPaginator = client.get_paginator("list_replication_sets")
list_response_plans_paginator: ListResponsePlansPaginator = client.get_paginator("list_response_plans")
list_timeline_events_paginator: ListTimelineEventsPaginator = client.get_paginator("list_timeline_events")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_ssm_incidents.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_ssm_incidents import SSMIncidentsClient
from mypy_boto3_ssm_incidents.waiter import (
    WaitForReplicationSetActiveWaiter,
    WaitForReplicationSetDeletedWaiter,
)

client: SSMIncidentsClient = boto3.client("ssm-incidents")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
wait_for_replication_set_active_waiter: WaitForReplicationSetActiveWaiter = client.get_waiter("wait_for_replication_set_active")
wait_for_replication_set_deleted_waiter: WaitForReplicationSetDeletedWaiter = client.get_waiter("wait_for_replication_set_deleted")
```

<a id="literals"></a>

### Literals

`mypy_boto3_ssm_incidents.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_ssm_incidents.literals import (
    GetResourcePoliciesPaginatorName,
    IncidentRecordStatusType,
    ItemTypeType,
    ListIncidentRecordsPaginatorName,
    ListRelatedItemsPaginatorName,
    ListReplicationSetsPaginatorName,
    ListResponsePlansPaginatorName,
    ListTimelineEventsPaginatorName,
    RegionStatusType,
    ReplicationSetStatusType,
    SortOrderType,
    SsmTargetAccountType,
    TimelineEventSortType,
    WaitForReplicationSetActiveWaiterName,
    WaitForReplicationSetDeletedWaiterName,
)

def check_value(value: GetResourcePoliciesPaginatorName) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ssm_incidents.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_ssm_incidents.type_defs import (
    ActionTypeDef,
    AddRegionActionTypeDef,
    AttributeValueListTypeDef,
    AutomationExecutionTypeDef,
    ChatChannelTypeDef,
    ConditionTypeDef,
    CreateReplicationSetInputRequestTypeDef,
    CreateReplicationSetOutputTypeDef,
    CreateResponsePlanInputRequestTypeDef,
    CreateResponsePlanOutputTypeDef,
    CreateTimelineEventInputRequestTypeDef,
    CreateTimelineEventOutputTypeDef,
    DeleteIncidentRecordInputRequestTypeDef,
    DeleteRegionActionTypeDef,
    DeleteReplicationSetInputRequestTypeDef,
    DeleteResourcePolicyInputRequestTypeDef,
    DeleteResponsePlanInputRequestTypeDef,
    DeleteTimelineEventInputRequestTypeDef,
    EventSummaryTypeDef,
    FilterTypeDef,
    GetIncidentRecordInputRequestTypeDef,
    GetIncidentRecordOutputTypeDef,
    GetReplicationSetInputRequestTypeDef,
    GetReplicationSetOutputTypeDef,
    GetResourcePoliciesInputRequestTypeDef,
    GetResourcePoliciesOutputTypeDef,
    GetResponsePlanInputRequestTypeDef,
    GetResponsePlanOutputTypeDef,
    GetTimelineEventInputRequestTypeDef,
    GetTimelineEventOutputTypeDef,
    IncidentRecordSourceTypeDef,
    IncidentRecordSummaryTypeDef,
    IncidentRecordTypeDef,
    IncidentTemplateTypeDef,
    ItemIdentifierTypeDef,
    ItemValueTypeDef,
    ListIncidentRecordsInputRequestTypeDef,
    ListIncidentRecordsOutputTypeDef,
    ListRelatedItemsInputRequestTypeDef,
    ListRelatedItemsOutputTypeDef,
    ListReplicationSetsInputRequestTypeDef,
    ListReplicationSetsOutputTypeDef,
    ListResponsePlansInputRequestTypeDef,
    ListResponsePlansOutputTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTimelineEventsInputRequestTypeDef,
    ListTimelineEventsOutputTypeDef,
    NotificationTargetItemTypeDef,
    PaginatorConfigTypeDef,
    PutResourcePolicyInputRequestTypeDef,
    PutResourcePolicyOutputTypeDef,
    RegionInfoTypeDef,
    RegionMapInputValueTypeDef,
    RelatedItemTypeDef,
    RelatedItemsUpdateTypeDef,
    ReplicationSetTypeDef,
    ResourcePolicyTypeDef,
    ResponseMetadataTypeDef,
    ResponsePlanSummaryTypeDef,
    SsmAutomationTypeDef,
    StartIncidentInputRequestTypeDef,
    StartIncidentOutputTypeDef,
    TagResourceRequestRequestTypeDef,
    TimelineEventTypeDef,
    TriggerDetailsTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateDeletionProtectionInputRequestTypeDef,
    UpdateIncidentRecordInputRequestTypeDef,
    UpdateRelatedItemsInputRequestTypeDef,
    UpdateReplicationSetActionTypeDef,
    UpdateReplicationSetInputRequestTypeDef,
    UpdateResponsePlanInputRequestTypeDef,
    UpdateTimelineEventInputRequestTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> ActionTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-ssm-incidents` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-ssm-incidents docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ssm_incidents/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
