# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict
from typing_extensions import Literal, Required, Annotated, TypedDict

from .._utils import PropertyInfo

__all__ = ["TransactionalSendParams"]


class TransactionalSendParams(TypedDict, total=False):
    template_id: Required[str]
    """The template identifier."""

    to: Required[str]
    """The recipient's phone number."""

    callback_url: str
    """The callback URL."""

    correlation_id: str
    """A user-defined identifier to correlate this transactional message with.

    It is returned in the response and any webhook events that refer to this
    transactionalmessage.
    """

    expires_at: str
    """The message expiration date."""

    from_: Annotated[str, PropertyInfo(alias="from")]
    """The Sender ID."""

    locale: str
    """
    A BCP-47 formatted locale string with the language the text message will be sent
    to. If there's no locale set, the language will be determined by the country
    code of the phone number. If the language specified doesn't exist, the default
    set on the template will be used.
    """

    preferred_channel: Literal["sms", "rcs", "whatsapp"]
    """The preferred delivery channel for the message.

    When specified, the system will prioritize sending via the requested channel if
    the template is configured for it.

    If not specified and the template is configured for WhatsApp, the message will
    be sent via WhatsApp first, with automatic fallback to SMS if WhatsApp delivery
    is unavailable.

    Supported channels: `sms`, `rcs`, `whatsapp`.
    """

    variables: Dict[str, str]
    """The variables to be replaced in the template."""
