# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PhoneProviderArgs', 'PhoneProvider']

@pulumi.input_type
class PhoneProviderArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input['PhoneProviderConfigurationArgs'],
                 credentials: pulumi.Input['PhoneProviderCredentialsArgs'],
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PhoneProvider resource.
        :param pulumi.Input['PhoneProviderConfigurationArgs'] configuration: Specific phone provider settings.
        :param pulumi.Input['PhoneProviderCredentialsArgs'] credentials: Provider credentials required to use authenticate to the provider.
        :param pulumi.Input[builtins.bool] disabled: Indicates whether the phone provider is enabled (false) or disabled (true).
        :param pulumi.Input[builtins.str] name: Name of the phone provider. Options include `twilio`, `custom`.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "credentials", credentials)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['PhoneProviderConfigurationArgs']:
        """
        Specific phone provider settings.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['PhoneProviderConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input['PhoneProviderCredentialsArgs']:
        """
        Provider credentials required to use authenticate to the provider.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input['PhoneProviderCredentialsArgs']):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the phone provider is enabled (false) or disabled (true).
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the phone provider. Options include `twilio`, `custom`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PhoneProviderState:
    def __init__(__self__, *,
                 channel: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input['PhoneProviderConfigurationArgs']] = None,
                 credentials: Optional[pulumi.Input['PhoneProviderCredentialsArgs']] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tenant: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PhoneProvider resources.
        :param pulumi.Input[builtins.str] channel: The channel of the phone provider.
        :param pulumi.Input['PhoneProviderConfigurationArgs'] configuration: Specific phone provider settings.
        :param pulumi.Input['PhoneProviderCredentialsArgs'] credentials: Provider credentials required to use authenticate to the provider.
        :param pulumi.Input[builtins.bool] disabled: Indicates whether the phone provider is enabled (false) or disabled (true).
        :param pulumi.Input[builtins.str] name: Name of the phone provider. Options include `twilio`, `custom`.
        :param pulumi.Input[builtins.str] tenant: The tenant of the phone provider.
        """
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The channel of the phone provider.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['PhoneProviderConfigurationArgs']]:
        """
        Specific phone provider settings.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['PhoneProviderConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['PhoneProviderCredentialsArgs']]:
        """
        Provider credentials required to use authenticate to the provider.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['PhoneProviderCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the phone provider is enabled (false) or disabled (true).
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the phone provider. Options include `twilio`, `custom`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The tenant of the phone provider.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant", value)


class PhoneProvider(pulumi.CustomResource):

    pulumi_type = "auth0:index/phoneProvider:PhoneProvider"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['PhoneProviderConfigurationArgs', 'PhoneProviderConfigurationArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['PhoneProviderCredentialsArgs', 'PhoneProviderCredentialsArgsDict']]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Auth0 allows you to configure your own phone messaging provider to help you manage, monitor, and troubleshoot your SMS and voice communications. You can only configure one phone provider for all SMS and voice communications per tenant.

        !> This resource manages to create a max of 1 phone provider for a tenant.
        To avoid potential issues, it is recommended not to try creating multiple phone providers on the same tenant.

        !> If you are using the `PhoneProvider` resource to create a `custom` phone provider, you must ensure an action is created first with `custom-phone-provider` as the supported_triggers

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example on how to set up the phone provider with Twilio.
        twilio_phone_provider = auth0.PhoneProvider("twilio_phone_provider",
            name="twilio",
            disabled=False,
            credentials={
                "auth_token": "secretAuthToken",
            },
            configuration={
                "delivery_methods": [
                    "text",
                    "voice",
                ],
                "default_from": "+1234567890",
                "sid": "ACXXXXXXXXXXXXXXXX",
                "mssid": "MSXXXXXXXXXXXXXXXX",
            })
        # This is an example on how to set up the phone provider with a custom action.
        # Make sure a corresponding action exists with custom-phone-provider as supported triggers
        send_custom_phone = auth0.Action("send_custom_phone",
            name="Custom Phone Provider",
            runtime="node18",
            deploy=True,
            code=\"\"\"/**
         * Handler to be executed while sending a phone notification
         * @param {Event} event - Details about the user and the context in which they are logging in.
         * @param {CustomPhoneProviderAPI} api - Methods and utilities to help change the behavior of sending a phone notification.
         */
        exports.onExecuteCustomPhoneProvider = async (event, api) => {
            // Code goes here
            return;
        };
        \"\"\",
            supported_triggers={
                "id": "custom-phone-provider",
                "version": "v1",
            })
        custom_phone_provider = auth0.PhoneProvider("custom_phone_provider",
            name="custom",
            disabled=False,
            configuration={
                "delivery_methods": [
                    "text",
                    "voice",
                ],
            },
            credentials={},
            opts = pulumi.ResourceOptions(depends_on=[send_custom_phone]))
        ```

        ## Import

        This resource can be imported by specifying the phone Provider ID.

        Example:

        ```sh
        $ pulumi import auth0:index/phoneProvider:PhoneProvider my_phone_provider "pro_XXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PhoneProviderConfigurationArgs', 'PhoneProviderConfigurationArgsDict']] configuration: Specific phone provider settings.
        :param pulumi.Input[Union['PhoneProviderCredentialsArgs', 'PhoneProviderCredentialsArgsDict']] credentials: Provider credentials required to use authenticate to the provider.
        :param pulumi.Input[builtins.bool] disabled: Indicates whether the phone provider is enabled (false) or disabled (true).
        :param pulumi.Input[builtins.str] name: Name of the phone provider. Options include `twilio`, `custom`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PhoneProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Auth0 allows you to configure your own phone messaging provider to help you manage, monitor, and troubleshoot your SMS and voice communications. You can only configure one phone provider for all SMS and voice communications per tenant.

        !> This resource manages to create a max of 1 phone provider for a tenant.
        To avoid potential issues, it is recommended not to try creating multiple phone providers on the same tenant.

        !> If you are using the `PhoneProvider` resource to create a `custom` phone provider, you must ensure an action is created first with `custom-phone-provider` as the supported_triggers

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # This is an example on how to set up the phone provider with Twilio.
        twilio_phone_provider = auth0.PhoneProvider("twilio_phone_provider",
            name="twilio",
            disabled=False,
            credentials={
                "auth_token": "secretAuthToken",
            },
            configuration={
                "delivery_methods": [
                    "text",
                    "voice",
                ],
                "default_from": "+1234567890",
                "sid": "ACXXXXXXXXXXXXXXXX",
                "mssid": "MSXXXXXXXXXXXXXXXX",
            })
        # This is an example on how to set up the phone provider with a custom action.
        # Make sure a corresponding action exists with custom-phone-provider as supported triggers
        send_custom_phone = auth0.Action("send_custom_phone",
            name="Custom Phone Provider",
            runtime="node18",
            deploy=True,
            code=\"\"\"/**
         * Handler to be executed while sending a phone notification
         * @param {Event} event - Details about the user and the context in which they are logging in.
         * @param {CustomPhoneProviderAPI} api - Methods and utilities to help change the behavior of sending a phone notification.
         */
        exports.onExecuteCustomPhoneProvider = async (event, api) => {
            // Code goes here
            return;
        };
        \"\"\",
            supported_triggers={
                "id": "custom-phone-provider",
                "version": "v1",
            })
        custom_phone_provider = auth0.PhoneProvider("custom_phone_provider",
            name="custom",
            disabled=False,
            configuration={
                "delivery_methods": [
                    "text",
                    "voice",
                ],
            },
            credentials={},
            opts = pulumi.ResourceOptions(depends_on=[send_custom_phone]))
        ```

        ## Import

        This resource can be imported by specifying the phone Provider ID.

        Example:

        ```sh
        $ pulumi import auth0:index/phoneProvider:PhoneProvider my_phone_provider "pro_XXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param PhoneProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PhoneProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['PhoneProviderConfigurationArgs', 'PhoneProviderConfigurationArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['PhoneProviderCredentialsArgs', 'PhoneProviderCredentialsArgsDict']]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PhoneProviderArgs.__new__(PhoneProviderArgs)

            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            if credentials is None and not opts.urn:
                raise TypeError("Missing required property 'credentials'")
            __props__.__dict__["credentials"] = credentials
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["name"] = name
            __props__.__dict__["channel"] = None
            __props__.__dict__["tenant"] = None
        super(PhoneProvider, __self__).__init__(
            'auth0:index/phoneProvider:PhoneProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channel: Optional[pulumi.Input[builtins.str]] = None,
            configuration: Optional[pulumi.Input[Union['PhoneProviderConfigurationArgs', 'PhoneProviderConfigurationArgsDict']]] = None,
            credentials: Optional[pulumi.Input[Union['PhoneProviderCredentialsArgs', 'PhoneProviderCredentialsArgsDict']]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            tenant: Optional[pulumi.Input[builtins.str]] = None) -> 'PhoneProvider':
        """
        Get an existing PhoneProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] channel: The channel of the phone provider.
        :param pulumi.Input[Union['PhoneProviderConfigurationArgs', 'PhoneProviderConfigurationArgsDict']] configuration: Specific phone provider settings.
        :param pulumi.Input[Union['PhoneProviderCredentialsArgs', 'PhoneProviderCredentialsArgsDict']] credentials: Provider credentials required to use authenticate to the provider.
        :param pulumi.Input[builtins.bool] disabled: Indicates whether the phone provider is enabled (false) or disabled (true).
        :param pulumi.Input[builtins.str] name: Name of the phone provider. Options include `twilio`, `custom`.
        :param pulumi.Input[builtins.str] tenant: The tenant of the phone provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PhoneProviderState.__new__(_PhoneProviderState)

        __props__.__dict__["channel"] = channel
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant"] = tenant
        return PhoneProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Output[builtins.str]:
        """
        The channel of the phone provider.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.PhoneProviderConfiguration']:
        """
        Specific phone provider settings.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.PhoneProviderCredentials']:
        """
        Provider credentials required to use authenticate to the provider.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the phone provider is enabled (false) or disabled (true).
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the phone provider. Options include `twilio`, `custom`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tenant(self) -> pulumi.Output[builtins.str]:
        """
        The tenant of the phone provider.
        """
        return pulumi.get(self, "tenant")

