# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RolePermissionArgs', 'RolePermission']

@pulumi.input_type
class RolePermissionArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[builtins.str],
                 resource_server_identifier: pulumi.Input[builtins.str],
                 role_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a RolePermission resource.
        :param pulumi.Input[builtins.str] permission: Name of the permission.
        :param pulumi.Input[builtins.str] resource_server_identifier: Identifier of the resource server that the permission is associated with.
        :param pulumi.Input[builtins.str] role_id: ID of the role to associate the permission to.
        """
        pulumi.set(__self__, "permission", permission)
        pulumi.set(__self__, "resource_server_identifier", resource_server_identifier)
        pulumi.set(__self__, "role_id", role_id)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[builtins.str]:
        """
        Name of the permission.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="resourceServerIdentifier")
    def resource_server_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the resource server that the permission is associated with.
        """
        return pulumi.get(self, "resource_server_identifier")

    @resource_server_identifier.setter
    def resource_server_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_server_identifier", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the role to associate the permission to.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_id", value)


@pulumi.input_type
class _RolePermissionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 permission: Optional[pulumi.Input[builtins.str]] = None,
                 resource_server_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 resource_server_name: Optional[pulumi.Input[builtins.str]] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RolePermission resources.
        :param pulumi.Input[builtins.str] description: Description of the permission.
        :param pulumi.Input[builtins.str] permission: Name of the permission.
        :param pulumi.Input[builtins.str] resource_server_identifier: Identifier of the resource server that the permission is associated with.
        :param pulumi.Input[builtins.str] resource_server_name: Name of the resource server that the permission is associated with.
        :param pulumi.Input[builtins.str] role_id: ID of the role to associate the permission to.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if resource_server_identifier is not None:
            pulumi.set(__self__, "resource_server_identifier", resource_server_identifier)
        if resource_server_name is not None:
            pulumi.set(__self__, "resource_server_name", resource_server_name)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the permission.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the permission.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="resourceServerIdentifier")
    def resource_server_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the resource server that the permission is associated with.
        """
        return pulumi.get(self, "resource_server_identifier")

    @resource_server_identifier.setter
    def resource_server_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_server_identifier", value)

    @property
    @pulumi.getter(name="resourceServerName")
    def resource_server_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource server that the permission is associated with.
        """
        return pulumi.get(self, "resource_server_name")

    @resource_server_name.setter
    def resource_server_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_server_name", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the role to associate the permission to.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_id", value)


class RolePermission(pulumi.CustomResource):

    pulumi_type = "auth0:index/rolePermission:RolePermission"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permission: Optional[pulumi.Input[builtins.str]] = None,
                 resource_server_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        With this resource, you can manage role permissions (1-1).

        !> This resource appends a permission to a role. In contrast, the `RolePermissions` resource manages all the
        permissions assigned to a role. To avoid potential issues, it is recommended not to use this resource in conjunction
        with the `RolePermissions` resource when managing permissions for the same role id.

        ## Import

        This resource can be imported by specifying the

        role ID, resource identifier, and permission name separated by "::" (note the double colon)

        <roleID>::<resourceServerIdentifier>::<permission>

        Example:

        ```sh
        $ pulumi import auth0:index/rolePermission:RolePermission permission "rol_XXXXXXXXXXXXX::https://example.com::read:foo"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] permission: Name of the permission.
        :param pulumi.Input[builtins.str] resource_server_identifier: Identifier of the resource server that the permission is associated with.
        :param pulumi.Input[builtins.str] role_id: ID of the role to associate the permission to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RolePermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can manage role permissions (1-1).

        !> This resource appends a permission to a role. In contrast, the `RolePermissions` resource manages all the
        permissions assigned to a role. To avoid potential issues, it is recommended not to use this resource in conjunction
        with the `RolePermissions` resource when managing permissions for the same role id.

        ## Import

        This resource can be imported by specifying the

        role ID, resource identifier, and permission name separated by "::" (note the double colon)

        <roleID>::<resourceServerIdentifier>::<permission>

        Example:

        ```sh
        $ pulumi import auth0:index/rolePermission:RolePermission permission "rol_XXXXXXXXXXXXX::https://example.com::read:foo"
        ```

        :param str resource_name: The name of the resource.
        :param RolePermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RolePermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permission: Optional[pulumi.Input[builtins.str]] = None,
                 resource_server_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RolePermissionArgs.__new__(RolePermissionArgs)

            if permission is None and not opts.urn:
                raise TypeError("Missing required property 'permission'")
            __props__.__dict__["permission"] = permission
            if resource_server_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'resource_server_identifier'")
            __props__.__dict__["resource_server_identifier"] = resource_server_identifier
            if role_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_id'")
            __props__.__dict__["role_id"] = role_id
            __props__.__dict__["description"] = None
            __props__.__dict__["resource_server_name"] = None
        super(RolePermission, __self__).__init__(
            'auth0:index/rolePermission:RolePermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            permission: Optional[pulumi.Input[builtins.str]] = None,
            resource_server_identifier: Optional[pulumi.Input[builtins.str]] = None,
            resource_server_name: Optional[pulumi.Input[builtins.str]] = None,
            role_id: Optional[pulumi.Input[builtins.str]] = None) -> 'RolePermission':
        """
        Get an existing RolePermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the permission.
        :param pulumi.Input[builtins.str] permission: Name of the permission.
        :param pulumi.Input[builtins.str] resource_server_identifier: Identifier of the resource server that the permission is associated with.
        :param pulumi.Input[builtins.str] resource_server_name: Name of the resource server that the permission is associated with.
        :param pulumi.Input[builtins.str] role_id: ID of the role to associate the permission to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RolePermissionState.__new__(_RolePermissionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["permission"] = permission
        __props__.__dict__["resource_server_identifier"] = resource_server_identifier
        __props__.__dict__["resource_server_name"] = resource_server_name
        __props__.__dict__["role_id"] = role_id
        return RolePermission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the permission.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Output[builtins.str]:
        """
        Name of the permission.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="resourceServerIdentifier")
    def resource_server_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the resource server that the permission is associated with.
        """
        return pulumi.get(self, "resource_server_identifier")

    @property
    @pulumi.getter(name="resourceServerName")
    def resource_server_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource server that the permission is associated with.
        """
        return pulumi.get(self, "resource_server_name")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the role to associate the permission to.
        """
        return pulumi.get(self, "role_id")

