"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
/**
 * (experimental) A Python Lambda function.
 *
 * @experimental
 */
class PythonFunction extends aws_lambda_1.Function {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonFunctionProps(props);
        const { index = 'index.py', handler = 'handler', runtime } = props;
        if (props.index && !/\.py$/.test(props.index)) {
            throw new Error('Only Python (.py) index files are supported.');
        }
        // Entry
        const entry = path.resolve(props.entry);
        const resolvedIndex = path.resolve(entry, index);
        if (!fs.existsSync(resolvedIndex)) {
            throw new Error(`Cannot find index file at ${resolvedIndex}`);
        }
        const resolvedHandler = `${index.slice(0, -3)}.${handler}`.replace('/', '.');
        if (props.runtime && props.runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only `PYTHON` runtimes are supported.');
        }
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                ...props.bundling,
            }),
            handler: resolvedHandler,
        });
    }
}
exports.PythonFunction = PythonFunction;
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonFunction", version: "2.12.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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