/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ActiveDirectoryDomainServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#domain_configuration_type ActiveDirectoryDomainService#domain_configuration_type}
    */
    readonly domainConfigurationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#domain_name ActiveDirectoryDomainService#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#filtered_sync_enabled ActiveDirectoryDomainService#filtered_sync_enabled}
    */
    readonly filteredSyncEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#id ActiveDirectoryDomainService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#location ActiveDirectoryDomainService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#name ActiveDirectoryDomainService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#resource_group_name ActiveDirectoryDomainService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#sku ActiveDirectoryDomainService#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#tags ActiveDirectoryDomainService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * initial_replica_set block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#initial_replica_set ActiveDirectoryDomainService#initial_replica_set}
    */
    readonly initialReplicaSet: ActiveDirectoryDomainServiceInitialReplicaSet;
    /**
    * notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#notifications ActiveDirectoryDomainService#notifications}
    */
    readonly notifications?: ActiveDirectoryDomainServiceNotifications;
    /**
    * secure_ldap block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#secure_ldap ActiveDirectoryDomainService#secure_ldap}
    */
    readonly secureLdap?: ActiveDirectoryDomainServiceSecureLdap;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#security ActiveDirectoryDomainService#security}
    */
    readonly security?: ActiveDirectoryDomainServiceSecurity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#timeouts ActiveDirectoryDomainService#timeouts}
    */
    readonly timeouts?: ActiveDirectoryDomainServiceTimeouts;
}
export interface ActiveDirectoryDomainServiceInitialReplicaSet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#subnet_id ActiveDirectoryDomainService#subnet_id}
    */
    readonly subnetId: string;
}
export declare function activeDirectoryDomainServiceInitialReplicaSetToTerraform(struct?: ActiveDirectoryDomainServiceInitialReplicaSetOutputReference | ActiveDirectoryDomainServiceInitialReplicaSet): any;
export declare function activeDirectoryDomainServiceInitialReplicaSetToHclTerraform(struct?: ActiveDirectoryDomainServiceInitialReplicaSetOutputReference | ActiveDirectoryDomainServiceInitialReplicaSet): any;
export declare class ActiveDirectoryDomainServiceInitialReplicaSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ActiveDirectoryDomainServiceInitialReplicaSet | undefined;
    set internalValue(value: ActiveDirectoryDomainServiceInitialReplicaSet | undefined);
    get domainControllerIpAddresses(): string[];
    get externalAccessIpAddress(): string;
    get id(): string;
    get location(): string;
    get serviceStatus(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export interface ActiveDirectoryDomainServiceNotifications {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#additional_recipients ActiveDirectoryDomainService#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#notify_dc_admins ActiveDirectoryDomainService#notify_dc_admins}
    */
    readonly notifyDcAdmins?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#notify_global_admins ActiveDirectoryDomainService#notify_global_admins}
    */
    readonly notifyGlobalAdmins?: boolean | cdktf.IResolvable;
}
export declare function activeDirectoryDomainServiceNotificationsToTerraform(struct?: ActiveDirectoryDomainServiceNotificationsOutputReference | ActiveDirectoryDomainServiceNotifications): any;
export declare function activeDirectoryDomainServiceNotificationsToHclTerraform(struct?: ActiveDirectoryDomainServiceNotificationsOutputReference | ActiveDirectoryDomainServiceNotifications): any;
export declare class ActiveDirectoryDomainServiceNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ActiveDirectoryDomainServiceNotifications | undefined;
    set internalValue(value: ActiveDirectoryDomainServiceNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _notifyDcAdmins?;
    get notifyDcAdmins(): boolean | cdktf.IResolvable;
    set notifyDcAdmins(value: boolean | cdktf.IResolvable);
    resetNotifyDcAdmins(): void;
    get notifyDcAdminsInput(): boolean | cdktf.IResolvable | undefined;
    private _notifyGlobalAdmins?;
    get notifyGlobalAdmins(): boolean | cdktf.IResolvable;
    set notifyGlobalAdmins(value: boolean | cdktf.IResolvable);
    resetNotifyGlobalAdmins(): void;
    get notifyGlobalAdminsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ActiveDirectoryDomainServiceSecureLdap {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#enabled ActiveDirectoryDomainService#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#external_access_enabled ActiveDirectoryDomainService#external_access_enabled}
    */
    readonly externalAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#pfx_certificate ActiveDirectoryDomainService#pfx_certificate}
    */
    readonly pfxCertificate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#pfx_certificate_password ActiveDirectoryDomainService#pfx_certificate_password}
    */
    readonly pfxCertificatePassword: string;
}
export declare function activeDirectoryDomainServiceSecureLdapToTerraform(struct?: ActiveDirectoryDomainServiceSecureLdapOutputReference | ActiveDirectoryDomainServiceSecureLdap): any;
export declare function activeDirectoryDomainServiceSecureLdapToHclTerraform(struct?: ActiveDirectoryDomainServiceSecureLdapOutputReference | ActiveDirectoryDomainServiceSecureLdap): any;
export declare class ActiveDirectoryDomainServiceSecureLdapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ActiveDirectoryDomainServiceSecureLdap | undefined;
    set internalValue(value: ActiveDirectoryDomainServiceSecureLdap | undefined);
    get certificateExpiry(): string;
    get certificateThumbprint(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _externalAccessEnabled?;
    get externalAccessEnabled(): boolean | cdktf.IResolvable;
    set externalAccessEnabled(value: boolean | cdktf.IResolvable);
    resetExternalAccessEnabled(): void;
    get externalAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _pfxCertificate?;
    get pfxCertificate(): string;
    set pfxCertificate(value: string);
    get pfxCertificateInput(): string | undefined;
    private _pfxCertificatePassword?;
    get pfxCertificatePassword(): string;
    set pfxCertificatePassword(value: string);
    get pfxCertificatePasswordInput(): string | undefined;
    get publicCertificate(): string;
}
export interface ActiveDirectoryDomainServiceSecurity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#kerberos_armoring_enabled ActiveDirectoryDomainService#kerberos_armoring_enabled}
    */
    readonly kerberosArmoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#kerberos_rc4_encryption_enabled ActiveDirectoryDomainService#kerberos_rc4_encryption_enabled}
    */
    readonly kerberosRc4EncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#ntlm_v1_enabled ActiveDirectoryDomainService#ntlm_v1_enabled}
    */
    readonly ntlmV1Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#sync_kerberos_passwords ActiveDirectoryDomainService#sync_kerberos_passwords}
    */
    readonly syncKerberosPasswords?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#sync_ntlm_passwords ActiveDirectoryDomainService#sync_ntlm_passwords}
    */
    readonly syncNtlmPasswords?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#sync_on_prem_passwords ActiveDirectoryDomainService#sync_on_prem_passwords}
    */
    readonly syncOnPremPasswords?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#tls_v1_enabled ActiveDirectoryDomainService#tls_v1_enabled}
    */
    readonly tlsV1Enabled?: boolean | cdktf.IResolvable;
}
export declare function activeDirectoryDomainServiceSecurityToTerraform(struct?: ActiveDirectoryDomainServiceSecurityOutputReference | ActiveDirectoryDomainServiceSecurity): any;
export declare function activeDirectoryDomainServiceSecurityToHclTerraform(struct?: ActiveDirectoryDomainServiceSecurityOutputReference | ActiveDirectoryDomainServiceSecurity): any;
export declare class ActiveDirectoryDomainServiceSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ActiveDirectoryDomainServiceSecurity | undefined;
    set internalValue(value: ActiveDirectoryDomainServiceSecurity | undefined);
    private _kerberosArmoringEnabled?;
    get kerberosArmoringEnabled(): boolean | cdktf.IResolvable;
    set kerberosArmoringEnabled(value: boolean | cdktf.IResolvable);
    resetKerberosArmoringEnabled(): void;
    get kerberosArmoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberosRc4EncryptionEnabled?;
    get kerberosRc4EncryptionEnabled(): boolean | cdktf.IResolvable;
    set kerberosRc4EncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetKerberosRc4EncryptionEnabled(): void;
    get kerberosRc4EncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ntlmV1Enabled?;
    get ntlmV1Enabled(): boolean | cdktf.IResolvable;
    set ntlmV1Enabled(value: boolean | cdktf.IResolvable);
    resetNtlmV1Enabled(): void;
    get ntlmV1EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _syncKerberosPasswords?;
    get syncKerberosPasswords(): boolean | cdktf.IResolvable;
    set syncKerberosPasswords(value: boolean | cdktf.IResolvable);
    resetSyncKerberosPasswords(): void;
    get syncKerberosPasswordsInput(): boolean | cdktf.IResolvable | undefined;
    private _syncNtlmPasswords?;
    get syncNtlmPasswords(): boolean | cdktf.IResolvable;
    set syncNtlmPasswords(value: boolean | cdktf.IResolvable);
    resetSyncNtlmPasswords(): void;
    get syncNtlmPasswordsInput(): boolean | cdktf.IResolvable | undefined;
    private _syncOnPremPasswords?;
    get syncOnPremPasswords(): boolean | cdktf.IResolvable;
    set syncOnPremPasswords(value: boolean | cdktf.IResolvable);
    resetSyncOnPremPasswords(): void;
    get syncOnPremPasswordsInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsV1Enabled?;
    get tlsV1Enabled(): boolean | cdktf.IResolvable;
    set tlsV1Enabled(value: boolean | cdktf.IResolvable);
    resetTlsV1Enabled(): void;
    get tlsV1EnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ActiveDirectoryDomainServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#create ActiveDirectoryDomainService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#delete ActiveDirectoryDomainService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#read ActiveDirectoryDomainService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#update ActiveDirectoryDomainService#update}
    */
    readonly update?: string;
}
export declare function activeDirectoryDomainServiceTimeoutsToTerraform(struct?: ActiveDirectoryDomainServiceTimeouts | cdktf.IResolvable): any;
export declare function activeDirectoryDomainServiceTimeoutsToHclTerraform(struct?: ActiveDirectoryDomainServiceTimeouts | cdktf.IResolvable): any;
export declare class ActiveDirectoryDomainServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ActiveDirectoryDomainServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ActiveDirectoryDomainServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service azurerm_active_directory_domain_service}
*/
export declare class ActiveDirectoryDomainService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_active_directory_domain_service";
    /**
    * Generates CDKTF code for importing a ActiveDirectoryDomainService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ActiveDirectoryDomainService to import
    * @param importFromId The id of the existing ActiveDirectoryDomainService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ActiveDirectoryDomainService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/active_directory_domain_service azurerm_active_directory_domain_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ActiveDirectoryDomainServiceConfig
    */
    constructor(scope: Construct, id: string, config: ActiveDirectoryDomainServiceConfig);
    get deploymentId(): string;
    private _domainConfigurationType?;
    get domainConfigurationType(): string;
    set domainConfigurationType(value: string);
    resetDomainConfigurationType(): void;
    get domainConfigurationTypeInput(): string | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _filteredSyncEnabled?;
    get filteredSyncEnabled(): boolean | cdktf.IResolvable;
    set filteredSyncEnabled(value: boolean | cdktf.IResolvable);
    resetFilteredSyncEnabled(): void;
    get filteredSyncEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get resourceId(): string;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    get syncOwner(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get tenantId(): string;
    get version(): number;
    private _initialReplicaSet;
    get initialReplicaSet(): ActiveDirectoryDomainServiceInitialReplicaSetOutputReference;
    putInitialReplicaSet(value: ActiveDirectoryDomainServiceInitialReplicaSet): void;
    get initialReplicaSetInput(): ActiveDirectoryDomainServiceInitialReplicaSet | undefined;
    private _notifications;
    get notifications(): ActiveDirectoryDomainServiceNotificationsOutputReference;
    putNotifications(value: ActiveDirectoryDomainServiceNotifications): void;
    resetNotifications(): void;
    get notificationsInput(): ActiveDirectoryDomainServiceNotifications | undefined;
    private _secureLdap;
    get secureLdap(): ActiveDirectoryDomainServiceSecureLdapOutputReference;
    putSecureLdap(value: ActiveDirectoryDomainServiceSecureLdap): void;
    resetSecureLdap(): void;
    get secureLdapInput(): ActiveDirectoryDomainServiceSecureLdap | undefined;
    private _security;
    get security(): ActiveDirectoryDomainServiceSecurityOutputReference;
    putSecurity(value: ActiveDirectoryDomainServiceSecurity): void;
    resetSecurity(): void;
    get securityInput(): ActiveDirectoryDomainServiceSecurity | undefined;
    private _timeouts;
    get timeouts(): ActiveDirectoryDomainServiceTimeoutsOutputReference;
    putTimeouts(value: ActiveDirectoryDomainServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ActiveDirectoryDomainServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
