/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdvisorSuppressionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#id AdvisorSuppression#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#name AdvisorSuppression#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#recommendation_id AdvisorSuppression#recommendation_id}
    */
    readonly recommendationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#resource_id AdvisorSuppression#resource_id}
    */
    readonly resourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#ttl AdvisorSuppression#ttl}
    */
    readonly ttl?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#timeouts AdvisorSuppression#timeouts}
    */
    readonly timeouts?: AdvisorSuppressionTimeouts;
}
export interface AdvisorSuppressionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#create AdvisorSuppression#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#delete AdvisorSuppression#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#read AdvisorSuppression#read}
    */
    readonly read?: string;
}
export declare function advisorSuppressionTimeoutsToTerraform(struct?: AdvisorSuppressionTimeouts | cdktf.IResolvable): any;
export declare function advisorSuppressionTimeoutsToHclTerraform(struct?: AdvisorSuppressionTimeouts | cdktf.IResolvable): any;
export declare class AdvisorSuppressionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvisorSuppressionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AdvisorSuppressionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression azurerm_advisor_suppression}
*/
export declare class AdvisorSuppression extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_advisor_suppression";
    /**
    * Generates CDKTF code for importing a AdvisorSuppression resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AdvisorSuppression to import
    * @param importFromId The id of the existing AdvisorSuppression that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AdvisorSuppression to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/advisor_suppression azurerm_advisor_suppression} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdvisorSuppressionConfig
    */
    constructor(scope: Construct, id: string, config: AdvisorSuppressionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recommendationId?;
    get recommendationId(): string;
    set recommendationId(value: string);
    get recommendationIdInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    get suppressionId(): string;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _timeouts;
    get timeouts(): AdvisorSuppressionTimeoutsOutputReference;
    putTimeouts(value: AdvisorSuppressionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AdvisorSuppressionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
