/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppConfigurationFeatureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#configuration_store_id AppConfigurationFeature#configuration_store_id}
    */
    readonly configurationStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#description AppConfigurationFeature#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#enabled AppConfigurationFeature#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#etag AppConfigurationFeature#etag}
    */
    readonly etag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#id AppConfigurationFeature#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#key AppConfigurationFeature#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#label AppConfigurationFeature#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#locked AppConfigurationFeature#locked}
    */
    readonly locked?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#name AppConfigurationFeature#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#percentage_filter_value AppConfigurationFeature#percentage_filter_value}
    */
    readonly percentageFilterValue?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#tags AppConfigurationFeature#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * targeting_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#targeting_filter AppConfigurationFeature#targeting_filter}
    */
    readonly targetingFilter?: AppConfigurationFeatureTargetingFilter[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#timeouts AppConfigurationFeature#timeouts}
    */
    readonly timeouts?: AppConfigurationFeatureTimeouts;
    /**
    * timewindow_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#timewindow_filter AppConfigurationFeature#timewindow_filter}
    */
    readonly timewindowFilter?: AppConfigurationFeatureTimewindowFilter[] | cdktf.IResolvable;
}
export interface AppConfigurationFeatureTargetingFilterGroups {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#name AppConfigurationFeature#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#rollout_percentage AppConfigurationFeature#rollout_percentage}
    */
    readonly rolloutPercentage: number;
}
export declare function appConfigurationFeatureTargetingFilterGroupsToTerraform(struct?: AppConfigurationFeatureTargetingFilterGroups | cdktf.IResolvable): any;
export declare function appConfigurationFeatureTargetingFilterGroupsToHclTerraform(struct?: AppConfigurationFeatureTargetingFilterGroups | cdktf.IResolvable): any;
export declare class AppConfigurationFeatureTargetingFilterGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppConfigurationFeatureTargetingFilterGroups | cdktf.IResolvable | undefined;
    set internalValue(value: AppConfigurationFeatureTargetingFilterGroups | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rolloutPercentage?;
    get rolloutPercentage(): number;
    set rolloutPercentage(value: number);
    get rolloutPercentageInput(): number | undefined;
}
export declare class AppConfigurationFeatureTargetingFilterGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppConfigurationFeatureTargetingFilterGroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppConfigurationFeatureTargetingFilterGroupsOutputReference;
}
export interface AppConfigurationFeatureTargetingFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#default_rollout_percentage AppConfigurationFeature#default_rollout_percentage}
    */
    readonly defaultRolloutPercentage: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#users AppConfigurationFeature#users}
    */
    readonly users?: string[];
    /**
    * groups block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#groups AppConfigurationFeature#groups}
    */
    readonly groups?: AppConfigurationFeatureTargetingFilterGroups[] | cdktf.IResolvable;
}
export declare function appConfigurationFeatureTargetingFilterToTerraform(struct?: AppConfigurationFeatureTargetingFilter | cdktf.IResolvable): any;
export declare function appConfigurationFeatureTargetingFilterToHclTerraform(struct?: AppConfigurationFeatureTargetingFilter | cdktf.IResolvable): any;
export declare class AppConfigurationFeatureTargetingFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppConfigurationFeatureTargetingFilter | cdktf.IResolvable | undefined;
    set internalValue(value: AppConfigurationFeatureTargetingFilter | cdktf.IResolvable | undefined);
    private _defaultRolloutPercentage?;
    get defaultRolloutPercentage(): number;
    set defaultRolloutPercentage(value: number);
    get defaultRolloutPercentageInput(): number | undefined;
    private _users?;
    get users(): string[];
    set users(value: string[]);
    resetUsers(): void;
    get usersInput(): string[] | undefined;
    private _groups;
    get groups(): AppConfigurationFeatureTargetingFilterGroupsList;
    putGroups(value: AppConfigurationFeatureTargetingFilterGroups[] | cdktf.IResolvable): void;
    resetGroups(): void;
    get groupsInput(): cdktf.IResolvable | AppConfigurationFeatureTargetingFilterGroups[] | undefined;
}
export declare class AppConfigurationFeatureTargetingFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppConfigurationFeatureTargetingFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppConfigurationFeatureTargetingFilterOutputReference;
}
export interface AppConfigurationFeatureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#create AppConfigurationFeature#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#delete AppConfigurationFeature#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#read AppConfigurationFeature#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#update AppConfigurationFeature#update}
    */
    readonly update?: string;
}
export declare function appConfigurationFeatureTimeoutsToTerraform(struct?: AppConfigurationFeatureTimeouts | cdktf.IResolvable): any;
export declare function appConfigurationFeatureTimeoutsToHclTerraform(struct?: AppConfigurationFeatureTimeouts | cdktf.IResolvable): any;
export declare class AppConfigurationFeatureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppConfigurationFeatureTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppConfigurationFeatureTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface AppConfigurationFeatureTimewindowFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#end AppConfigurationFeature#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#start AppConfigurationFeature#start}
    */
    readonly start?: string;
}
export declare function appConfigurationFeatureTimewindowFilterToTerraform(struct?: AppConfigurationFeatureTimewindowFilter | cdktf.IResolvable): any;
export declare function appConfigurationFeatureTimewindowFilterToHclTerraform(struct?: AppConfigurationFeatureTimewindowFilter | cdktf.IResolvable): any;
export declare class AppConfigurationFeatureTimewindowFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppConfigurationFeatureTimewindowFilter | cdktf.IResolvable | undefined;
    set internalValue(value: AppConfigurationFeatureTimewindowFilter | cdktf.IResolvable | undefined);
    private _end?;
    get end(): string;
    set end(value: string);
    resetEnd(): void;
    get endInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    resetStart(): void;
    get startInput(): string | undefined;
}
export declare class AppConfigurationFeatureTimewindowFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppConfigurationFeatureTimewindowFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppConfigurationFeatureTimewindowFilterOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature azurerm_app_configuration_feature}
*/
export declare class AppConfigurationFeature extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_configuration_feature";
    /**
    * Generates CDKTF code for importing a AppConfigurationFeature resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppConfigurationFeature to import
    * @param importFromId The id of the existing AppConfigurationFeature that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppConfigurationFeature to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_configuration_feature azurerm_app_configuration_feature} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppConfigurationFeatureConfig
    */
    constructor(scope: Construct, id: string, config: AppConfigurationFeatureConfig);
    private _configurationStoreId?;
    get configurationStoreId(): string;
    set configurationStoreId(value: string);
    get configurationStoreIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _locked?;
    get locked(): boolean | cdktf.IResolvable;
    set locked(value: boolean | cdktf.IResolvable);
    resetLocked(): void;
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _percentageFilterValue?;
    get percentageFilterValue(): number;
    set percentageFilterValue(value: number);
    resetPercentageFilterValue(): void;
    get percentageFilterValueInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _targetingFilter;
    get targetingFilter(): AppConfigurationFeatureTargetingFilterList;
    putTargetingFilter(value: AppConfigurationFeatureTargetingFilter[] | cdktf.IResolvable): void;
    resetTargetingFilter(): void;
    get targetingFilterInput(): cdktf.IResolvable | AppConfigurationFeatureTargetingFilter[] | undefined;
    private _timeouts;
    get timeouts(): AppConfigurationFeatureTimeoutsOutputReference;
    putTimeouts(value: AppConfigurationFeatureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppConfigurationFeatureTimeouts | undefined;
    private _timewindowFilter;
    get timewindowFilter(): AppConfigurationFeatureTimewindowFilterList;
    putTimewindowFilter(value: AppConfigurationFeatureTimewindowFilter[] | cdktf.IResolvable): void;
    resetTimewindowFilter(): void;
    get timewindowFilterInput(): cdktf.IResolvable | AppConfigurationFeatureTimewindowFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
