/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#app_service_name AppServiceSlot#app_service_name}
    */
    readonly appServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#app_service_plan_id AppServiceSlot#app_service_plan_id}
    */
    readonly appServicePlanId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#app_settings AppServiceSlot#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#client_affinity_enabled AppServiceSlot#client_affinity_enabled}
    */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#enabled AppServiceSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#https_only AppServiceSlot#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#id AppServiceSlot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#key_vault_reference_identity_id AppServiceSlot#key_vault_reference_identity_id}
    */
    readonly keyVaultReferenceIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#location AppServiceSlot#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#name AppServiceSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#resource_group_name AppServiceSlot#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#tags AppServiceSlot#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * auth_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#auth_settings AppServiceSlot#auth_settings}
    */
    readonly authSettings?: AppServiceSlotAuthSettings;
    /**
    * connection_string block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#connection_string AppServiceSlot#connection_string}
    */
    readonly connectionString?: AppServiceSlotConnectionString[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#identity AppServiceSlot#identity}
    */
    readonly identity?: AppServiceSlotIdentity;
    /**
    * logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#logs AppServiceSlot#logs}
    */
    readonly logs?: AppServiceSlotLogs;
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#site_config AppServiceSlot#site_config}
    */
    readonly siteConfig?: AppServiceSlotSiteConfig;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#storage_account AppServiceSlot#storage_account}
    */
    readonly storageAccount?: AppServiceSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#timeouts AppServiceSlot#timeouts}
    */
    readonly timeouts?: AppServiceSlotTimeouts;
}
export interface AppServiceSlotSiteCredential {
}
export declare function appServiceSlotSiteCredentialToTerraform(struct?: AppServiceSlotSiteCredential): any;
export declare function appServiceSlotSiteCredentialToHclTerraform(struct?: AppServiceSlotSiteCredential): any;
export declare class AppServiceSlotSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceSlotSiteCredential | undefined;
    set internalValue(value: AppServiceSlotSiteCredential | undefined);
    get password(): string;
    get username(): string;
}
export declare class AppServiceSlotSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceSlotSiteCredentialOutputReference;
}
export interface AppServiceSlotAuthSettingsActiveDirectory {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#allowed_audiences AppServiceSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#client_id AppServiceSlot#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#client_secret AppServiceSlot#client_secret}
    */
    readonly clientSecret?: string;
}
export declare function appServiceSlotAuthSettingsActiveDirectoryToTerraform(struct?: AppServiceSlotAuthSettingsActiveDirectoryOutputReference | AppServiceSlotAuthSettingsActiveDirectory): any;
export declare function appServiceSlotAuthSettingsActiveDirectoryToHclTerraform(struct?: AppServiceSlotAuthSettingsActiveDirectoryOutputReference | AppServiceSlotAuthSettingsActiveDirectory): any;
export declare class AppServiceSlotAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotAuthSettingsActiveDirectory | undefined;
    set internalValue(value: AppServiceSlotAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
}
export interface AppServiceSlotAuthSettingsFacebook {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#app_id AppServiceSlot#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#app_secret AppServiceSlot#app_secret}
    */
    readonly appSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#oauth_scopes AppServiceSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function appServiceSlotAuthSettingsFacebookToTerraform(struct?: AppServiceSlotAuthSettingsFacebookOutputReference | AppServiceSlotAuthSettingsFacebook): any;
export declare function appServiceSlotAuthSettingsFacebookToHclTerraform(struct?: AppServiceSlotAuthSettingsFacebookOutputReference | AppServiceSlotAuthSettingsFacebook): any;
export declare class AppServiceSlotAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotAuthSettingsFacebook | undefined;
    set internalValue(value: AppServiceSlotAuthSettingsFacebook | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    get appSecretInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface AppServiceSlotAuthSettingsGoogle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#client_id AppServiceSlot#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#client_secret AppServiceSlot#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#oauth_scopes AppServiceSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function appServiceSlotAuthSettingsGoogleToTerraform(struct?: AppServiceSlotAuthSettingsGoogleOutputReference | AppServiceSlotAuthSettingsGoogle): any;
export declare function appServiceSlotAuthSettingsGoogleToHclTerraform(struct?: AppServiceSlotAuthSettingsGoogleOutputReference | AppServiceSlotAuthSettingsGoogle): any;
export declare class AppServiceSlotAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotAuthSettingsGoogle | undefined;
    set internalValue(value: AppServiceSlotAuthSettingsGoogle | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface AppServiceSlotAuthSettingsMicrosoft {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#client_id AppServiceSlot#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#client_secret AppServiceSlot#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#oauth_scopes AppServiceSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function appServiceSlotAuthSettingsMicrosoftToTerraform(struct?: AppServiceSlotAuthSettingsMicrosoftOutputReference | AppServiceSlotAuthSettingsMicrosoft): any;
export declare function appServiceSlotAuthSettingsMicrosoftToHclTerraform(struct?: AppServiceSlotAuthSettingsMicrosoftOutputReference | AppServiceSlotAuthSettingsMicrosoft): any;
export declare class AppServiceSlotAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotAuthSettingsMicrosoft | undefined;
    set internalValue(value: AppServiceSlotAuthSettingsMicrosoft | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface AppServiceSlotAuthSettingsTwitter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#consumer_key AppServiceSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#consumer_secret AppServiceSlot#consumer_secret}
    */
    readonly consumerSecret: string;
}
export declare function appServiceSlotAuthSettingsTwitterToTerraform(struct?: AppServiceSlotAuthSettingsTwitterOutputReference | AppServiceSlotAuthSettingsTwitter): any;
export declare function appServiceSlotAuthSettingsTwitterToHclTerraform(struct?: AppServiceSlotAuthSettingsTwitterOutputReference | AppServiceSlotAuthSettingsTwitter): any;
export declare class AppServiceSlotAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotAuthSettingsTwitter | undefined;
    set internalValue(value: AppServiceSlotAuthSettingsTwitter | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    get consumerSecret(): string;
    set consumerSecret(value: string);
    get consumerSecretInput(): string | undefined;
}
export interface AppServiceSlotAuthSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#additional_login_params AppServiceSlot#additional_login_params}
    */
    readonly additionalLoginParams?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#allowed_external_redirect_urls AppServiceSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#default_provider AppServiceSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#enabled AppServiceSlot#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#issuer AppServiceSlot#issuer}
    */
    readonly issuer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#runtime_version AppServiceSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#token_refresh_extension_hours AppServiceSlot#token_refresh_extension_hours}
    */
    readonly tokenRefreshExtensionHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#token_store_enabled AppServiceSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#unauthenticated_client_action AppServiceSlot#unauthenticated_client_action}
    */
    readonly unauthenticatedClientAction?: string;
    /**
    * active_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#active_directory AppServiceSlot#active_directory}
    */
    readonly activeDirectory?: AppServiceSlotAuthSettingsActiveDirectory;
    /**
    * facebook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#facebook AppServiceSlot#facebook}
    */
    readonly facebook?: AppServiceSlotAuthSettingsFacebook;
    /**
    * google block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#google AppServiceSlot#google}
    */
    readonly google?: AppServiceSlotAuthSettingsGoogle;
    /**
    * microsoft block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#microsoft AppServiceSlot#microsoft}
    */
    readonly microsoft?: AppServiceSlotAuthSettingsMicrosoft;
    /**
    * twitter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#twitter AppServiceSlot#twitter}
    */
    readonly twitter?: AppServiceSlotAuthSettingsTwitter;
}
export declare function appServiceSlotAuthSettingsToTerraform(struct?: AppServiceSlotAuthSettingsOutputReference | AppServiceSlotAuthSettings): any;
export declare function appServiceSlotAuthSettingsToHclTerraform(struct?: AppServiceSlotAuthSettingsOutputReference | AppServiceSlotAuthSettings): any;
export declare class AppServiceSlotAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotAuthSettings | undefined;
    set internalValue(value: AppServiceSlotAuthSettings | undefined);
    private _additionalLoginParams?;
    get additionalLoginParams(): {
        [key: string]: string;
    };
    set additionalLoginParams(value: {
        [key: string]: string;
    });
    resetAdditionalLoginParams(): void;
    get additionalLoginParamsInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    get tokenRefreshExtensionHours(): number;
    set tokenRefreshExtensionHours(value: number);
    resetTokenRefreshExtensionHours(): void;
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    get unauthenticatedClientAction(): string;
    set unauthenticatedClientAction(value: string);
    resetUnauthenticatedClientAction(): void;
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    get activeDirectory(): AppServiceSlotAuthSettingsActiveDirectoryOutputReference;
    putActiveDirectory(value: AppServiceSlotAuthSettingsActiveDirectory): void;
    resetActiveDirectory(): void;
    get activeDirectoryInput(): AppServiceSlotAuthSettingsActiveDirectory | undefined;
    private _facebook;
    get facebook(): AppServiceSlotAuthSettingsFacebookOutputReference;
    putFacebook(value: AppServiceSlotAuthSettingsFacebook): void;
    resetFacebook(): void;
    get facebookInput(): AppServiceSlotAuthSettingsFacebook | undefined;
    private _google;
    get google(): AppServiceSlotAuthSettingsGoogleOutputReference;
    putGoogle(value: AppServiceSlotAuthSettingsGoogle): void;
    resetGoogle(): void;
    get googleInput(): AppServiceSlotAuthSettingsGoogle | undefined;
    private _microsoft;
    get microsoft(): AppServiceSlotAuthSettingsMicrosoftOutputReference;
    putMicrosoft(value: AppServiceSlotAuthSettingsMicrosoft): void;
    resetMicrosoft(): void;
    get microsoftInput(): AppServiceSlotAuthSettingsMicrosoft | undefined;
    private _twitter;
    get twitter(): AppServiceSlotAuthSettingsTwitterOutputReference;
    putTwitter(value: AppServiceSlotAuthSettingsTwitter): void;
    resetTwitter(): void;
    get twitterInput(): AppServiceSlotAuthSettingsTwitter | undefined;
}
export interface AppServiceSlotConnectionString {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#name AppServiceSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#type AppServiceSlot#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#value AppServiceSlot#value}
    */
    readonly value: string;
}
export declare function appServiceSlotConnectionStringToTerraform(struct?: AppServiceSlotConnectionString | cdktf.IResolvable): any;
export declare function appServiceSlotConnectionStringToHclTerraform(struct?: AppServiceSlotConnectionString | cdktf.IResolvable): any;
export declare class AppServiceSlotConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceSlotConnectionString | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceSlotConnectionString | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class AppServiceSlotConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppServiceSlotConnectionString[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceSlotConnectionStringOutputReference;
}
export interface AppServiceSlotIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#identity_ids AppServiceSlot#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#type AppServiceSlot#type}
    */
    readonly type: string;
}
export declare function appServiceSlotIdentityToTerraform(struct?: AppServiceSlotIdentityOutputReference | AppServiceSlotIdentity): any;
export declare function appServiceSlotIdentityToHclTerraform(struct?: AppServiceSlotIdentityOutputReference | AppServiceSlotIdentity): any;
export declare class AppServiceSlotIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotIdentity | undefined;
    set internalValue(value: AppServiceSlotIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface AppServiceSlotLogsApplicationLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#level AppServiceSlot#level}
    */
    readonly level: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#retention_in_days AppServiceSlot#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#sas_url AppServiceSlot#sas_url}
    */
    readonly sasUrl: string;
}
export declare function appServiceSlotLogsApplicationLogsAzureBlobStorageToTerraform(struct?: AppServiceSlotLogsApplicationLogsAzureBlobStorageOutputReference | AppServiceSlotLogsApplicationLogsAzureBlobStorage): any;
export declare function appServiceSlotLogsApplicationLogsAzureBlobStorageToHclTerraform(struct?: AppServiceSlotLogsApplicationLogsAzureBlobStorageOutputReference | AppServiceSlotLogsApplicationLogsAzureBlobStorage): any;
export declare class AppServiceSlotLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotLogsApplicationLogsAzureBlobStorage | undefined;
    set internalValue(value: AppServiceSlotLogsApplicationLogsAzureBlobStorage | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    get levelInput(): string | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface AppServiceSlotLogsApplicationLogs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#file_system_level AppServiceSlot#file_system_level}
    */
    readonly fileSystemLevel?: string;
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#azure_blob_storage AppServiceSlot#azure_blob_storage}
    */
    readonly azureBlobStorage?: AppServiceSlotLogsApplicationLogsAzureBlobStorage;
}
export declare function appServiceSlotLogsApplicationLogsToTerraform(struct?: AppServiceSlotLogsApplicationLogsOutputReference | AppServiceSlotLogsApplicationLogs): any;
export declare function appServiceSlotLogsApplicationLogsToHclTerraform(struct?: AppServiceSlotLogsApplicationLogsOutputReference | AppServiceSlotLogsApplicationLogs): any;
export declare class AppServiceSlotLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotLogsApplicationLogs | undefined;
    set internalValue(value: AppServiceSlotLogsApplicationLogs | undefined);
    private _fileSystemLevel?;
    get fileSystemLevel(): string;
    set fileSystemLevel(value: string);
    resetFileSystemLevel(): void;
    get fileSystemLevelInput(): string | undefined;
    private _azureBlobStorage;
    get azureBlobStorage(): AppServiceSlotLogsApplicationLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: AppServiceSlotLogsApplicationLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): AppServiceSlotLogsApplicationLogsAzureBlobStorage | undefined;
}
export interface AppServiceSlotLogsHttpLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#retention_in_days AppServiceSlot#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#sas_url AppServiceSlot#sas_url}
    */
    readonly sasUrl: string;
}
export declare function appServiceSlotLogsHttpLogsAzureBlobStorageToTerraform(struct?: AppServiceSlotLogsHttpLogsAzureBlobStorageOutputReference | AppServiceSlotLogsHttpLogsAzureBlobStorage): any;
export declare function appServiceSlotLogsHttpLogsAzureBlobStorageToHclTerraform(struct?: AppServiceSlotLogsHttpLogsAzureBlobStorageOutputReference | AppServiceSlotLogsHttpLogsAzureBlobStorage): any;
export declare class AppServiceSlotLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotLogsHttpLogsAzureBlobStorage | undefined;
    set internalValue(value: AppServiceSlotLogsHttpLogsAzureBlobStorage | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface AppServiceSlotLogsHttpLogsFileSystem {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#retention_in_days AppServiceSlot#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#retention_in_mb AppServiceSlot#retention_in_mb}
    */
    readonly retentionInMb: number;
}
export declare function appServiceSlotLogsHttpLogsFileSystemToTerraform(struct?: AppServiceSlotLogsHttpLogsFileSystemOutputReference | AppServiceSlotLogsHttpLogsFileSystem): any;
export declare function appServiceSlotLogsHttpLogsFileSystemToHclTerraform(struct?: AppServiceSlotLogsHttpLogsFileSystemOutputReference | AppServiceSlotLogsHttpLogsFileSystem): any;
export declare class AppServiceSlotLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotLogsHttpLogsFileSystem | undefined;
    set internalValue(value: AppServiceSlotLogsHttpLogsFileSystem | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _retentionInMb?;
    get retentionInMb(): number;
    set retentionInMb(value: number);
    get retentionInMbInput(): number | undefined;
}
export interface AppServiceSlotLogsHttpLogs {
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#azure_blob_storage AppServiceSlot#azure_blob_storage}
    */
    readonly azureBlobStorage?: AppServiceSlotLogsHttpLogsAzureBlobStorage;
    /**
    * file_system block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#file_system AppServiceSlot#file_system}
    */
    readonly fileSystem?: AppServiceSlotLogsHttpLogsFileSystem;
}
export declare function appServiceSlotLogsHttpLogsToTerraform(struct?: AppServiceSlotLogsHttpLogsOutputReference | AppServiceSlotLogsHttpLogs): any;
export declare function appServiceSlotLogsHttpLogsToHclTerraform(struct?: AppServiceSlotLogsHttpLogsOutputReference | AppServiceSlotLogsHttpLogs): any;
export declare class AppServiceSlotLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotLogsHttpLogs | undefined;
    set internalValue(value: AppServiceSlotLogsHttpLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): AppServiceSlotLogsHttpLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: AppServiceSlotLogsHttpLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): AppServiceSlotLogsHttpLogsAzureBlobStorage | undefined;
    private _fileSystem;
    get fileSystem(): AppServiceSlotLogsHttpLogsFileSystemOutputReference;
    putFileSystem(value: AppServiceSlotLogsHttpLogsFileSystem): void;
    resetFileSystem(): void;
    get fileSystemInput(): AppServiceSlotLogsHttpLogsFileSystem | undefined;
}
export interface AppServiceSlotLogs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#detailed_error_messages_enabled AppServiceSlot#detailed_error_messages_enabled}
    */
    readonly detailedErrorMessagesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#failed_request_tracing_enabled AppServiceSlot#failed_request_tracing_enabled}
    */
    readonly failedRequestTracingEnabled?: boolean | cdktf.IResolvable;
    /**
    * application_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#application_logs AppServiceSlot#application_logs}
    */
    readonly applicationLogs?: AppServiceSlotLogsApplicationLogs;
    /**
    * http_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#http_logs AppServiceSlot#http_logs}
    */
    readonly httpLogs?: AppServiceSlotLogsHttpLogs;
}
export declare function appServiceSlotLogsToTerraform(struct?: AppServiceSlotLogsOutputReference | AppServiceSlotLogs): any;
export declare function appServiceSlotLogsToHclTerraform(struct?: AppServiceSlotLogsOutputReference | AppServiceSlotLogs): any;
export declare class AppServiceSlotLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotLogs | undefined;
    set internalValue(value: AppServiceSlotLogs | undefined);
    private _detailedErrorMessagesEnabled?;
    get detailedErrorMessagesEnabled(): boolean | cdktf.IResolvable;
    set detailedErrorMessagesEnabled(value: boolean | cdktf.IResolvable);
    resetDetailedErrorMessagesEnabled(): void;
    get detailedErrorMessagesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _failedRequestTracingEnabled?;
    get failedRequestTracingEnabled(): boolean | cdktf.IResolvable;
    set failedRequestTracingEnabled(value: boolean | cdktf.IResolvable);
    resetFailedRequestTracingEnabled(): void;
    get failedRequestTracingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _applicationLogs;
    get applicationLogs(): AppServiceSlotLogsApplicationLogsOutputReference;
    putApplicationLogs(value: AppServiceSlotLogsApplicationLogs): void;
    resetApplicationLogs(): void;
    get applicationLogsInput(): AppServiceSlotLogsApplicationLogs | undefined;
    private _httpLogs;
    get httpLogs(): AppServiceSlotLogsHttpLogsOutputReference;
    putHttpLogs(value: AppServiceSlotLogsHttpLogs): void;
    resetHttpLogs(): void;
    get httpLogsInput(): AppServiceSlotLogsHttpLogs | undefined;
}
export interface AppServiceSlotSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#x_azure_fdid AppServiceSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#x_fd_health_probe AppServiceSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#x_forwarded_for AppServiceSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#x_forwarded_host AppServiceSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function appServiceSlotSiteConfigIpRestrictionHeadersToTerraform(struct?: AppServiceSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare function appServiceSlotSiteConfigIpRestrictionHeadersToHclTerraform(struct?: AppServiceSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class AppServiceSlotSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class AppServiceSlotSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppServiceSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceSlotSiteConfigIpRestrictionHeadersOutputReference;
}
export interface AppServiceSlotSiteConfigIpRestriction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#action AppServiceSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#headers AppServiceSlot#headers}
    */
    readonly headers?: AppServiceSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#ip_address AppServiceSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#name AppServiceSlot#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#priority AppServiceSlot#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#service_tag AppServiceSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#virtual_network_subnet_id AppServiceSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function appServiceSlotSiteConfigIpRestrictionToTerraform(struct?: AppServiceSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare function appServiceSlotSiteConfigIpRestrictionToHclTerraform(struct?: AppServiceSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare class AppServiceSlotSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): AppServiceSlotSiteConfigIpRestrictionHeadersList;
    putHeaders(value: AppServiceSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | AppServiceSlotSiteConfigIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class AppServiceSlotSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppServiceSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceSlotSiteConfigIpRestrictionOutputReference;
}
export interface AppServiceSlotSiteConfigScmIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#x_azure_fdid AppServiceSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#x_fd_health_probe AppServiceSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#x_forwarded_for AppServiceSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#x_forwarded_host AppServiceSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function appServiceSlotSiteConfigScmIpRestrictionHeadersToTerraform(struct?: AppServiceSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare function appServiceSlotSiteConfigScmIpRestrictionHeadersToHclTerraform(struct?: AppServiceSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class AppServiceSlotSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class AppServiceSlotSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppServiceSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceSlotSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface AppServiceSlotSiteConfigScmIpRestriction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#action AppServiceSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#headers AppServiceSlot#headers}
    */
    readonly headers?: AppServiceSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#ip_address AppServiceSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#name AppServiceSlot#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#priority AppServiceSlot#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#service_tag AppServiceSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#virtual_network_subnet_id AppServiceSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function appServiceSlotSiteConfigScmIpRestrictionToTerraform(struct?: AppServiceSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare function appServiceSlotSiteConfigScmIpRestrictionToHclTerraform(struct?: AppServiceSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare class AppServiceSlotSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): AppServiceSlotSiteConfigScmIpRestrictionHeadersList;
    putHeaders(value: AppServiceSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | AppServiceSlotSiteConfigScmIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class AppServiceSlotSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppServiceSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceSlotSiteConfigScmIpRestrictionOutputReference;
}
export interface AppServiceSlotSiteConfigCors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#allowed_origins AppServiceSlot#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#support_credentials AppServiceSlot#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function appServiceSlotSiteConfigCorsToTerraform(struct?: AppServiceSlotSiteConfigCorsOutputReference | AppServiceSlotSiteConfigCors): any;
export declare function appServiceSlotSiteConfigCorsToHclTerraform(struct?: AppServiceSlotSiteConfigCorsOutputReference | AppServiceSlotSiteConfigCors): any;
export declare class AppServiceSlotSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotSiteConfigCors | undefined;
    set internalValue(value: AppServiceSlotSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AppServiceSlotSiteConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#acr_use_managed_identity_credentials AppServiceSlot#acr_use_managed_identity_credentials}
    */
    readonly acrUseManagedIdentityCredentials?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#acr_user_managed_identity_client_id AppServiceSlot#acr_user_managed_identity_client_id}
    */
    readonly acrUserManagedIdentityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#always_on AppServiceSlot#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#app_command_line AppServiceSlot#app_command_line}
    */
    readonly appCommandLine?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#auto_swap_slot_name AppServiceSlot#auto_swap_slot_name}
    */
    readonly autoSwapSlotName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#default_documents AppServiceSlot#default_documents}
    */
    readonly defaultDocuments?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#dotnet_framework_version AppServiceSlot#dotnet_framework_version}
    */
    readonly dotnetFrameworkVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#ftps_state AppServiceSlot#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#health_check_path AppServiceSlot#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#http2_enabled AppServiceSlot#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#ip_restriction AppServiceSlot#ip_restriction}
    */
    readonly ipRestriction?: AppServiceSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#java_container AppServiceSlot#java_container}
    */
    readonly javaContainer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#java_container_version AppServiceSlot#java_container_version}
    */
    readonly javaContainerVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#java_version AppServiceSlot#java_version}
    */
    readonly javaVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#linux_fx_version AppServiceSlot#linux_fx_version}
    */
    readonly linuxFxVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#local_mysql_enabled AppServiceSlot#local_mysql_enabled}
    */
    readonly localMysqlEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#managed_pipeline_mode AppServiceSlot#managed_pipeline_mode}
    */
    readonly managedPipelineMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#min_tls_version AppServiceSlot#min_tls_version}
    */
    readonly minTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#number_of_workers AppServiceSlot#number_of_workers}
    */
    readonly numberOfWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#php_version AppServiceSlot#php_version}
    */
    readonly phpVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#python_version AppServiceSlot#python_version}
    */
    readonly pythonVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#remote_debugging_enabled AppServiceSlot#remote_debugging_enabled}
    */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#remote_debugging_version AppServiceSlot#remote_debugging_version}
    */
    readonly remoteDebuggingVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#scm_ip_restriction AppServiceSlot#scm_ip_restriction}
    */
    readonly scmIpRestriction?: AppServiceSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#scm_type AppServiceSlot#scm_type}
    */
    readonly scmType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#scm_use_main_ip_restriction AppServiceSlot#scm_use_main_ip_restriction}
    */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#use_32_bit_worker_process AppServiceSlot#use_32_bit_worker_process}
    */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#vnet_route_all_enabled AppServiceSlot#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#websockets_enabled AppServiceSlot#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#windows_fx_version AppServiceSlot#windows_fx_version}
    */
    readonly windowsFxVersion?: string;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#cors AppServiceSlot#cors}
    */
    readonly cors?: AppServiceSlotSiteConfigCors;
}
export declare function appServiceSlotSiteConfigToTerraform(struct?: AppServiceSlotSiteConfigOutputReference | AppServiceSlotSiteConfig): any;
export declare function appServiceSlotSiteConfigToHclTerraform(struct?: AppServiceSlotSiteConfigOutputReference | AppServiceSlotSiteConfig): any;
export declare class AppServiceSlotSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotSiteConfig | undefined;
    set internalValue(value: AppServiceSlotSiteConfig | undefined);
    private _acrUseManagedIdentityCredentials?;
    get acrUseManagedIdentityCredentials(): boolean | cdktf.IResolvable;
    set acrUseManagedIdentityCredentials(value: boolean | cdktf.IResolvable);
    resetAcrUseManagedIdentityCredentials(): void;
    get acrUseManagedIdentityCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _acrUserManagedIdentityClientId?;
    get acrUserManagedIdentityClientId(): string;
    set acrUserManagedIdentityClientId(value: string);
    resetAcrUserManagedIdentityClientId(): void;
    get acrUserManagedIdentityClientIdInput(): string | undefined;
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appCommandLine?;
    get appCommandLine(): string;
    set appCommandLine(value: string);
    resetAppCommandLine(): void;
    get appCommandLineInput(): string | undefined;
    private _autoSwapSlotName?;
    get autoSwapSlotName(): string;
    set autoSwapSlotName(value: string);
    resetAutoSwapSlotName(): void;
    get autoSwapSlotNameInput(): string | undefined;
    private _defaultDocuments?;
    get defaultDocuments(): string[];
    set defaultDocuments(value: string[]);
    resetDefaultDocuments(): void;
    get defaultDocumentsInput(): string[] | undefined;
    private _dotnetFrameworkVersion?;
    get dotnetFrameworkVersion(): string;
    set dotnetFrameworkVersion(value: string);
    resetDotnetFrameworkVersion(): void;
    get dotnetFrameworkVersionInput(): string | undefined;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction;
    get ipRestriction(): AppServiceSlotSiteConfigIpRestrictionList;
    putIpRestriction(value: AppServiceSlotSiteConfigIpRestriction[] | cdktf.IResolvable): void;
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | AppServiceSlotSiteConfigIpRestriction[] | undefined;
    private _javaContainer?;
    get javaContainer(): string;
    set javaContainer(value: string);
    resetJavaContainer(): void;
    get javaContainerInput(): string | undefined;
    private _javaContainerVersion?;
    get javaContainerVersion(): string;
    set javaContainerVersion(value: string);
    resetJavaContainerVersion(): void;
    get javaContainerVersionInput(): string | undefined;
    private _javaVersion?;
    get javaVersion(): string;
    set javaVersion(value: string);
    resetJavaVersion(): void;
    get javaVersionInput(): string | undefined;
    private _linuxFxVersion?;
    get linuxFxVersion(): string;
    set linuxFxVersion(value: string);
    resetLinuxFxVersion(): void;
    get linuxFxVersionInput(): string | undefined;
    private _localMysqlEnabled?;
    get localMysqlEnabled(): boolean | cdktf.IResolvable;
    set localMysqlEnabled(value: boolean | cdktf.IResolvable);
    resetLocalMysqlEnabled(): void;
    get localMysqlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedPipelineMode?;
    get managedPipelineMode(): string;
    set managedPipelineMode(value: string);
    resetManagedPipelineMode(): void;
    get managedPipelineModeInput(): string | undefined;
    private _minTlsVersion?;
    get minTlsVersion(): string;
    set minTlsVersion(value: string);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _numberOfWorkers?;
    get numberOfWorkers(): number;
    set numberOfWorkers(value: number);
    resetNumberOfWorkers(): void;
    get numberOfWorkersInput(): number | undefined;
    private _phpVersion?;
    get phpVersion(): string;
    set phpVersion(value: string);
    resetPhpVersion(): void;
    get phpVersionInput(): string | undefined;
    private _pythonVersion?;
    get pythonVersion(): string;
    set pythonVersion(value: string);
    resetPythonVersion(): void;
    get pythonVersionInput(): string | undefined;
    private _remoteDebuggingEnabled?;
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    resetRemoteDebuggingEnabled(): void;
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteDebuggingVersion?;
    get remoteDebuggingVersion(): string;
    set remoteDebuggingVersion(value: string);
    resetRemoteDebuggingVersion(): void;
    get remoteDebuggingVersionInput(): string | undefined;
    private _scmIpRestriction;
    get scmIpRestriction(): AppServiceSlotSiteConfigScmIpRestrictionList;
    putScmIpRestriction(value: AppServiceSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable): void;
    resetScmIpRestriction(): void;
    get scmIpRestrictionInput(): cdktf.IResolvable | AppServiceSlotSiteConfigScmIpRestriction[] | undefined;
    private _scmType?;
    get scmType(): string;
    set scmType(value: string);
    resetScmType(): void;
    get scmTypeInput(): string | undefined;
    private _scmUseMainIpRestriction?;
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    resetScmUseMainIpRestriction(): void;
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    resetUse32BitWorkerProcess(): void;
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _windowsFxVersion?;
    get windowsFxVersion(): string;
    set windowsFxVersion(value: string);
    resetWindowsFxVersion(): void;
    get windowsFxVersionInput(): string | undefined;
    private _cors;
    get cors(): AppServiceSlotSiteConfigCorsOutputReference;
    putCors(value: AppServiceSlotSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): AppServiceSlotSiteConfigCors | undefined;
}
export interface AppServiceSlotStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#access_key AppServiceSlot#access_key}
    */
    readonly accessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#account_name AppServiceSlot#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#mount_path AppServiceSlot#mount_path}
    */
    readonly mountPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#name AppServiceSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#share_name AppServiceSlot#share_name}
    */
    readonly shareName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#type AppServiceSlot#type}
    */
    readonly type: string;
}
export declare function appServiceSlotStorageAccountToTerraform(struct?: AppServiceSlotStorageAccount | cdktf.IResolvable): any;
export declare function appServiceSlotStorageAccountToHclTerraform(struct?: AppServiceSlotStorageAccount | cdktf.IResolvable): any;
export declare class AppServiceSlotStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceSlotStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceSlotStorageAccount | cdktf.IResolvable | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class AppServiceSlotStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppServiceSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceSlotStorageAccountOutputReference;
}
export interface AppServiceSlotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#create AppServiceSlot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#delete AppServiceSlot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#read AppServiceSlot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#update AppServiceSlot#update}
    */
    readonly update?: string;
}
export declare function appServiceSlotTimeoutsToTerraform(struct?: AppServiceSlotTimeouts | cdktf.IResolvable): any;
export declare function appServiceSlotTimeoutsToHclTerraform(struct?: AppServiceSlotTimeouts | cdktf.IResolvable): any;
export declare class AppServiceSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceSlotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot azurerm_app_service_slot}
*/
export declare class AppServiceSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_slot";
    /**
    * Generates CDKTF code for importing a AppServiceSlot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceSlot to import
    * @param importFromId The id of the existing AppServiceSlot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceSlot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/app_service_slot azurerm_app_service_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceSlotConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceSlotConfig);
    private _appServiceName?;
    get appServiceName(): string;
    set appServiceName(value: string);
    get appServiceNameInput(): string | undefined;
    private _appServicePlanId?;
    get appServicePlanId(): string;
    set appServicePlanId(value: string);
    get appServicePlanIdInput(): string | undefined;
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _clientAffinityEnabled?;
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    resetClientAffinityEnabled(): void;
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get defaultSiteHostname(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultReferenceIdentityId?;
    get keyVaultReferenceIdentityId(): string;
    set keyVaultReferenceIdentityId(value: string);
    resetKeyVaultReferenceIdentityId(): void;
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _siteCredential;
    get siteCredential(): AppServiceSlotSiteCredentialList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _authSettings;
    get authSettings(): AppServiceSlotAuthSettingsOutputReference;
    putAuthSettings(value: AppServiceSlotAuthSettings): void;
    resetAuthSettings(): void;
    get authSettingsInput(): AppServiceSlotAuthSettings | undefined;
    private _connectionString;
    get connectionString(): AppServiceSlotConnectionStringList;
    putConnectionString(value: AppServiceSlotConnectionString[] | cdktf.IResolvable): void;
    resetConnectionString(): void;
    get connectionStringInput(): cdktf.IResolvable | AppServiceSlotConnectionString[] | undefined;
    private _identity;
    get identity(): AppServiceSlotIdentityOutputReference;
    putIdentity(value: AppServiceSlotIdentity): void;
    resetIdentity(): void;
    get identityInput(): AppServiceSlotIdentity | undefined;
    private _logs;
    get logs(): AppServiceSlotLogsOutputReference;
    putLogs(value: AppServiceSlotLogs): void;
    resetLogs(): void;
    get logsInput(): AppServiceSlotLogs | undefined;
    private _siteConfig;
    get siteConfig(): AppServiceSlotSiteConfigOutputReference;
    putSiteConfig(value: AppServiceSlotSiteConfig): void;
    resetSiteConfig(): void;
    get siteConfigInput(): AppServiceSlotSiteConfig | undefined;
    private _storageAccount;
    get storageAccount(): AppServiceSlotStorageAccountList;
    putStorageAccount(value: AppServiceSlotStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | AppServiceSlotStorageAccount[] | undefined;
    private _timeouts;
    get timeouts(): AppServiceSlotTimeoutsOutputReference;
    putTimeouts(value: AppServiceSlotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceSlotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
