/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationPython3PackageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#automation_account_name AutomationPython3Package#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#content_uri AutomationPython3Package#content_uri}
    */
    readonly contentUri: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#content_version AutomationPython3Package#content_version}
    */
    readonly contentVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#hash_algorithm AutomationPython3Package#hash_algorithm}
    */
    readonly hashAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#hash_value AutomationPython3Package#hash_value}
    */
    readonly hashValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#id AutomationPython3Package#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#name AutomationPython3Package#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#resource_group_name AutomationPython3Package#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#tags AutomationPython3Package#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#timeouts AutomationPython3Package#timeouts}
    */
    readonly timeouts?: AutomationPython3PackageTimeouts;
}
export interface AutomationPython3PackageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#create AutomationPython3Package#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#delete AutomationPython3Package#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#read AutomationPython3Package#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#update AutomationPython3Package#update}
    */
    readonly update?: string;
}
export declare function automationPython3PackageTimeoutsToTerraform(struct?: AutomationPython3PackageTimeouts | cdktf.IResolvable): any;
export declare function automationPython3PackageTimeoutsToHclTerraform(struct?: AutomationPython3PackageTimeouts | cdktf.IResolvable): any;
export declare class AutomationPython3PackageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationPython3PackageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationPython3PackageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package azurerm_automation_python3_package}
*/
export declare class AutomationPython3Package extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_python3_package";
    /**
    * Generates CDKTF code for importing a AutomationPython3Package resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationPython3Package to import
    * @param importFromId The id of the existing AutomationPython3Package that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationPython3Package to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/automation_python3_package azurerm_automation_python3_package} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationPython3PackageConfig
    */
    constructor(scope: Construct, id: string, config: AutomationPython3PackageConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    private _contentUri?;
    get contentUri(): string;
    set contentUri(value: string);
    get contentUriInput(): string | undefined;
    private _contentVersion?;
    get contentVersion(): string;
    set contentVersion(value: string);
    resetContentVersion(): void;
    get contentVersionInput(): string | undefined;
    private _hashAlgorithm?;
    get hashAlgorithm(): string;
    set hashAlgorithm(value: string);
    resetHashAlgorithm(): void;
    get hashAlgorithmInput(): string | undefined;
    private _hashValue?;
    get hashValue(): string;
    set hashValue(value: string);
    resetHashValue(): void;
    get hashValueInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): AutomationPython3PackageTimeoutsOutputReference;
    putTimeouts(value: AutomationPython3PackageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationPython3PackageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
