/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BackupPolicyFileShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#id BackupPolicyFileShare#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#name BackupPolicyFileShare#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#recovery_vault_name BackupPolicyFileShare#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#resource_group_name BackupPolicyFileShare#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#timezone BackupPolicyFileShare#timezone}
    */
    readonly timezone?: string;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#backup BackupPolicyFileShare#backup}
    */
    readonly backup: BackupPolicyFileShareBackup;
    /**
    * retention_daily block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#retention_daily BackupPolicyFileShare#retention_daily}
    */
    readonly retentionDaily: BackupPolicyFileShareRetentionDaily;
    /**
    * retention_monthly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#retention_monthly BackupPolicyFileShare#retention_monthly}
    */
    readonly retentionMonthly?: BackupPolicyFileShareRetentionMonthly;
    /**
    * retention_weekly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#retention_weekly BackupPolicyFileShare#retention_weekly}
    */
    readonly retentionWeekly?: BackupPolicyFileShareRetentionWeekly;
    /**
    * retention_yearly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#retention_yearly BackupPolicyFileShare#retention_yearly}
    */
    readonly retentionYearly?: BackupPolicyFileShareRetentionYearly;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#timeouts BackupPolicyFileShare#timeouts}
    */
    readonly timeouts?: BackupPolicyFileShareTimeouts;
}
export interface BackupPolicyFileShareBackupHourly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#interval BackupPolicyFileShare#interval}
    */
    readonly interval: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#start_time BackupPolicyFileShare#start_time}
    */
    readonly startTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#window_duration BackupPolicyFileShare#window_duration}
    */
    readonly windowDuration: number;
}
export declare function backupPolicyFileShareBackupHourlyToTerraform(struct?: BackupPolicyFileShareBackupHourlyOutputReference | BackupPolicyFileShareBackupHourly): any;
export declare function backupPolicyFileShareBackupHourlyToHclTerraform(struct?: BackupPolicyFileShareBackupHourlyOutputReference | BackupPolicyFileShareBackupHourly): any;
export declare class BackupPolicyFileShareBackupHourlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyFileShareBackupHourly | undefined;
    set internalValue(value: BackupPolicyFileShareBackupHourly | undefined);
    private _interval?;
    get interval(): number;
    set interval(value: number);
    get intervalInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
    private _windowDuration?;
    get windowDuration(): number;
    set windowDuration(value: number);
    get windowDurationInput(): number | undefined;
}
export interface BackupPolicyFileShareBackup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#frequency BackupPolicyFileShare#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#time BackupPolicyFileShare#time}
    */
    readonly time?: string;
    /**
    * hourly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#hourly BackupPolicyFileShare#hourly}
    */
    readonly hourly?: BackupPolicyFileShareBackupHourly;
}
export declare function backupPolicyFileShareBackupToTerraform(struct?: BackupPolicyFileShareBackupOutputReference | BackupPolicyFileShareBackup): any;
export declare function backupPolicyFileShareBackupToHclTerraform(struct?: BackupPolicyFileShareBackupOutputReference | BackupPolicyFileShareBackup): any;
export declare class BackupPolicyFileShareBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyFileShareBackup | undefined;
    set internalValue(value: BackupPolicyFileShareBackup | undefined);
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    resetTime(): void;
    get timeInput(): string | undefined;
    private _hourly;
    get hourly(): BackupPolicyFileShareBackupHourlyOutputReference;
    putHourly(value: BackupPolicyFileShareBackupHourly): void;
    resetHourly(): void;
    get hourlyInput(): BackupPolicyFileShareBackupHourly | undefined;
}
export interface BackupPolicyFileShareRetentionDaily {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#count BackupPolicyFileShare#count}
    */
    readonly count: number;
}
export declare function backupPolicyFileShareRetentionDailyToTerraform(struct?: BackupPolicyFileShareRetentionDailyOutputReference | BackupPolicyFileShareRetentionDaily): any;
export declare function backupPolicyFileShareRetentionDailyToHclTerraform(struct?: BackupPolicyFileShareRetentionDailyOutputReference | BackupPolicyFileShareRetentionDaily): any;
export declare class BackupPolicyFileShareRetentionDailyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyFileShareRetentionDaily | undefined;
    set internalValue(value: BackupPolicyFileShareRetentionDaily | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
}
export interface BackupPolicyFileShareRetentionMonthly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#count BackupPolicyFileShare#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#days BackupPolicyFileShare#days}
    */
    readonly days?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#include_last_days BackupPolicyFileShare#include_last_days}
    */
    readonly includeLastDays?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#weekdays BackupPolicyFileShare#weekdays}
    */
    readonly weekdays?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#weeks BackupPolicyFileShare#weeks}
    */
    readonly weeks?: string[];
}
export declare function backupPolicyFileShareRetentionMonthlyToTerraform(struct?: BackupPolicyFileShareRetentionMonthlyOutputReference | BackupPolicyFileShareRetentionMonthly): any;
export declare function backupPolicyFileShareRetentionMonthlyToHclTerraform(struct?: BackupPolicyFileShareRetentionMonthlyOutputReference | BackupPolicyFileShareRetentionMonthly): any;
export declare class BackupPolicyFileShareRetentionMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyFileShareRetentionMonthly | undefined;
    set internalValue(value: BackupPolicyFileShareRetentionMonthly | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _days?;
    get days(): number[];
    set days(value: number[]);
    resetDays(): void;
    get daysInput(): number[] | undefined;
    private _includeLastDays?;
    get includeLastDays(): boolean | cdktf.IResolvable;
    set includeLastDays(value: boolean | cdktf.IResolvable);
    resetIncludeLastDays(): void;
    get includeLastDaysInput(): boolean | cdktf.IResolvable | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    resetWeekdays(): void;
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    get weeks(): string[];
    set weeks(value: string[]);
    resetWeeks(): void;
    get weeksInput(): string[] | undefined;
}
export interface BackupPolicyFileShareRetentionWeekly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#count BackupPolicyFileShare#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#weekdays BackupPolicyFileShare#weekdays}
    */
    readonly weekdays: string[];
}
export declare function backupPolicyFileShareRetentionWeeklyToTerraform(struct?: BackupPolicyFileShareRetentionWeeklyOutputReference | BackupPolicyFileShareRetentionWeekly): any;
export declare function backupPolicyFileShareRetentionWeeklyToHclTerraform(struct?: BackupPolicyFileShareRetentionWeeklyOutputReference | BackupPolicyFileShareRetentionWeekly): any;
export declare class BackupPolicyFileShareRetentionWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyFileShareRetentionWeekly | undefined;
    set internalValue(value: BackupPolicyFileShareRetentionWeekly | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    get weekdaysInput(): string[] | undefined;
}
export interface BackupPolicyFileShareRetentionYearly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#count BackupPolicyFileShare#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#days BackupPolicyFileShare#days}
    */
    readonly days?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#include_last_days BackupPolicyFileShare#include_last_days}
    */
    readonly includeLastDays?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#months BackupPolicyFileShare#months}
    */
    readonly months: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#weekdays BackupPolicyFileShare#weekdays}
    */
    readonly weekdays?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#weeks BackupPolicyFileShare#weeks}
    */
    readonly weeks?: string[];
}
export declare function backupPolicyFileShareRetentionYearlyToTerraform(struct?: BackupPolicyFileShareRetentionYearlyOutputReference | BackupPolicyFileShareRetentionYearly): any;
export declare function backupPolicyFileShareRetentionYearlyToHclTerraform(struct?: BackupPolicyFileShareRetentionYearlyOutputReference | BackupPolicyFileShareRetentionYearly): any;
export declare class BackupPolicyFileShareRetentionYearlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyFileShareRetentionYearly | undefined;
    set internalValue(value: BackupPolicyFileShareRetentionYearly | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _days?;
    get days(): number[];
    set days(value: number[]);
    resetDays(): void;
    get daysInput(): number[] | undefined;
    private _includeLastDays?;
    get includeLastDays(): boolean | cdktf.IResolvable;
    set includeLastDays(value: boolean | cdktf.IResolvable);
    resetIncludeLastDays(): void;
    get includeLastDaysInput(): boolean | cdktf.IResolvable | undefined;
    private _months?;
    get months(): string[];
    set months(value: string[]);
    get monthsInput(): string[] | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    resetWeekdays(): void;
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    get weeks(): string[];
    set weeks(value: string[]);
    resetWeeks(): void;
    get weeksInput(): string[] | undefined;
}
export interface BackupPolicyFileShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#create BackupPolicyFileShare#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#delete BackupPolicyFileShare#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#read BackupPolicyFileShare#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#update BackupPolicyFileShare#update}
    */
    readonly update?: string;
}
export declare function backupPolicyFileShareTimeoutsToTerraform(struct?: BackupPolicyFileShareTimeouts | cdktf.IResolvable): any;
export declare function backupPolicyFileShareTimeoutsToHclTerraform(struct?: BackupPolicyFileShareTimeouts | cdktf.IResolvable): any;
export declare class BackupPolicyFileShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyFileShareTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BackupPolicyFileShareTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share azurerm_backup_policy_file_share}
*/
export declare class BackupPolicyFileShare extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_backup_policy_file_share";
    /**
    * Generates CDKTF code for importing a BackupPolicyFileShare resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BackupPolicyFileShare to import
    * @param importFromId The id of the existing BackupPolicyFileShare that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BackupPolicyFileShare to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_file_share azurerm_backup_policy_file_share} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupPolicyFileShareConfig
    */
    constructor(scope: Construct, id: string, config: BackupPolicyFileShareConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _backup;
    get backup(): BackupPolicyFileShareBackupOutputReference;
    putBackup(value: BackupPolicyFileShareBackup): void;
    get backupInput(): BackupPolicyFileShareBackup | undefined;
    private _retentionDaily;
    get retentionDaily(): BackupPolicyFileShareRetentionDailyOutputReference;
    putRetentionDaily(value: BackupPolicyFileShareRetentionDaily): void;
    get retentionDailyInput(): BackupPolicyFileShareRetentionDaily | undefined;
    private _retentionMonthly;
    get retentionMonthly(): BackupPolicyFileShareRetentionMonthlyOutputReference;
    putRetentionMonthly(value: BackupPolicyFileShareRetentionMonthly): void;
    resetRetentionMonthly(): void;
    get retentionMonthlyInput(): BackupPolicyFileShareRetentionMonthly | undefined;
    private _retentionWeekly;
    get retentionWeekly(): BackupPolicyFileShareRetentionWeeklyOutputReference;
    putRetentionWeekly(value: BackupPolicyFileShareRetentionWeekly): void;
    resetRetentionWeekly(): void;
    get retentionWeeklyInput(): BackupPolicyFileShareRetentionWeekly | undefined;
    private _retentionYearly;
    get retentionYearly(): BackupPolicyFileShareRetentionYearlyOutputReference;
    putRetentionYearly(value: BackupPolicyFileShareRetentionYearly): void;
    resetRetentionYearly(): void;
    get retentionYearlyInput(): BackupPolicyFileShareRetentionYearly | undefined;
    private _timeouts;
    get timeouts(): BackupPolicyFileShareTimeoutsOutputReference;
    putTimeouts(value: BackupPolicyFileShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BackupPolicyFileShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
