/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BackupPolicyVmWorkloadConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#id BackupPolicyVmWorkload#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#name BackupPolicyVmWorkload#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#recovery_vault_name BackupPolicyVmWorkload#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#resource_group_name BackupPolicyVmWorkload#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#workload_type BackupPolicyVmWorkload#workload_type}
    */
    readonly workloadType: string;
    /**
    * protection_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#protection_policy BackupPolicyVmWorkload#protection_policy}
    */
    readonly protectionPolicy: BackupPolicyVmWorkloadProtectionPolicy[] | cdktf.IResolvable;
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#settings BackupPolicyVmWorkload#settings}
    */
    readonly settings: BackupPolicyVmWorkloadSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#timeouts BackupPolicyVmWorkload#timeouts}
    */
    readonly timeouts?: BackupPolicyVmWorkloadTimeouts;
}
export interface BackupPolicyVmWorkloadProtectionPolicyBackup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#frequency BackupPolicyVmWorkload#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#frequency_in_minutes BackupPolicyVmWorkload#frequency_in_minutes}
    */
    readonly frequencyInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#time BackupPolicyVmWorkload#time}
    */
    readonly time?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#weekdays BackupPolicyVmWorkload#weekdays}
    */
    readonly weekdays?: string[];
}
export declare function backupPolicyVmWorkloadProtectionPolicyBackupToTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyBackupOutputReference | BackupPolicyVmWorkloadProtectionPolicyBackup): any;
export declare function backupPolicyVmWorkloadProtectionPolicyBackupToHclTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyBackupOutputReference | BackupPolicyVmWorkloadProtectionPolicyBackup): any;
export declare class BackupPolicyVmWorkloadProtectionPolicyBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmWorkloadProtectionPolicyBackup | undefined;
    set internalValue(value: BackupPolicyVmWorkloadProtectionPolicyBackup | undefined);
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    resetFrequency(): void;
    get frequencyInput(): string | undefined;
    private _frequencyInMinutes?;
    get frequencyInMinutes(): number;
    set frequencyInMinutes(value: number);
    resetFrequencyInMinutes(): void;
    get frequencyInMinutesInput(): number | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    resetTime(): void;
    get timeInput(): string | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    resetWeekdays(): void;
    get weekdaysInput(): string[] | undefined;
}
export interface BackupPolicyVmWorkloadProtectionPolicyRetentionDaily {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#count BackupPolicyVmWorkload#count}
    */
    readonly count: number;
}
export declare function backupPolicyVmWorkloadProtectionPolicyRetentionDailyToTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyRetentionDailyOutputReference | BackupPolicyVmWorkloadProtectionPolicyRetentionDaily): any;
export declare function backupPolicyVmWorkloadProtectionPolicyRetentionDailyToHclTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyRetentionDailyOutputReference | BackupPolicyVmWorkloadProtectionPolicyRetentionDaily): any;
export declare class BackupPolicyVmWorkloadProtectionPolicyRetentionDailyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmWorkloadProtectionPolicyRetentionDaily | undefined;
    set internalValue(value: BackupPolicyVmWorkloadProtectionPolicyRetentionDaily | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
}
export interface BackupPolicyVmWorkloadProtectionPolicyRetentionMonthly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#count BackupPolicyVmWorkload#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#format_type BackupPolicyVmWorkload#format_type}
    */
    readonly formatType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#monthdays BackupPolicyVmWorkload#monthdays}
    */
    readonly monthdays?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#weekdays BackupPolicyVmWorkload#weekdays}
    */
    readonly weekdays?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#weeks BackupPolicyVmWorkload#weeks}
    */
    readonly weeks?: string[];
}
export declare function backupPolicyVmWorkloadProtectionPolicyRetentionMonthlyToTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyRetentionMonthlyOutputReference | BackupPolicyVmWorkloadProtectionPolicyRetentionMonthly): any;
export declare function backupPolicyVmWorkloadProtectionPolicyRetentionMonthlyToHclTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyRetentionMonthlyOutputReference | BackupPolicyVmWorkloadProtectionPolicyRetentionMonthly): any;
export declare class BackupPolicyVmWorkloadProtectionPolicyRetentionMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmWorkloadProtectionPolicyRetentionMonthly | undefined;
    set internalValue(value: BackupPolicyVmWorkloadProtectionPolicyRetentionMonthly | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _formatType?;
    get formatType(): string;
    set formatType(value: string);
    get formatTypeInput(): string | undefined;
    private _monthdays?;
    get monthdays(): number[];
    set monthdays(value: number[]);
    resetMonthdays(): void;
    get monthdaysInput(): number[] | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    resetWeekdays(): void;
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    get weeks(): string[];
    set weeks(value: string[]);
    resetWeeks(): void;
    get weeksInput(): string[] | undefined;
}
export interface BackupPolicyVmWorkloadProtectionPolicyRetentionWeekly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#count BackupPolicyVmWorkload#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#weekdays BackupPolicyVmWorkload#weekdays}
    */
    readonly weekdays: string[];
}
export declare function backupPolicyVmWorkloadProtectionPolicyRetentionWeeklyToTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyRetentionWeeklyOutputReference | BackupPolicyVmWorkloadProtectionPolicyRetentionWeekly): any;
export declare function backupPolicyVmWorkloadProtectionPolicyRetentionWeeklyToHclTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyRetentionWeeklyOutputReference | BackupPolicyVmWorkloadProtectionPolicyRetentionWeekly): any;
export declare class BackupPolicyVmWorkloadProtectionPolicyRetentionWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmWorkloadProtectionPolicyRetentionWeekly | undefined;
    set internalValue(value: BackupPolicyVmWorkloadProtectionPolicyRetentionWeekly | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    get weekdaysInput(): string[] | undefined;
}
export interface BackupPolicyVmWorkloadProtectionPolicyRetentionYearly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#count BackupPolicyVmWorkload#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#format_type BackupPolicyVmWorkload#format_type}
    */
    readonly formatType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#monthdays BackupPolicyVmWorkload#monthdays}
    */
    readonly monthdays?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#months BackupPolicyVmWorkload#months}
    */
    readonly months: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#weekdays BackupPolicyVmWorkload#weekdays}
    */
    readonly weekdays?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#weeks BackupPolicyVmWorkload#weeks}
    */
    readonly weeks?: string[];
}
export declare function backupPolicyVmWorkloadProtectionPolicyRetentionYearlyToTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyRetentionYearlyOutputReference | BackupPolicyVmWorkloadProtectionPolicyRetentionYearly): any;
export declare function backupPolicyVmWorkloadProtectionPolicyRetentionYearlyToHclTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicyRetentionYearlyOutputReference | BackupPolicyVmWorkloadProtectionPolicyRetentionYearly): any;
export declare class BackupPolicyVmWorkloadProtectionPolicyRetentionYearlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmWorkloadProtectionPolicyRetentionYearly | undefined;
    set internalValue(value: BackupPolicyVmWorkloadProtectionPolicyRetentionYearly | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _formatType?;
    get formatType(): string;
    set formatType(value: string);
    get formatTypeInput(): string | undefined;
    private _monthdays?;
    get monthdays(): number[];
    set monthdays(value: number[]);
    resetMonthdays(): void;
    get monthdaysInput(): number[] | undefined;
    private _months?;
    get months(): string[];
    set months(value: string[]);
    get monthsInput(): string[] | undefined;
    private _weekdays?;
    get weekdays(): string[];
    set weekdays(value: string[]);
    resetWeekdays(): void;
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    get weeks(): string[];
    set weeks(value: string[]);
    resetWeeks(): void;
    get weeksInput(): string[] | undefined;
}
export interface BackupPolicyVmWorkloadProtectionPolicySimpleRetention {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#count BackupPolicyVmWorkload#count}
    */
    readonly count: number;
}
export declare function backupPolicyVmWorkloadProtectionPolicySimpleRetentionToTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicySimpleRetentionOutputReference | BackupPolicyVmWorkloadProtectionPolicySimpleRetention): any;
export declare function backupPolicyVmWorkloadProtectionPolicySimpleRetentionToHclTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicySimpleRetentionOutputReference | BackupPolicyVmWorkloadProtectionPolicySimpleRetention): any;
export declare class BackupPolicyVmWorkloadProtectionPolicySimpleRetentionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmWorkloadProtectionPolicySimpleRetention | undefined;
    set internalValue(value: BackupPolicyVmWorkloadProtectionPolicySimpleRetention | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
}
export interface BackupPolicyVmWorkloadProtectionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#policy_type BackupPolicyVmWorkload#policy_type}
    */
    readonly policyType: string;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#backup BackupPolicyVmWorkload#backup}
    */
    readonly backup: BackupPolicyVmWorkloadProtectionPolicyBackup;
    /**
    * retention_daily block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#retention_daily BackupPolicyVmWorkload#retention_daily}
    */
    readonly retentionDaily?: BackupPolicyVmWorkloadProtectionPolicyRetentionDaily;
    /**
    * retention_monthly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#retention_monthly BackupPolicyVmWorkload#retention_monthly}
    */
    readonly retentionMonthly?: BackupPolicyVmWorkloadProtectionPolicyRetentionMonthly;
    /**
    * retention_weekly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#retention_weekly BackupPolicyVmWorkload#retention_weekly}
    */
    readonly retentionWeekly?: BackupPolicyVmWorkloadProtectionPolicyRetentionWeekly;
    /**
    * retention_yearly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#retention_yearly BackupPolicyVmWorkload#retention_yearly}
    */
    readonly retentionYearly?: BackupPolicyVmWorkloadProtectionPolicyRetentionYearly;
    /**
    * simple_retention block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#simple_retention BackupPolicyVmWorkload#simple_retention}
    */
    readonly simpleRetention?: BackupPolicyVmWorkloadProtectionPolicySimpleRetention;
}
export declare function backupPolicyVmWorkloadProtectionPolicyToTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicy | cdktf.IResolvable): any;
export declare function backupPolicyVmWorkloadProtectionPolicyToHclTerraform(struct?: BackupPolicyVmWorkloadProtectionPolicy | cdktf.IResolvable): any;
export declare class BackupPolicyVmWorkloadProtectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BackupPolicyVmWorkloadProtectionPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: BackupPolicyVmWorkloadProtectionPolicy | cdktf.IResolvable | undefined);
    private _policyType?;
    get policyType(): string;
    set policyType(value: string);
    get policyTypeInput(): string | undefined;
    private _backup;
    get backup(): BackupPolicyVmWorkloadProtectionPolicyBackupOutputReference;
    putBackup(value: BackupPolicyVmWorkloadProtectionPolicyBackup): void;
    get backupInput(): BackupPolicyVmWorkloadProtectionPolicyBackup | undefined;
    private _retentionDaily;
    get retentionDaily(): BackupPolicyVmWorkloadProtectionPolicyRetentionDailyOutputReference;
    putRetentionDaily(value: BackupPolicyVmWorkloadProtectionPolicyRetentionDaily): void;
    resetRetentionDaily(): void;
    get retentionDailyInput(): BackupPolicyVmWorkloadProtectionPolicyRetentionDaily | undefined;
    private _retentionMonthly;
    get retentionMonthly(): BackupPolicyVmWorkloadProtectionPolicyRetentionMonthlyOutputReference;
    putRetentionMonthly(value: BackupPolicyVmWorkloadProtectionPolicyRetentionMonthly): void;
    resetRetentionMonthly(): void;
    get retentionMonthlyInput(): BackupPolicyVmWorkloadProtectionPolicyRetentionMonthly | undefined;
    private _retentionWeekly;
    get retentionWeekly(): BackupPolicyVmWorkloadProtectionPolicyRetentionWeeklyOutputReference;
    putRetentionWeekly(value: BackupPolicyVmWorkloadProtectionPolicyRetentionWeekly): void;
    resetRetentionWeekly(): void;
    get retentionWeeklyInput(): BackupPolicyVmWorkloadProtectionPolicyRetentionWeekly | undefined;
    private _retentionYearly;
    get retentionYearly(): BackupPolicyVmWorkloadProtectionPolicyRetentionYearlyOutputReference;
    putRetentionYearly(value: BackupPolicyVmWorkloadProtectionPolicyRetentionYearly): void;
    resetRetentionYearly(): void;
    get retentionYearlyInput(): BackupPolicyVmWorkloadProtectionPolicyRetentionYearly | undefined;
    private _simpleRetention;
    get simpleRetention(): BackupPolicyVmWorkloadProtectionPolicySimpleRetentionOutputReference;
    putSimpleRetention(value: BackupPolicyVmWorkloadProtectionPolicySimpleRetention): void;
    resetSimpleRetention(): void;
    get simpleRetentionInput(): BackupPolicyVmWorkloadProtectionPolicySimpleRetention | undefined;
}
export declare class BackupPolicyVmWorkloadProtectionPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BackupPolicyVmWorkloadProtectionPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BackupPolicyVmWorkloadProtectionPolicyOutputReference;
}
export interface BackupPolicyVmWorkloadSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#compression_enabled BackupPolicyVmWorkload#compression_enabled}
    */
    readonly compressionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#time_zone BackupPolicyVmWorkload#time_zone}
    */
    readonly timeZone: string;
}
export declare function backupPolicyVmWorkloadSettingsToTerraform(struct?: BackupPolicyVmWorkloadSettingsOutputReference | BackupPolicyVmWorkloadSettings): any;
export declare function backupPolicyVmWorkloadSettingsToHclTerraform(struct?: BackupPolicyVmWorkloadSettingsOutputReference | BackupPolicyVmWorkloadSettings): any;
export declare class BackupPolicyVmWorkloadSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmWorkloadSettings | undefined;
    set internalValue(value: BackupPolicyVmWorkloadSettings | undefined);
    private _compressionEnabled?;
    get compressionEnabled(): boolean | cdktf.IResolvable;
    set compressionEnabled(value: boolean | cdktf.IResolvable);
    resetCompressionEnabled(): void;
    get compressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
}
export interface BackupPolicyVmWorkloadTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#create BackupPolicyVmWorkload#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#delete BackupPolicyVmWorkload#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#read BackupPolicyVmWorkload#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#update BackupPolicyVmWorkload#update}
    */
    readonly update?: string;
}
export declare function backupPolicyVmWorkloadTimeoutsToTerraform(struct?: BackupPolicyVmWorkloadTimeouts | cdktf.IResolvable): any;
export declare function backupPolicyVmWorkloadTimeoutsToHclTerraform(struct?: BackupPolicyVmWorkloadTimeouts | cdktf.IResolvable): any;
export declare class BackupPolicyVmWorkloadTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPolicyVmWorkloadTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BackupPolicyVmWorkloadTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload azurerm_backup_policy_vm_workload}
*/
export declare class BackupPolicyVmWorkload extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_backup_policy_vm_workload";
    /**
    * Generates CDKTF code for importing a BackupPolicyVmWorkload resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BackupPolicyVmWorkload to import
    * @param importFromId The id of the existing BackupPolicyVmWorkload that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BackupPolicyVmWorkload to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/backup_policy_vm_workload azurerm_backup_policy_vm_workload} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupPolicyVmWorkloadConfig
    */
    constructor(scope: Construct, id: string, config: BackupPolicyVmWorkloadConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _workloadType?;
    get workloadType(): string;
    set workloadType(value: string);
    get workloadTypeInput(): string | undefined;
    private _protectionPolicy;
    get protectionPolicy(): BackupPolicyVmWorkloadProtectionPolicyList;
    putProtectionPolicy(value: BackupPolicyVmWorkloadProtectionPolicy[] | cdktf.IResolvable): void;
    get protectionPolicyInput(): cdktf.IResolvable | BackupPolicyVmWorkloadProtectionPolicy[] | undefined;
    private _settings;
    get settings(): BackupPolicyVmWorkloadSettingsOutputReference;
    putSettings(value: BackupPolicyVmWorkloadSettings): void;
    get settingsInput(): BackupPolicyVmWorkloadSettings | undefined;
    private _timeouts;
    get timeouts(): BackupPolicyVmWorkloadTimeoutsOutputReference;
    putTimeouts(value: BackupPolicyVmWorkloadTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BackupPolicyVmWorkloadTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
