/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#cdn_frontdoor_profile_id CdnFrontdoorSecret#cdn_frontdoor_profile_id}
    */
    readonly cdnFrontdoorProfileId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#id CdnFrontdoorSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#name CdnFrontdoorSecret#name}
    */
    readonly name: string;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#secret CdnFrontdoorSecret#secret}
    */
    readonly secret: CdnFrontdoorSecretSecret;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#timeouts CdnFrontdoorSecret#timeouts}
    */
    readonly timeouts?: CdnFrontdoorSecretTimeouts;
}
export interface CdnFrontdoorSecretSecretCustomerCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#key_vault_certificate_id CdnFrontdoorSecret#key_vault_certificate_id}
    */
    readonly keyVaultCertificateId: string;
}
export declare function cdnFrontdoorSecretSecretCustomerCertificateToTerraform(struct?: CdnFrontdoorSecretSecretCustomerCertificate | cdktf.IResolvable): any;
export declare function cdnFrontdoorSecretSecretCustomerCertificateToHclTerraform(struct?: CdnFrontdoorSecretSecretCustomerCertificate | cdktf.IResolvable): any;
export declare class CdnFrontdoorSecretSecretCustomerCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorSecretSecretCustomerCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorSecretSecretCustomerCertificate | cdktf.IResolvable | undefined);
    private _keyVaultCertificateId?;
    get keyVaultCertificateId(): string;
    set keyVaultCertificateId(value: string);
    get keyVaultCertificateIdInput(): string | undefined;
    get subjectAlternativeNames(): string[];
}
export declare class CdnFrontdoorSecretSecretCustomerCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorSecretSecretCustomerCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorSecretSecretCustomerCertificateOutputReference;
}
export interface CdnFrontdoorSecretSecret {
    /**
    * customer_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#customer_certificate CdnFrontdoorSecret#customer_certificate}
    */
    readonly customerCertificate: CdnFrontdoorSecretSecretCustomerCertificate[] | cdktf.IResolvable;
}
export declare function cdnFrontdoorSecretSecretToTerraform(struct?: CdnFrontdoorSecretSecretOutputReference | CdnFrontdoorSecretSecret): any;
export declare function cdnFrontdoorSecretSecretToHclTerraform(struct?: CdnFrontdoorSecretSecretOutputReference | CdnFrontdoorSecretSecret): any;
export declare class CdnFrontdoorSecretSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorSecretSecret | undefined;
    set internalValue(value: CdnFrontdoorSecretSecret | undefined);
    private _customerCertificate;
    get customerCertificate(): CdnFrontdoorSecretSecretCustomerCertificateList;
    putCustomerCertificate(value: CdnFrontdoorSecretSecretCustomerCertificate[] | cdktf.IResolvable): void;
    get customerCertificateInput(): cdktf.IResolvable | CdnFrontdoorSecretSecretCustomerCertificate[] | undefined;
}
export interface CdnFrontdoorSecretTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#create CdnFrontdoorSecret#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#delete CdnFrontdoorSecret#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#read CdnFrontdoorSecret#read}
    */
    readonly read?: string;
}
export declare function cdnFrontdoorSecretTimeoutsToTerraform(struct?: CdnFrontdoorSecretTimeouts | cdktf.IResolvable): any;
export declare function cdnFrontdoorSecretTimeoutsToHclTerraform(struct?: CdnFrontdoorSecretTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorSecretTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorSecretTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret azurerm_cdn_frontdoor_secret}
*/
export declare class CdnFrontdoorSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_secret";
    /**
    * Generates CDKTF code for importing a CdnFrontdoorSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnFrontdoorSecret to import
    * @param importFromId The id of the existing CdnFrontdoorSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnFrontdoorSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/cdn_frontdoor_secret azurerm_cdn_frontdoor_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorSecretConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorSecretConfig);
    private _cdnFrontdoorProfileId?;
    get cdnFrontdoorProfileId(): string;
    set cdnFrontdoorProfileId(value: string);
    get cdnFrontdoorProfileIdInput(): string | undefined;
    get cdnFrontdoorProfileName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secret;
    get secret(): CdnFrontdoorSecretSecretOutputReference;
    putSecret(value: CdnFrontdoorSecretSecret): void;
    get secretInput(): CdnFrontdoorSecretSecret | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorSecretTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorSecretTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorSecretTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
