/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAppJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#container_app_environment_id ContainerAppJob#container_app_environment_id}
    */
    readonly containerAppEnvironmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#id ContainerAppJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#location ContainerAppJob#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#replica_retry_limit ContainerAppJob#replica_retry_limit}
    */
    readonly replicaRetryLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#replica_timeout_in_seconds ContainerAppJob#replica_timeout_in_seconds}
    */
    readonly replicaTimeoutInSeconds: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#resource_group_name ContainerAppJob#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#tags ContainerAppJob#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#workload_profile_name ContainerAppJob#workload_profile_name}
    */
    readonly workloadProfileName?: string;
    /**
    * event_trigger_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#event_trigger_config ContainerAppJob#event_trigger_config}
    */
    readonly eventTriggerConfig?: ContainerAppJobEventTriggerConfig;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#identity ContainerAppJob#identity}
    */
    readonly identity?: ContainerAppJobIdentity;
    /**
    * manual_trigger_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#manual_trigger_config ContainerAppJob#manual_trigger_config}
    */
    readonly manualTriggerConfig?: ContainerAppJobManualTriggerConfig;
    /**
    * registry block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#registry ContainerAppJob#registry}
    */
    readonly registry?: ContainerAppJobRegistry[] | cdktf.IResolvable;
    /**
    * schedule_trigger_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#schedule_trigger_config ContainerAppJob#schedule_trigger_config}
    */
    readonly scheduleTriggerConfig?: ContainerAppJobScheduleTriggerConfig;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#secret ContainerAppJob#secret}
    */
    readonly secret?: ContainerAppJobSecret[] | cdktf.IResolvable;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#template ContainerAppJob#template}
    */
    readonly template: ContainerAppJobTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#timeouts ContainerAppJob#timeouts}
    */
    readonly timeouts?: ContainerAppJobTimeouts;
}
export interface ContainerAppJobEventTriggerConfigScaleRulesAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#secret_name ContainerAppJob#secret_name}
    */
    readonly secretName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#trigger_parameter ContainerAppJob#trigger_parameter}
    */
    readonly triggerParameter: string;
}
export declare function containerAppJobEventTriggerConfigScaleRulesAuthenticationToTerraform(struct?: ContainerAppJobEventTriggerConfigScaleRulesAuthentication | cdktf.IResolvable): any;
export declare function containerAppJobEventTriggerConfigScaleRulesAuthenticationToHclTerraform(struct?: ContainerAppJobEventTriggerConfigScaleRulesAuthentication | cdktf.IResolvable): any;
export declare class ContainerAppJobEventTriggerConfigScaleRulesAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobEventTriggerConfigScaleRulesAuthentication | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobEventTriggerConfigScaleRulesAuthentication | cdktf.IResolvable | undefined);
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _triggerParameter?;
    get triggerParameter(): string;
    set triggerParameter(value: string);
    get triggerParameterInput(): string | undefined;
}
export declare class ContainerAppJobEventTriggerConfigScaleRulesAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobEventTriggerConfigScaleRulesAuthentication[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobEventTriggerConfigScaleRulesAuthenticationOutputReference;
}
export interface ContainerAppJobEventTriggerConfigScaleRules {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#custom_rule_type ContainerAppJob#custom_rule_type}
    */
    readonly customRuleType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#metadata ContainerAppJob#metadata}
    */
    readonly metadata: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#authentication ContainerAppJob#authentication}
    */
    readonly authentication?: ContainerAppJobEventTriggerConfigScaleRulesAuthentication[] | cdktf.IResolvable;
}
export declare function containerAppJobEventTriggerConfigScaleRulesToTerraform(struct?: ContainerAppJobEventTriggerConfigScaleRules | cdktf.IResolvable): any;
export declare function containerAppJobEventTriggerConfigScaleRulesToHclTerraform(struct?: ContainerAppJobEventTriggerConfigScaleRules | cdktf.IResolvable): any;
export declare class ContainerAppJobEventTriggerConfigScaleRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobEventTriggerConfigScaleRules | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobEventTriggerConfigScaleRules | cdktf.IResolvable | undefined);
    private _customRuleType?;
    get customRuleType(): string;
    set customRuleType(value: string);
    get customRuleTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _authentication;
    get authentication(): ContainerAppJobEventTriggerConfigScaleRulesAuthenticationList;
    putAuthentication(value: ContainerAppJobEventTriggerConfigScaleRulesAuthentication[] | cdktf.IResolvable): void;
    resetAuthentication(): void;
    get authenticationInput(): cdktf.IResolvable | ContainerAppJobEventTriggerConfigScaleRulesAuthentication[] | undefined;
}
export declare class ContainerAppJobEventTriggerConfigScaleRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobEventTriggerConfigScaleRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobEventTriggerConfigScaleRulesOutputReference;
}
export interface ContainerAppJobEventTriggerConfigScale {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#max_executions ContainerAppJob#max_executions}
    */
    readonly maxExecutions?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#min_executions ContainerAppJob#min_executions}
    */
    readonly minExecutions?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#polling_interval_in_seconds ContainerAppJob#polling_interval_in_seconds}
    */
    readonly pollingIntervalInSeconds?: number;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#rules ContainerAppJob#rules}
    */
    readonly rules?: ContainerAppJobEventTriggerConfigScaleRules[] | cdktf.IResolvable;
}
export declare function containerAppJobEventTriggerConfigScaleToTerraform(struct?: ContainerAppJobEventTriggerConfigScale | cdktf.IResolvable): any;
export declare function containerAppJobEventTriggerConfigScaleToHclTerraform(struct?: ContainerAppJobEventTriggerConfigScale | cdktf.IResolvable): any;
export declare class ContainerAppJobEventTriggerConfigScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobEventTriggerConfigScale | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobEventTriggerConfigScale | cdktf.IResolvable | undefined);
    private _maxExecutions?;
    get maxExecutions(): number;
    set maxExecutions(value: number);
    resetMaxExecutions(): void;
    get maxExecutionsInput(): number | undefined;
    private _minExecutions?;
    get minExecutions(): number;
    set minExecutions(value: number);
    resetMinExecutions(): void;
    get minExecutionsInput(): number | undefined;
    private _pollingIntervalInSeconds?;
    get pollingIntervalInSeconds(): number;
    set pollingIntervalInSeconds(value: number);
    resetPollingIntervalInSeconds(): void;
    get pollingIntervalInSecondsInput(): number | undefined;
    private _rules;
    get rules(): ContainerAppJobEventTriggerConfigScaleRulesList;
    putRules(value: ContainerAppJobEventTriggerConfigScaleRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | ContainerAppJobEventTriggerConfigScaleRules[] | undefined;
}
export declare class ContainerAppJobEventTriggerConfigScaleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobEventTriggerConfigScale[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobEventTriggerConfigScaleOutputReference;
}
export interface ContainerAppJobEventTriggerConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#parallelism ContainerAppJob#parallelism}
    */
    readonly parallelism?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#replica_completion_count ContainerAppJob#replica_completion_count}
    */
    readonly replicaCompletionCount?: number;
    /**
    * scale block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#scale ContainerAppJob#scale}
    */
    readonly scale?: ContainerAppJobEventTriggerConfigScale[] | cdktf.IResolvable;
}
export declare function containerAppJobEventTriggerConfigToTerraform(struct?: ContainerAppJobEventTriggerConfigOutputReference | ContainerAppJobEventTriggerConfig): any;
export declare function containerAppJobEventTriggerConfigToHclTerraform(struct?: ContainerAppJobEventTriggerConfigOutputReference | ContainerAppJobEventTriggerConfig): any;
export declare class ContainerAppJobEventTriggerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppJobEventTriggerConfig | undefined;
    set internalValue(value: ContainerAppJobEventTriggerConfig | undefined);
    private _parallelism?;
    get parallelism(): number;
    set parallelism(value: number);
    resetParallelism(): void;
    get parallelismInput(): number | undefined;
    private _replicaCompletionCount?;
    get replicaCompletionCount(): number;
    set replicaCompletionCount(value: number);
    resetReplicaCompletionCount(): void;
    get replicaCompletionCountInput(): number | undefined;
    private _scale;
    get scale(): ContainerAppJobEventTriggerConfigScaleList;
    putScale(value: ContainerAppJobEventTriggerConfigScale[] | cdktf.IResolvable): void;
    resetScale(): void;
    get scaleInput(): cdktf.IResolvable | ContainerAppJobEventTriggerConfigScale[] | undefined;
}
export interface ContainerAppJobIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#identity_ids ContainerAppJob#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#type ContainerAppJob#type}
    */
    readonly type: string;
}
export declare function containerAppJobIdentityToTerraform(struct?: ContainerAppJobIdentityOutputReference | ContainerAppJobIdentity): any;
export declare function containerAppJobIdentityToHclTerraform(struct?: ContainerAppJobIdentityOutputReference | ContainerAppJobIdentity): any;
export declare class ContainerAppJobIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppJobIdentity | undefined;
    set internalValue(value: ContainerAppJobIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ContainerAppJobManualTriggerConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#parallelism ContainerAppJob#parallelism}
    */
    readonly parallelism?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#replica_completion_count ContainerAppJob#replica_completion_count}
    */
    readonly replicaCompletionCount?: number;
}
export declare function containerAppJobManualTriggerConfigToTerraform(struct?: ContainerAppJobManualTriggerConfigOutputReference | ContainerAppJobManualTriggerConfig): any;
export declare function containerAppJobManualTriggerConfigToHclTerraform(struct?: ContainerAppJobManualTriggerConfigOutputReference | ContainerAppJobManualTriggerConfig): any;
export declare class ContainerAppJobManualTriggerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppJobManualTriggerConfig | undefined;
    set internalValue(value: ContainerAppJobManualTriggerConfig | undefined);
    private _parallelism?;
    get parallelism(): number;
    set parallelism(value: number);
    resetParallelism(): void;
    get parallelismInput(): number | undefined;
    private _replicaCompletionCount?;
    get replicaCompletionCount(): number;
    set replicaCompletionCount(value: number);
    resetReplicaCompletionCount(): void;
    get replicaCompletionCountInput(): number | undefined;
}
export interface ContainerAppJobRegistry {
    /**
    * ID of the System or User Managed Identity used to pull images from the Container Registry
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#identity ContainerAppJob#identity}
    */
    readonly identity?: string;
    /**
    * The name of the Secret Reference containing the password value for this user on the Container Registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#password_secret_name ContainerAppJob#password_secret_name}
    */
    readonly passwordSecretName?: string;
    /**
    * The hostname for the Container Registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#server ContainerAppJob#server}
    */
    readonly server: string;
    /**
    * The username to use for this Container Registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#username ContainerAppJob#username}
    */
    readonly username?: string;
}
export declare function containerAppJobRegistryToTerraform(struct?: ContainerAppJobRegistry | cdktf.IResolvable): any;
export declare function containerAppJobRegistryToHclTerraform(struct?: ContainerAppJobRegistry | cdktf.IResolvable): any;
export declare class ContainerAppJobRegistryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobRegistry | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobRegistry | cdktf.IResolvable | undefined);
    private _identity?;
    get identity(): string;
    set identity(value: string);
    resetIdentity(): void;
    get identityInput(): string | undefined;
    private _passwordSecretName?;
    get passwordSecretName(): string;
    set passwordSecretName(value: string);
    resetPasswordSecretName(): void;
    get passwordSecretNameInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class ContainerAppJobRegistryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobRegistry[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobRegistryOutputReference;
}
export interface ContainerAppJobScheduleTriggerConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#cron_expression ContainerAppJob#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#parallelism ContainerAppJob#parallelism}
    */
    readonly parallelism?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#replica_completion_count ContainerAppJob#replica_completion_count}
    */
    readonly replicaCompletionCount?: number;
}
export declare function containerAppJobScheduleTriggerConfigToTerraform(struct?: ContainerAppJobScheduleTriggerConfigOutputReference | ContainerAppJobScheduleTriggerConfig): any;
export declare function containerAppJobScheduleTriggerConfigToHclTerraform(struct?: ContainerAppJobScheduleTriggerConfigOutputReference | ContainerAppJobScheduleTriggerConfig): any;
export declare class ContainerAppJobScheduleTriggerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppJobScheduleTriggerConfig | undefined;
    set internalValue(value: ContainerAppJobScheduleTriggerConfig | undefined);
    private _cronExpression?;
    get cronExpression(): string;
    set cronExpression(value: string);
    get cronExpressionInput(): string | undefined;
    private _parallelism?;
    get parallelism(): number;
    set parallelism(value: number);
    resetParallelism(): void;
    get parallelismInput(): number | undefined;
    private _replicaCompletionCount?;
    get replicaCompletionCount(): number;
    set replicaCompletionCount(value: number);
    resetReplicaCompletionCount(): void;
    get replicaCompletionCountInput(): number | undefined;
}
export interface ContainerAppJobSecret {
    /**
    * The identity to use for accessing key vault reference.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#identity ContainerAppJob#identity}
    */
    readonly identity?: string;
    /**
    * The Key Vault Secret ID. Could be either one of `id` or `versionless_id`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#key_vault_secret_id ContainerAppJob#key_vault_secret_id}
    */
    readonly keyVaultSecretId?: string;
    /**
    * The secret name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * The value for this secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#value ContainerAppJob#value}
    */
    readonly value?: string;
}
export declare function containerAppJobSecretToTerraform(struct?: ContainerAppJobSecret | cdktf.IResolvable): any;
export declare function containerAppJobSecretToHclTerraform(struct?: ContainerAppJobSecret | cdktf.IResolvable): any;
export declare class ContainerAppJobSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobSecret | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobSecret | cdktf.IResolvable | undefined);
    private _identity?;
    get identity(): string;
    set identity(value: string);
    resetIdentity(): void;
    get identityInput(): string | undefined;
    private _keyVaultSecretId?;
    get keyVaultSecretId(): string;
    set keyVaultSecretId(value: string);
    resetKeyVaultSecretId(): void;
    get keyVaultSecretIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ContainerAppJobSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobSecretOutputReference;
}
export interface ContainerAppJobTemplateContainerEnv {
    /**
    * The name of the environment variable for the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * The name of the secret that contains the value for this environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#secret_name ContainerAppJob#secret_name}
    */
    readonly secretName?: string;
    /**
    * The value for this environment variable. **NOTE:** This value is ignored if `secret_name` is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#value ContainerAppJob#value}
    */
    readonly value?: string;
}
export declare function containerAppJobTemplateContainerEnvToTerraform(struct?: ContainerAppJobTemplateContainerEnv | cdktf.IResolvable): any;
export declare function containerAppJobTemplateContainerEnvToHclTerraform(struct?: ContainerAppJobTemplateContainerEnv | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateContainerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateContainerEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ContainerAppJobTemplateContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateContainerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateContainerEnvOutputReference;
}
export interface ContainerAppJobTemplateContainerLivenessProbeHeader {
    /**
    * The HTTP Header Name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * The HTTP Header value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#value ContainerAppJob#value}
    */
    readonly value: string;
}
export declare function containerAppJobTemplateContainerLivenessProbeHeaderToTerraform(struct?: ContainerAppJobTemplateContainerLivenessProbeHeader | cdktf.IResolvable): any;
export declare function containerAppJobTemplateContainerLivenessProbeHeaderToHclTerraform(struct?: ContainerAppJobTemplateContainerLivenessProbeHeader | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateContainerLivenessProbeHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateContainerLivenessProbeHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateContainerLivenessProbeHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ContainerAppJobTemplateContainerLivenessProbeHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateContainerLivenessProbeHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateContainerLivenessProbeHeaderOutputReference;
}
export interface ContainerAppJobTemplateContainerLivenessProbe {
    /**
    * The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#failure_count_threshold ContainerAppJob#failure_count_threshold}
    */
    readonly failureCountThreshold?: number;
    /**
    * The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `http` and `https` type probes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#host ContainerAppJob#host}
    */
    readonly host?: string;
    /**
    * The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `1` seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#initial_delay ContainerAppJob#initial_delay}
    */
    readonly initialDelay?: number;
    /**
    * How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#interval_seconds ContainerAppJob#interval_seconds}
    */
    readonly intervalSeconds?: number;
    /**
    * The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#path ContainerAppJob#path}
    */
    readonly path?: string;
    /**
    * The port number on which to connect. Possible values are between `1` and `65535`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#port ContainerAppJob#port}
    */
    readonly port: number;
    /**
    * Time in seconds after which the probe times out. Possible values are between `1` an `240`. Defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#timeout ContainerAppJob#timeout}
    */
    readonly timeout?: number;
    /**
    * Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#transport ContainerAppJob#transport}
    */
    readonly transport: string;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#header ContainerAppJob#header}
    */
    readonly header?: ContainerAppJobTemplateContainerLivenessProbeHeader[] | cdktf.IResolvable;
}
export declare function containerAppJobTemplateContainerLivenessProbeToTerraform(struct?: ContainerAppJobTemplateContainerLivenessProbe | cdktf.IResolvable): any;
export declare function containerAppJobTemplateContainerLivenessProbeToHclTerraform(struct?: ContainerAppJobTemplateContainerLivenessProbe | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateContainerLivenessProbe | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateContainerLivenessProbe | cdktf.IResolvable | undefined);
    private _failureCountThreshold?;
    get failureCountThreshold(): number;
    set failureCountThreshold(value: number);
    resetFailureCountThreshold(): void;
    get failureCountThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _initialDelay?;
    get initialDelay(): number;
    set initialDelay(value: number);
    resetInitialDelay(): void;
    get initialDelayInput(): number | undefined;
    private _intervalSeconds?;
    get intervalSeconds(): number;
    set intervalSeconds(value: number);
    resetIntervalSeconds(): void;
    get intervalSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    get terminationGracePeriodSeconds(): number;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _transport?;
    get transport(): string;
    set transport(value: string);
    get transportInput(): string | undefined;
    private _header;
    get header(): ContainerAppJobTemplateContainerLivenessProbeHeaderList;
    putHeader(value: ContainerAppJobTemplateContainerLivenessProbeHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ContainerAppJobTemplateContainerLivenessProbeHeader[] | undefined;
}
export declare class ContainerAppJobTemplateContainerLivenessProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateContainerLivenessProbe[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateContainerLivenessProbeOutputReference;
}
export interface ContainerAppJobTemplateContainerReadinessProbeHeader {
    /**
    * The HTTP Header Name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * The HTTP Header value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#value ContainerAppJob#value}
    */
    readonly value: string;
}
export declare function containerAppJobTemplateContainerReadinessProbeHeaderToTerraform(struct?: ContainerAppJobTemplateContainerReadinessProbeHeader | cdktf.IResolvable): any;
export declare function containerAppJobTemplateContainerReadinessProbeHeaderToHclTerraform(struct?: ContainerAppJobTemplateContainerReadinessProbeHeader | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateContainerReadinessProbeHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateContainerReadinessProbeHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateContainerReadinessProbeHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ContainerAppJobTemplateContainerReadinessProbeHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateContainerReadinessProbeHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateContainerReadinessProbeHeaderOutputReference;
}
export interface ContainerAppJobTemplateContainerReadinessProbe {
    /**
    * The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#failure_count_threshold ContainerAppJob#failure_count_threshold}
    */
    readonly failureCountThreshold?: number;
    /**
    * The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `http` and `https` type probes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#host ContainerAppJob#host}
    */
    readonly host?: string;
    /**
    * The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#initial_delay ContainerAppJob#initial_delay}
    */
    readonly initialDelay?: number;
    /**
    * How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#interval_seconds ContainerAppJob#interval_seconds}
    */
    readonly intervalSeconds?: number;
    /**
    * The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#path ContainerAppJob#path}
    */
    readonly path?: string;
    /**
    * The port number on which to connect. Possible values are between `1` and `65535`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#port ContainerAppJob#port}
    */
    readonly port: number;
    /**
    * The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#success_count_threshold ContainerAppJob#success_count_threshold}
    */
    readonly successCountThreshold?: number;
    /**
    * Time in seconds after which the probe times out. Possible values are between `1` an `240`. Defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#timeout ContainerAppJob#timeout}
    */
    readonly timeout?: number;
    /**
    * Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#transport ContainerAppJob#transport}
    */
    readonly transport: string;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#header ContainerAppJob#header}
    */
    readonly header?: ContainerAppJobTemplateContainerReadinessProbeHeader[] | cdktf.IResolvable;
}
export declare function containerAppJobTemplateContainerReadinessProbeToTerraform(struct?: ContainerAppJobTemplateContainerReadinessProbe | cdktf.IResolvable): any;
export declare function containerAppJobTemplateContainerReadinessProbeToHclTerraform(struct?: ContainerAppJobTemplateContainerReadinessProbe | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateContainerReadinessProbe | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateContainerReadinessProbe | cdktf.IResolvable | undefined);
    private _failureCountThreshold?;
    get failureCountThreshold(): number;
    set failureCountThreshold(value: number);
    resetFailureCountThreshold(): void;
    get failureCountThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _initialDelay?;
    get initialDelay(): number;
    set initialDelay(value: number);
    resetInitialDelay(): void;
    get initialDelayInput(): number | undefined;
    private _intervalSeconds?;
    get intervalSeconds(): number;
    set intervalSeconds(value: number);
    resetIntervalSeconds(): void;
    get intervalSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _successCountThreshold?;
    get successCountThreshold(): number;
    set successCountThreshold(value: number);
    resetSuccessCountThreshold(): void;
    get successCountThresholdInput(): number | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _transport?;
    get transport(): string;
    set transport(value: string);
    get transportInput(): string | undefined;
    private _header;
    get header(): ContainerAppJobTemplateContainerReadinessProbeHeaderList;
    putHeader(value: ContainerAppJobTemplateContainerReadinessProbeHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ContainerAppJobTemplateContainerReadinessProbeHeader[] | undefined;
}
export declare class ContainerAppJobTemplateContainerReadinessProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateContainerReadinessProbe[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateContainerReadinessProbeOutputReference;
}
export interface ContainerAppJobTemplateContainerStartupProbeHeader {
    /**
    * The HTTP Header Name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * The HTTP Header value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#value ContainerAppJob#value}
    */
    readonly value: string;
}
export declare function containerAppJobTemplateContainerStartupProbeHeaderToTerraform(struct?: ContainerAppJobTemplateContainerStartupProbeHeader | cdktf.IResolvable): any;
export declare function containerAppJobTemplateContainerStartupProbeHeaderToHclTerraform(struct?: ContainerAppJobTemplateContainerStartupProbeHeader | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateContainerStartupProbeHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateContainerStartupProbeHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateContainerStartupProbeHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ContainerAppJobTemplateContainerStartupProbeHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateContainerStartupProbeHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateContainerStartupProbeHeaderOutputReference;
}
export interface ContainerAppJobTemplateContainerStartupProbe {
    /**
    * The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#failure_count_threshold ContainerAppJob#failure_count_threshold}
    */
    readonly failureCountThreshold?: number;
    /**
    * The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `http` and `https` type probes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#host ContainerAppJob#host}
    */
    readonly host?: string;
    /**
    * The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#initial_delay ContainerAppJob#initial_delay}
    */
    readonly initialDelay?: number;
    /**
    * How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#interval_seconds ContainerAppJob#interval_seconds}
    */
    readonly intervalSeconds?: number;
    /**
    * The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#path ContainerAppJob#path}
    */
    readonly path?: string;
    /**
    * The port number on which to connect. Possible values are between `1` and `65535`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#port ContainerAppJob#port}
    */
    readonly port: number;
    /**
    * Time in seconds after which the probe times out. Possible values are between `1` an `240`. Defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#timeout ContainerAppJob#timeout}
    */
    readonly timeout?: number;
    /**
    * Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#transport ContainerAppJob#transport}
    */
    readonly transport: string;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#header ContainerAppJob#header}
    */
    readonly header?: ContainerAppJobTemplateContainerStartupProbeHeader[] | cdktf.IResolvable;
}
export declare function containerAppJobTemplateContainerStartupProbeToTerraform(struct?: ContainerAppJobTemplateContainerStartupProbe | cdktf.IResolvable): any;
export declare function containerAppJobTemplateContainerStartupProbeToHclTerraform(struct?: ContainerAppJobTemplateContainerStartupProbe | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateContainerStartupProbe | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateContainerStartupProbe | cdktf.IResolvable | undefined);
    private _failureCountThreshold?;
    get failureCountThreshold(): number;
    set failureCountThreshold(value: number);
    resetFailureCountThreshold(): void;
    get failureCountThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _initialDelay?;
    get initialDelay(): number;
    set initialDelay(value: number);
    resetInitialDelay(): void;
    get initialDelayInput(): number | undefined;
    private _intervalSeconds?;
    get intervalSeconds(): number;
    set intervalSeconds(value: number);
    resetIntervalSeconds(): void;
    get intervalSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    get terminationGracePeriodSeconds(): number;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _transport?;
    get transport(): string;
    set transport(value: string);
    get transportInput(): string | undefined;
    private _header;
    get header(): ContainerAppJobTemplateContainerStartupProbeHeaderList;
    putHeader(value: ContainerAppJobTemplateContainerStartupProbeHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ContainerAppJobTemplateContainerStartupProbeHeader[] | undefined;
}
export declare class ContainerAppJobTemplateContainerStartupProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateContainerStartupProbe[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateContainerStartupProbeOutputReference;
}
export interface ContainerAppJobTemplateContainerVolumeMounts {
    /**
    * The name of the Volume to be mounted in the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * The path in the container at which to mount this volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#path ContainerAppJob#path}
    */
    readonly path: string;
    /**
    * The sub path of the volume to be mounted in the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#sub_path ContainerAppJob#sub_path}
    */
    readonly subPath?: string;
}
export declare function containerAppJobTemplateContainerVolumeMountsToTerraform(struct?: ContainerAppJobTemplateContainerVolumeMounts | cdktf.IResolvable): any;
export declare function containerAppJobTemplateContainerVolumeMountsToHclTerraform(struct?: ContainerAppJobTemplateContainerVolumeMounts | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateContainerVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateContainerVolumeMounts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateContainerVolumeMounts | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _subPath?;
    get subPath(): string;
    set subPath(value: string);
    resetSubPath(): void;
    get subPathInput(): string | undefined;
}
export declare class ContainerAppJobTemplateContainerVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateContainerVolumeMounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateContainerVolumeMountsOutputReference;
}
export interface ContainerAppJobTemplateContainer {
    /**
    * A list of args to pass to the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#args ContainerAppJob#args}
    */
    readonly args?: string[];
    /**
    * A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#command ContainerAppJob#command}
    */
    readonly command?: string[];
    /**
    * The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`. **NOTE:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`. When there's a workload profile specified, there's no such constraint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#cpu ContainerAppJob#cpu}
    */
    readonly cpu: number;
    /**
    * The image to use to create the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#image ContainerAppJob#image}
    */
    readonly image: string;
    /**
    * The amount of memory to allocate to the container. Possible values include `0.5Gi`, `1.0Gi`, `1.5Gi`, `2.0Gi`, `2.5Gi`, `3.0Gi`, `3.5Gi`, and `4.0Gi`. **NOTE:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`. When there's a workload profile specified, there's no such constraint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#memory ContainerAppJob#memory}
    */
    readonly memory: string;
    /**
    * The name of the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#env ContainerAppJob#env}
    */
    readonly env?: ContainerAppJobTemplateContainerEnv[] | cdktf.IResolvable;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#liveness_probe ContainerAppJob#liveness_probe}
    */
    readonly livenessProbe?: ContainerAppJobTemplateContainerLivenessProbe[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#readiness_probe ContainerAppJob#readiness_probe}
    */
    readonly readinessProbe?: ContainerAppJobTemplateContainerReadinessProbe[] | cdktf.IResolvable;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#startup_probe ContainerAppJob#startup_probe}
    */
    readonly startupProbe?: ContainerAppJobTemplateContainerStartupProbe[] | cdktf.IResolvable;
    /**
    * volume_mounts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#volume_mounts ContainerAppJob#volume_mounts}
    */
    readonly volumeMounts?: ContainerAppJobTemplateContainerVolumeMounts[] | cdktf.IResolvable;
}
export declare function containerAppJobTemplateContainerToTerraform(struct?: ContainerAppJobTemplateContainer | cdktf.IResolvable): any;
export declare function containerAppJobTemplateContainerToHclTerraform(struct?: ContainerAppJobTemplateContainer | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateContainer | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    get cpuInput(): number | undefined;
    get ephemeralStorage(): string;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    get memoryInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _env;
    get env(): ContainerAppJobTemplateContainerEnvList;
    putEnv(value: ContainerAppJobTemplateContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | ContainerAppJobTemplateContainerEnv[] | undefined;
    private _livenessProbe;
    get livenessProbe(): ContainerAppJobTemplateContainerLivenessProbeList;
    putLivenessProbe(value: ContainerAppJobTemplateContainerLivenessProbe[] | cdktf.IResolvable): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): cdktf.IResolvable | ContainerAppJobTemplateContainerLivenessProbe[] | undefined;
    private _readinessProbe;
    get readinessProbe(): ContainerAppJobTemplateContainerReadinessProbeList;
    putReadinessProbe(value: ContainerAppJobTemplateContainerReadinessProbe[] | cdktf.IResolvable): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): cdktf.IResolvable | ContainerAppJobTemplateContainerReadinessProbe[] | undefined;
    private _startupProbe;
    get startupProbe(): ContainerAppJobTemplateContainerStartupProbeList;
    putStartupProbe(value: ContainerAppJobTemplateContainerStartupProbe[] | cdktf.IResolvable): void;
    resetStartupProbe(): void;
    get startupProbeInput(): cdktf.IResolvable | ContainerAppJobTemplateContainerStartupProbe[] | undefined;
    private _volumeMounts;
    get volumeMounts(): ContainerAppJobTemplateContainerVolumeMountsList;
    putVolumeMounts(value: ContainerAppJobTemplateContainerVolumeMounts[] | cdktf.IResolvable): void;
    resetVolumeMounts(): void;
    get volumeMountsInput(): cdktf.IResolvable | ContainerAppJobTemplateContainerVolumeMounts[] | undefined;
}
export declare class ContainerAppJobTemplateContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateContainerOutputReference;
}
export interface ContainerAppJobTemplateInitContainerEnv {
    /**
    * The name of the environment variable for the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * The name of the secret that contains the value for this environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#secret_name ContainerAppJob#secret_name}
    */
    readonly secretName?: string;
    /**
    * The value for this environment variable. **NOTE:** This value is ignored if `secret_name` is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#value ContainerAppJob#value}
    */
    readonly value?: string;
}
export declare function containerAppJobTemplateInitContainerEnvToTerraform(struct?: ContainerAppJobTemplateInitContainerEnv | cdktf.IResolvable): any;
export declare function containerAppJobTemplateInitContainerEnvToHclTerraform(struct?: ContainerAppJobTemplateInitContainerEnv | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateInitContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateInitContainerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateInitContainerEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ContainerAppJobTemplateInitContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateInitContainerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateInitContainerEnvOutputReference;
}
export interface ContainerAppJobTemplateInitContainerVolumeMounts {
    /**
    * The name of the Volume to be mounted in the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * The path in the container at which to mount this volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#path ContainerAppJob#path}
    */
    readonly path: string;
    /**
    * The sub path of the volume to be mounted in the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#sub_path ContainerAppJob#sub_path}
    */
    readonly subPath?: string;
}
export declare function containerAppJobTemplateInitContainerVolumeMountsToTerraform(struct?: ContainerAppJobTemplateInitContainerVolumeMounts | cdktf.IResolvable): any;
export declare function containerAppJobTemplateInitContainerVolumeMountsToHclTerraform(struct?: ContainerAppJobTemplateInitContainerVolumeMounts | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateInitContainerVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateInitContainerVolumeMounts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateInitContainerVolumeMounts | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _subPath?;
    get subPath(): string;
    set subPath(value: string);
    resetSubPath(): void;
    get subPathInput(): string | undefined;
}
export declare class ContainerAppJobTemplateInitContainerVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateInitContainerVolumeMounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateInitContainerVolumeMountsOutputReference;
}
export interface ContainerAppJobTemplateInitContainer {
    /**
    * A list of args to pass to the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#args ContainerAppJob#args}
    */
    readonly args?: string[];
    /**
    * A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#command ContainerAppJob#command}
    */
    readonly command?: string[];
    /**
    * The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`. **NOTE:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`. When there's a workload profile specified, there's no such constraint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#cpu ContainerAppJob#cpu}
    */
    readonly cpu?: number;
    /**
    * The image to use to create the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#image ContainerAppJob#image}
    */
    readonly image: string;
    /**
    * The amount of memory to allocate to the container. Possible values include `0.5Gi`, `1.0Gi`, `1.5Gi`, `2.0Gi`, `2.5Gi`, `3.0Gi`, `3.5Gi`, and `4.0Gi`. **NOTE:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`. When there's a workload profile specified, there's no such constraint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#memory ContainerAppJob#memory}
    */
    readonly memory?: string;
    /**
    * The name of the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#env ContainerAppJob#env}
    */
    readonly env?: ContainerAppJobTemplateInitContainerEnv[] | cdktf.IResolvable;
    /**
    * volume_mounts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#volume_mounts ContainerAppJob#volume_mounts}
    */
    readonly volumeMounts?: ContainerAppJobTemplateInitContainerVolumeMounts[] | cdktf.IResolvable;
}
export declare function containerAppJobTemplateInitContainerToTerraform(struct?: ContainerAppJobTemplateInitContainer | cdktf.IResolvable): any;
export declare function containerAppJobTemplateInitContainerToHclTerraform(struct?: ContainerAppJobTemplateInitContainer | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateInitContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateInitContainer | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateInitContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    resetCpu(): void;
    get cpuInput(): number | undefined;
    get ephemeralStorage(): string;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _env;
    get env(): ContainerAppJobTemplateInitContainerEnvList;
    putEnv(value: ContainerAppJobTemplateInitContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | ContainerAppJobTemplateInitContainerEnv[] | undefined;
    private _volumeMounts;
    get volumeMounts(): ContainerAppJobTemplateInitContainerVolumeMountsList;
    putVolumeMounts(value: ContainerAppJobTemplateInitContainerVolumeMounts[] | cdktf.IResolvable): void;
    resetVolumeMounts(): void;
    get volumeMountsInput(): cdktf.IResolvable | ContainerAppJobTemplateInitContainerVolumeMounts[] | undefined;
}
export declare class ContainerAppJobTemplateInitContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateInitContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateInitContainerOutputReference;
}
export interface ContainerAppJobTemplateVolume {
    /**
    * Mount options used while mounting the AzureFile. Must be a comma-separated string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#mount_options ContainerAppJob#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * The name of the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#name ContainerAppJob#name}
    */
    readonly name: string;
    /**
    * The name of the `AzureFile` storage. Required when `storage_type` is `AzureFile`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#storage_name ContainerAppJob#storage_name}
    */
    readonly storageName?: string;
    /**
    * The type of storage volume. Possible values include `AzureFile` and `EmptyDir`. Defaults to `EmptyDir`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#storage_type ContainerAppJob#storage_type}
    */
    readonly storageType?: string;
}
export declare function containerAppJobTemplateVolumeToTerraform(struct?: ContainerAppJobTemplateVolume | cdktf.IResolvable): any;
export declare function containerAppJobTemplateVolumeToHclTerraform(struct?: ContainerAppJobTemplateVolume | cdktf.IResolvable): any;
export declare class ContainerAppJobTemplateVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppJobTemplateVolume | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTemplateVolume | cdktf.IResolvable | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageName?;
    get storageName(): string;
    set storageName(value: string);
    resetStorageName(): void;
    get storageNameInput(): string | undefined;
    private _storageType?;
    get storageType(): string;
    set storageType(value: string);
    resetStorageType(): void;
    get storageTypeInput(): string | undefined;
}
export declare class ContainerAppJobTemplateVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppJobTemplateVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppJobTemplateVolumeOutputReference;
}
export interface ContainerAppJobTemplate {
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#container ContainerAppJob#container}
    */
    readonly container: ContainerAppJobTemplateContainer[] | cdktf.IResolvable;
    /**
    * init_container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#init_container ContainerAppJob#init_container}
    */
    readonly initContainer?: ContainerAppJobTemplateInitContainer[] | cdktf.IResolvable;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#volume ContainerAppJob#volume}
    */
    readonly volume?: ContainerAppJobTemplateVolume[] | cdktf.IResolvable;
}
export declare function containerAppJobTemplateToTerraform(struct?: ContainerAppJobTemplateOutputReference | ContainerAppJobTemplate): any;
export declare function containerAppJobTemplateToHclTerraform(struct?: ContainerAppJobTemplateOutputReference | ContainerAppJobTemplate): any;
export declare class ContainerAppJobTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppJobTemplate | undefined;
    set internalValue(value: ContainerAppJobTemplate | undefined);
    private _container;
    get container(): ContainerAppJobTemplateContainerList;
    putContainer(value: ContainerAppJobTemplateContainer[] | cdktf.IResolvable): void;
    get containerInput(): cdktf.IResolvable | ContainerAppJobTemplateContainer[] | undefined;
    private _initContainer;
    get initContainer(): ContainerAppJobTemplateInitContainerList;
    putInitContainer(value: ContainerAppJobTemplateInitContainer[] | cdktf.IResolvable): void;
    resetInitContainer(): void;
    get initContainerInput(): cdktf.IResolvable | ContainerAppJobTemplateInitContainer[] | undefined;
    private _volume;
    get volume(): ContainerAppJobTemplateVolumeList;
    putVolume(value: ContainerAppJobTemplateVolume[] | cdktf.IResolvable): void;
    resetVolume(): void;
    get volumeInput(): cdktf.IResolvable | ContainerAppJobTemplateVolume[] | undefined;
}
export interface ContainerAppJobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#create ContainerAppJob#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#delete ContainerAppJob#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#read ContainerAppJob#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#update ContainerAppJob#update}
    */
    readonly update?: string;
}
export declare function containerAppJobTimeoutsToTerraform(struct?: ContainerAppJobTimeouts | cdktf.IResolvable): any;
export declare function containerAppJobTimeoutsToHclTerraform(struct?: ContainerAppJobTimeouts | cdktf.IResolvable): any;
export declare class ContainerAppJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppJobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppJobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job azurerm_container_app_job}
*/
export declare class ContainerAppJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_app_job";
    /**
    * Generates CDKTF code for importing a ContainerAppJob resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerAppJob to import
    * @param importFromId The id of the existing ContainerAppJob that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerAppJob to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/container_app_job azurerm_container_app_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAppJobConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAppJobConfig);
    private _containerAppEnvironmentId?;
    get containerAppEnvironmentId(): string;
    set containerAppEnvironmentId(value: string);
    get containerAppEnvironmentIdInput(): string | undefined;
    get eventStreamEndpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddresses(): string[];
    private _replicaRetryLimit?;
    get replicaRetryLimit(): number;
    set replicaRetryLimit(value: number);
    resetReplicaRetryLimit(): void;
    get replicaRetryLimitInput(): number | undefined;
    private _replicaTimeoutInSeconds?;
    get replicaTimeoutInSeconds(): number;
    set replicaTimeoutInSeconds(value: number);
    get replicaTimeoutInSecondsInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workloadProfileName?;
    get workloadProfileName(): string;
    set workloadProfileName(value: string);
    resetWorkloadProfileName(): void;
    get workloadProfileNameInput(): string | undefined;
    private _eventTriggerConfig;
    get eventTriggerConfig(): ContainerAppJobEventTriggerConfigOutputReference;
    putEventTriggerConfig(value: ContainerAppJobEventTriggerConfig): void;
    resetEventTriggerConfig(): void;
    get eventTriggerConfigInput(): ContainerAppJobEventTriggerConfig | undefined;
    private _identity;
    get identity(): ContainerAppJobIdentityOutputReference;
    putIdentity(value: ContainerAppJobIdentity): void;
    resetIdentity(): void;
    get identityInput(): ContainerAppJobIdentity | undefined;
    private _manualTriggerConfig;
    get manualTriggerConfig(): ContainerAppJobManualTriggerConfigOutputReference;
    putManualTriggerConfig(value: ContainerAppJobManualTriggerConfig): void;
    resetManualTriggerConfig(): void;
    get manualTriggerConfigInput(): ContainerAppJobManualTriggerConfig | undefined;
    private _registry;
    get registry(): ContainerAppJobRegistryList;
    putRegistry(value: ContainerAppJobRegistry[] | cdktf.IResolvable): void;
    resetRegistry(): void;
    get registryInput(): cdktf.IResolvable | ContainerAppJobRegistry[] | undefined;
    private _scheduleTriggerConfig;
    get scheduleTriggerConfig(): ContainerAppJobScheduleTriggerConfigOutputReference;
    putScheduleTriggerConfig(value: ContainerAppJobScheduleTriggerConfig): void;
    resetScheduleTriggerConfig(): void;
    get scheduleTriggerConfigInput(): ContainerAppJobScheduleTriggerConfig | undefined;
    private _secret;
    get secret(): ContainerAppJobSecretList;
    putSecret(value: ContainerAppJobSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | ContainerAppJobSecret[] | undefined;
    private _template;
    get template(): ContainerAppJobTemplateOutputReference;
    putTemplate(value: ContainerAppJobTemplate): void;
    get templateInput(): ContainerAppJobTemplate | undefined;
    private _timeouts;
    get timeouts(): ContainerAppJobTimeoutsOutputReference;
    putTimeouts(value: ContainerAppJobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAppJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
