/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAdvisorRecommendationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/advisor_recommendations#filter_by_category DataAzurermAdvisorRecommendations#filter_by_category}
    */
    readonly filterByCategory?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/advisor_recommendations#filter_by_resource_groups DataAzurermAdvisorRecommendations#filter_by_resource_groups}
    */
    readonly filterByResourceGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/advisor_recommendations#id DataAzurermAdvisorRecommendations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/advisor_recommendations#timeouts DataAzurermAdvisorRecommendations#timeouts}
    */
    readonly timeouts?: DataAzurermAdvisorRecommendationsTimeouts;
}
export interface DataAzurermAdvisorRecommendationsRecommendations {
}
export declare function dataAzurermAdvisorRecommendationsRecommendationsToTerraform(struct?: DataAzurermAdvisorRecommendationsRecommendations): any;
export declare function dataAzurermAdvisorRecommendationsRecommendationsToHclTerraform(struct?: DataAzurermAdvisorRecommendationsRecommendations): any;
export declare class DataAzurermAdvisorRecommendationsRecommendationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAdvisorRecommendationsRecommendations | undefined;
    set internalValue(value: DataAzurermAdvisorRecommendationsRecommendations | undefined);
    get category(): string;
    get description(): string;
    get impact(): string;
    get recommendationName(): string;
    get recommendationTypeId(): string;
    get resourceName(): string;
    get resourceType(): string;
    get suppressionNames(): string[];
    get updatedTime(): string;
}
export declare class DataAzurermAdvisorRecommendationsRecommendationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAdvisorRecommendationsRecommendationsOutputReference;
}
export interface DataAzurermAdvisorRecommendationsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/advisor_recommendations#read DataAzurermAdvisorRecommendations#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAdvisorRecommendationsTimeoutsToTerraform(struct?: DataAzurermAdvisorRecommendationsTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermAdvisorRecommendationsTimeoutsToHclTerraform(struct?: DataAzurermAdvisorRecommendationsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAdvisorRecommendationsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAdvisorRecommendationsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAdvisorRecommendationsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/advisor_recommendations azurerm_advisor_recommendations}
*/
export declare class DataAzurermAdvisorRecommendations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_advisor_recommendations";
    /**
    * Generates CDKTF code for importing a DataAzurermAdvisorRecommendations resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermAdvisorRecommendations to import
    * @param importFromId The id of the existing DataAzurermAdvisorRecommendations that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/advisor_recommendations#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermAdvisorRecommendations to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/advisor_recommendations azurerm_advisor_recommendations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAdvisorRecommendationsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermAdvisorRecommendationsConfig);
    private _filterByCategory?;
    get filterByCategory(): string[];
    set filterByCategory(value: string[]);
    resetFilterByCategory(): void;
    get filterByCategoryInput(): string[] | undefined;
    private _filterByResourceGroups?;
    get filterByResourceGroups(): string[];
    set filterByResourceGroups(value: string[]);
    resetFilterByResourceGroups(): void;
    get filterByResourceGroupsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _recommendations;
    get recommendations(): DataAzurermAdvisorRecommendationsRecommendationsList;
    private _timeouts;
    get timeouts(): DataAzurermAdvisorRecommendationsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAdvisorRecommendationsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAdvisorRecommendationsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
