/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBatchAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/batch_account#id DataAzurermBatchAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/batch_account#name DataAzurermBatchAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/batch_account#resource_group_name DataAzurermBatchAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/batch_account#timeouts DataAzurermBatchAccount#timeouts}
    */
    readonly timeouts?: DataAzurermBatchAccountTimeouts;
}
export interface DataAzurermBatchAccountEncryption {
}
export declare function dataAzurermBatchAccountEncryptionToTerraform(struct?: DataAzurermBatchAccountEncryption): any;
export declare function dataAzurermBatchAccountEncryptionToHclTerraform(struct?: DataAzurermBatchAccountEncryption): any;
export declare class DataAzurermBatchAccountEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchAccountEncryption | undefined;
    set internalValue(value: DataAzurermBatchAccountEncryption | undefined);
    get keyVaultKeyId(): string;
}
export declare class DataAzurermBatchAccountEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchAccountEncryptionOutputReference;
}
export interface DataAzurermBatchAccountKeyVaultReference {
}
export declare function dataAzurermBatchAccountKeyVaultReferenceToTerraform(struct?: DataAzurermBatchAccountKeyVaultReference): any;
export declare function dataAzurermBatchAccountKeyVaultReferenceToHclTerraform(struct?: DataAzurermBatchAccountKeyVaultReference): any;
export declare class DataAzurermBatchAccountKeyVaultReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchAccountKeyVaultReference | undefined;
    set internalValue(value: DataAzurermBatchAccountKeyVaultReference | undefined);
    get id(): string;
    get url(): string;
}
export declare class DataAzurermBatchAccountKeyVaultReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchAccountKeyVaultReferenceOutputReference;
}
export interface DataAzurermBatchAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/batch_account#read DataAzurermBatchAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBatchAccountTimeoutsToTerraform(struct?: DataAzurermBatchAccountTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermBatchAccountTimeoutsToHclTerraform(struct?: DataAzurermBatchAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBatchAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBatchAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermBatchAccountTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/batch_account azurerm_batch_account}
*/
export declare class DataAzurermBatchAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_batch_account";
    /**
    * Generates CDKTF code for importing a DataAzurermBatchAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermBatchAccount to import
    * @param importFromId The id of the existing DataAzurermBatchAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/batch_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermBatchAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/batch_account azurerm_batch_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBatchAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBatchAccountConfig);
    get accountEndpoint(): string;
    private _encryption;
    get encryption(): DataAzurermBatchAccountEncryptionList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultReference;
    get keyVaultReference(): DataAzurermBatchAccountKeyVaultReferenceList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get poolAllocationMode(): string;
    get primaryAccessKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get storageAccountId(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermBatchAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBatchAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermBatchAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
