/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/container_app#id DataAzurermContainerApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/container_app#name DataAzurermContainerApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/container_app#resource_group_name DataAzurermContainerApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/container_app#timeouts DataAzurermContainerApp#timeouts}
    */
    readonly timeouts?: DataAzurermContainerAppTimeouts;
}
export interface DataAzurermContainerAppDapr {
}
export declare function dataAzurermContainerAppDaprToTerraform(struct?: DataAzurermContainerAppDapr): any;
export declare function dataAzurermContainerAppDaprToHclTerraform(struct?: DataAzurermContainerAppDapr): any;
export declare class DataAzurermContainerAppDaprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppDapr | undefined;
    set internalValue(value: DataAzurermContainerAppDapr | undefined);
    get appId(): string;
    get appPort(): number;
    get appProtocol(): string;
}
export declare class DataAzurermContainerAppDaprList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppDaprOutputReference;
}
export interface DataAzurermContainerAppIdentity {
}
export declare function dataAzurermContainerAppIdentityToTerraform(struct?: DataAzurermContainerAppIdentity): any;
export declare function dataAzurermContainerAppIdentityToHclTerraform(struct?: DataAzurermContainerAppIdentity): any;
export declare class DataAzurermContainerAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppIdentity | undefined;
    set internalValue(value: DataAzurermContainerAppIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermContainerAppIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppIdentityOutputReference;
}
export interface DataAzurermContainerAppIngressCustomDomain {
}
export declare function dataAzurermContainerAppIngressCustomDomainToTerraform(struct?: DataAzurermContainerAppIngressCustomDomain): any;
export declare function dataAzurermContainerAppIngressCustomDomainToHclTerraform(struct?: DataAzurermContainerAppIngressCustomDomain): any;
export declare class DataAzurermContainerAppIngressCustomDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppIngressCustomDomain | undefined;
    set internalValue(value: DataAzurermContainerAppIngressCustomDomain | undefined);
    get certificateBindingType(): string;
    get certificateId(): string;
    get name(): string;
}
export declare class DataAzurermContainerAppIngressCustomDomainList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppIngressCustomDomainOutputReference;
}
export interface DataAzurermContainerAppIngressIpSecurityRestriction {
}
export declare function dataAzurermContainerAppIngressIpSecurityRestrictionToTerraform(struct?: DataAzurermContainerAppIngressIpSecurityRestriction): any;
export declare function dataAzurermContainerAppIngressIpSecurityRestrictionToHclTerraform(struct?: DataAzurermContainerAppIngressIpSecurityRestriction): any;
export declare class DataAzurermContainerAppIngressIpSecurityRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppIngressIpSecurityRestriction | undefined;
    set internalValue(value: DataAzurermContainerAppIngressIpSecurityRestriction | undefined);
    get action(): string;
    get description(): string;
    get ipAddressRange(): string;
    get name(): string;
}
export declare class DataAzurermContainerAppIngressIpSecurityRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppIngressIpSecurityRestrictionOutputReference;
}
export interface DataAzurermContainerAppIngressTrafficWeight {
}
export declare function dataAzurermContainerAppIngressTrafficWeightToTerraform(struct?: DataAzurermContainerAppIngressTrafficWeight): any;
export declare function dataAzurermContainerAppIngressTrafficWeightToHclTerraform(struct?: DataAzurermContainerAppIngressTrafficWeight): any;
export declare class DataAzurermContainerAppIngressTrafficWeightOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppIngressTrafficWeight | undefined;
    set internalValue(value: DataAzurermContainerAppIngressTrafficWeight | undefined);
    get label(): string;
    get latestRevision(): cdktf.IResolvable;
    get percentage(): number;
    get revisionSuffix(): string;
}
export declare class DataAzurermContainerAppIngressTrafficWeightList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppIngressTrafficWeightOutputReference;
}
export interface DataAzurermContainerAppIngress {
}
export declare function dataAzurermContainerAppIngressToTerraform(struct?: DataAzurermContainerAppIngress): any;
export declare function dataAzurermContainerAppIngressToHclTerraform(struct?: DataAzurermContainerAppIngress): any;
export declare class DataAzurermContainerAppIngressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppIngress | undefined;
    set internalValue(value: DataAzurermContainerAppIngress | undefined);
    get allowInsecureConnections(): cdktf.IResolvable;
    get clientCertificateMode(): string;
    private _customDomain;
    get customDomain(): DataAzurermContainerAppIngressCustomDomainList;
    get exposedPort(): number;
    get externalEnabled(): cdktf.IResolvable;
    get fqdn(): string;
    private _ipSecurityRestriction;
    get ipSecurityRestriction(): DataAzurermContainerAppIngressIpSecurityRestrictionList;
    get targetPort(): number;
    private _trafficWeight;
    get trafficWeight(): DataAzurermContainerAppIngressTrafficWeightList;
    get transport(): string;
}
export declare class DataAzurermContainerAppIngressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppIngressOutputReference;
}
export interface DataAzurermContainerAppRegistry {
}
export declare function dataAzurermContainerAppRegistryToTerraform(struct?: DataAzurermContainerAppRegistry): any;
export declare function dataAzurermContainerAppRegistryToHclTerraform(struct?: DataAzurermContainerAppRegistry): any;
export declare class DataAzurermContainerAppRegistryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppRegistry | undefined;
    set internalValue(value: DataAzurermContainerAppRegistry | undefined);
    get identity(): string;
    get passwordSecretName(): string;
    get server(): string;
    get username(): string;
}
export declare class DataAzurermContainerAppRegistryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppRegistryOutputReference;
}
export interface DataAzurermContainerAppSecret {
}
export declare function dataAzurermContainerAppSecretToTerraform(struct?: DataAzurermContainerAppSecret): any;
export declare function dataAzurermContainerAppSecretToHclTerraform(struct?: DataAzurermContainerAppSecret): any;
export declare class DataAzurermContainerAppSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppSecret | undefined;
    set internalValue(value: DataAzurermContainerAppSecret | undefined);
    get identity(): string;
    get keyVaultSecretId(): string;
    get name(): string;
    get value(): string;
}
export declare class DataAzurermContainerAppSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppSecretOutputReference;
}
export interface DataAzurermContainerAppTemplateAzureQueueScaleRuleAuthentication {
}
export declare function dataAzurermContainerAppTemplateAzureQueueScaleRuleAuthenticationToTerraform(struct?: DataAzurermContainerAppTemplateAzureQueueScaleRuleAuthentication): any;
export declare function dataAzurermContainerAppTemplateAzureQueueScaleRuleAuthenticationToHclTerraform(struct?: DataAzurermContainerAppTemplateAzureQueueScaleRuleAuthentication): any;
export declare class DataAzurermContainerAppTemplateAzureQueueScaleRuleAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateAzureQueueScaleRuleAuthentication | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateAzureQueueScaleRuleAuthentication | undefined);
    get secretName(): string;
    get triggerParameter(): string;
}
export declare class DataAzurermContainerAppTemplateAzureQueueScaleRuleAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateAzureQueueScaleRuleAuthenticationOutputReference;
}
export interface DataAzurermContainerAppTemplateAzureQueueScaleRule {
}
export declare function dataAzurermContainerAppTemplateAzureQueueScaleRuleToTerraform(struct?: DataAzurermContainerAppTemplateAzureQueueScaleRule): any;
export declare function dataAzurermContainerAppTemplateAzureQueueScaleRuleToHclTerraform(struct?: DataAzurermContainerAppTemplateAzureQueueScaleRule): any;
export declare class DataAzurermContainerAppTemplateAzureQueueScaleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateAzureQueueScaleRule | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateAzureQueueScaleRule | undefined);
    private _authentication;
    get authentication(): DataAzurermContainerAppTemplateAzureQueueScaleRuleAuthenticationList;
    get name(): string;
    get queueLength(): number;
    get queueName(): string;
}
export declare class DataAzurermContainerAppTemplateAzureQueueScaleRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateAzureQueueScaleRuleOutputReference;
}
export interface DataAzurermContainerAppTemplateContainerEnv {
}
export declare function dataAzurermContainerAppTemplateContainerEnvToTerraform(struct?: DataAzurermContainerAppTemplateContainerEnv): any;
export declare function dataAzurermContainerAppTemplateContainerEnvToHclTerraform(struct?: DataAzurermContainerAppTemplateContainerEnv): any;
export declare class DataAzurermContainerAppTemplateContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateContainerEnv | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateContainerEnv | undefined);
    get name(): string;
    get secretName(): string;
    get value(): string;
}
export declare class DataAzurermContainerAppTemplateContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateContainerEnvOutputReference;
}
export interface DataAzurermContainerAppTemplateContainerLivenessProbeHeader {
}
export declare function dataAzurermContainerAppTemplateContainerLivenessProbeHeaderToTerraform(struct?: DataAzurermContainerAppTemplateContainerLivenessProbeHeader): any;
export declare function dataAzurermContainerAppTemplateContainerLivenessProbeHeaderToHclTerraform(struct?: DataAzurermContainerAppTemplateContainerLivenessProbeHeader): any;
export declare class DataAzurermContainerAppTemplateContainerLivenessProbeHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateContainerLivenessProbeHeader | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateContainerLivenessProbeHeader | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataAzurermContainerAppTemplateContainerLivenessProbeHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateContainerLivenessProbeHeaderOutputReference;
}
export interface DataAzurermContainerAppTemplateContainerLivenessProbe {
}
export declare function dataAzurermContainerAppTemplateContainerLivenessProbeToTerraform(struct?: DataAzurermContainerAppTemplateContainerLivenessProbe): any;
export declare function dataAzurermContainerAppTemplateContainerLivenessProbeToHclTerraform(struct?: DataAzurermContainerAppTemplateContainerLivenessProbe): any;
export declare class DataAzurermContainerAppTemplateContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateContainerLivenessProbe | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateContainerLivenessProbe | undefined);
    get failureCountThreshold(): number;
    private _header;
    get header(): DataAzurermContainerAppTemplateContainerLivenessProbeHeaderList;
    get host(): string;
    get initialDelay(): number;
    get intervalSeconds(): number;
    get path(): string;
    get port(): number;
    get terminationGracePeriodSeconds(): number;
    get timeout(): number;
    get transport(): string;
}
export declare class DataAzurermContainerAppTemplateContainerLivenessProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateContainerLivenessProbeOutputReference;
}
export interface DataAzurermContainerAppTemplateContainerReadinessProbeHeader {
}
export declare function dataAzurermContainerAppTemplateContainerReadinessProbeHeaderToTerraform(struct?: DataAzurermContainerAppTemplateContainerReadinessProbeHeader): any;
export declare function dataAzurermContainerAppTemplateContainerReadinessProbeHeaderToHclTerraform(struct?: DataAzurermContainerAppTemplateContainerReadinessProbeHeader): any;
export declare class DataAzurermContainerAppTemplateContainerReadinessProbeHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateContainerReadinessProbeHeader | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateContainerReadinessProbeHeader | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataAzurermContainerAppTemplateContainerReadinessProbeHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateContainerReadinessProbeHeaderOutputReference;
}
export interface DataAzurermContainerAppTemplateContainerReadinessProbe {
}
export declare function dataAzurermContainerAppTemplateContainerReadinessProbeToTerraform(struct?: DataAzurermContainerAppTemplateContainerReadinessProbe): any;
export declare function dataAzurermContainerAppTemplateContainerReadinessProbeToHclTerraform(struct?: DataAzurermContainerAppTemplateContainerReadinessProbe): any;
export declare class DataAzurermContainerAppTemplateContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateContainerReadinessProbe | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateContainerReadinessProbe | undefined);
    get failureCountThreshold(): number;
    private _header;
    get header(): DataAzurermContainerAppTemplateContainerReadinessProbeHeaderList;
    get host(): string;
    get initialDelay(): number;
    get intervalSeconds(): number;
    get path(): string;
    get port(): number;
    get successCountThreshold(): number;
    get timeout(): number;
    get transport(): string;
}
export declare class DataAzurermContainerAppTemplateContainerReadinessProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateContainerReadinessProbeOutputReference;
}
export interface DataAzurermContainerAppTemplateContainerStartupProbeHeader {
}
export declare function dataAzurermContainerAppTemplateContainerStartupProbeHeaderToTerraform(struct?: DataAzurermContainerAppTemplateContainerStartupProbeHeader): any;
export declare function dataAzurermContainerAppTemplateContainerStartupProbeHeaderToHclTerraform(struct?: DataAzurermContainerAppTemplateContainerStartupProbeHeader): any;
export declare class DataAzurermContainerAppTemplateContainerStartupProbeHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateContainerStartupProbeHeader | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateContainerStartupProbeHeader | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataAzurermContainerAppTemplateContainerStartupProbeHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateContainerStartupProbeHeaderOutputReference;
}
export interface DataAzurermContainerAppTemplateContainerStartupProbe {
}
export declare function dataAzurermContainerAppTemplateContainerStartupProbeToTerraform(struct?: DataAzurermContainerAppTemplateContainerStartupProbe): any;
export declare function dataAzurermContainerAppTemplateContainerStartupProbeToHclTerraform(struct?: DataAzurermContainerAppTemplateContainerStartupProbe): any;
export declare class DataAzurermContainerAppTemplateContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateContainerStartupProbe | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateContainerStartupProbe | undefined);
    get failureCountThreshold(): number;
    private _header;
    get header(): DataAzurermContainerAppTemplateContainerStartupProbeHeaderList;
    get host(): string;
    get initialDelay(): number;
    get intervalSeconds(): number;
    get path(): string;
    get port(): number;
    get terminationGracePeriodSeconds(): number;
    get timeout(): number;
    get transport(): string;
}
export declare class DataAzurermContainerAppTemplateContainerStartupProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateContainerStartupProbeOutputReference;
}
export interface DataAzurermContainerAppTemplateContainerVolumeMounts {
}
export declare function dataAzurermContainerAppTemplateContainerVolumeMountsToTerraform(struct?: DataAzurermContainerAppTemplateContainerVolumeMounts): any;
export declare function dataAzurermContainerAppTemplateContainerVolumeMountsToHclTerraform(struct?: DataAzurermContainerAppTemplateContainerVolumeMounts): any;
export declare class DataAzurermContainerAppTemplateContainerVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateContainerVolumeMounts | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateContainerVolumeMounts | undefined);
    get name(): string;
    get path(): string;
    get subPath(): string;
}
export declare class DataAzurermContainerAppTemplateContainerVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateContainerVolumeMountsOutputReference;
}
export interface DataAzurermContainerAppTemplateContainer {
}
export declare function dataAzurermContainerAppTemplateContainerToTerraform(struct?: DataAzurermContainerAppTemplateContainer): any;
export declare function dataAzurermContainerAppTemplateContainerToHclTerraform(struct?: DataAzurermContainerAppTemplateContainer): any;
export declare class DataAzurermContainerAppTemplateContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateContainer | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateContainer | undefined);
    get args(): string[];
    get command(): string[];
    get cpu(): number;
    private _env;
    get env(): DataAzurermContainerAppTemplateContainerEnvList;
    get ephemeralStorage(): string;
    get image(): string;
    private _livenessProbe;
    get livenessProbe(): DataAzurermContainerAppTemplateContainerLivenessProbeList;
    get memory(): string;
    get name(): string;
    private _readinessProbe;
    get readinessProbe(): DataAzurermContainerAppTemplateContainerReadinessProbeList;
    private _startupProbe;
    get startupProbe(): DataAzurermContainerAppTemplateContainerStartupProbeList;
    private _volumeMounts;
    get volumeMounts(): DataAzurermContainerAppTemplateContainerVolumeMountsList;
}
export declare class DataAzurermContainerAppTemplateContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateContainerOutputReference;
}
export interface DataAzurermContainerAppTemplateCustomScaleRuleAuthentication {
}
export declare function dataAzurermContainerAppTemplateCustomScaleRuleAuthenticationToTerraform(struct?: DataAzurermContainerAppTemplateCustomScaleRuleAuthentication): any;
export declare function dataAzurermContainerAppTemplateCustomScaleRuleAuthenticationToHclTerraform(struct?: DataAzurermContainerAppTemplateCustomScaleRuleAuthentication): any;
export declare class DataAzurermContainerAppTemplateCustomScaleRuleAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateCustomScaleRuleAuthentication | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateCustomScaleRuleAuthentication | undefined);
    get secretName(): string;
    get triggerParameter(): string;
}
export declare class DataAzurermContainerAppTemplateCustomScaleRuleAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateCustomScaleRuleAuthenticationOutputReference;
}
export interface DataAzurermContainerAppTemplateCustomScaleRule {
}
export declare function dataAzurermContainerAppTemplateCustomScaleRuleToTerraform(struct?: DataAzurermContainerAppTemplateCustomScaleRule): any;
export declare function dataAzurermContainerAppTemplateCustomScaleRuleToHclTerraform(struct?: DataAzurermContainerAppTemplateCustomScaleRule): any;
export declare class DataAzurermContainerAppTemplateCustomScaleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateCustomScaleRule | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateCustomScaleRule | undefined);
    private _authentication;
    get authentication(): DataAzurermContainerAppTemplateCustomScaleRuleAuthenticationList;
    get customRuleType(): string;
    private _metadata;
    get metadata(): cdktf.StringMap;
    get name(): string;
}
export declare class DataAzurermContainerAppTemplateCustomScaleRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateCustomScaleRuleOutputReference;
}
export interface DataAzurermContainerAppTemplateHttpScaleRuleAuthentication {
}
export declare function dataAzurermContainerAppTemplateHttpScaleRuleAuthenticationToTerraform(struct?: DataAzurermContainerAppTemplateHttpScaleRuleAuthentication): any;
export declare function dataAzurermContainerAppTemplateHttpScaleRuleAuthenticationToHclTerraform(struct?: DataAzurermContainerAppTemplateHttpScaleRuleAuthentication): any;
export declare class DataAzurermContainerAppTemplateHttpScaleRuleAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateHttpScaleRuleAuthentication | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateHttpScaleRuleAuthentication | undefined);
    get secretName(): string;
    get triggerParameter(): string;
}
export declare class DataAzurermContainerAppTemplateHttpScaleRuleAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateHttpScaleRuleAuthenticationOutputReference;
}
export interface DataAzurermContainerAppTemplateHttpScaleRule {
}
export declare function dataAzurermContainerAppTemplateHttpScaleRuleToTerraform(struct?: DataAzurermContainerAppTemplateHttpScaleRule): any;
export declare function dataAzurermContainerAppTemplateHttpScaleRuleToHclTerraform(struct?: DataAzurermContainerAppTemplateHttpScaleRule): any;
export declare class DataAzurermContainerAppTemplateHttpScaleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateHttpScaleRule | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateHttpScaleRule | undefined);
    private _authentication;
    get authentication(): DataAzurermContainerAppTemplateHttpScaleRuleAuthenticationList;
    get concurrentRequests(): string;
    get name(): string;
}
export declare class DataAzurermContainerAppTemplateHttpScaleRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateHttpScaleRuleOutputReference;
}
export interface DataAzurermContainerAppTemplateInitContainerEnv {
}
export declare function dataAzurermContainerAppTemplateInitContainerEnvToTerraform(struct?: DataAzurermContainerAppTemplateInitContainerEnv): any;
export declare function dataAzurermContainerAppTemplateInitContainerEnvToHclTerraform(struct?: DataAzurermContainerAppTemplateInitContainerEnv): any;
export declare class DataAzurermContainerAppTemplateInitContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateInitContainerEnv | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateInitContainerEnv | undefined);
    get name(): string;
    get secretName(): string;
    get value(): string;
}
export declare class DataAzurermContainerAppTemplateInitContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateInitContainerEnvOutputReference;
}
export interface DataAzurermContainerAppTemplateInitContainerVolumeMounts {
}
export declare function dataAzurermContainerAppTemplateInitContainerVolumeMountsToTerraform(struct?: DataAzurermContainerAppTemplateInitContainerVolumeMounts): any;
export declare function dataAzurermContainerAppTemplateInitContainerVolumeMountsToHclTerraform(struct?: DataAzurermContainerAppTemplateInitContainerVolumeMounts): any;
export declare class DataAzurermContainerAppTemplateInitContainerVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateInitContainerVolumeMounts | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateInitContainerVolumeMounts | undefined);
    get name(): string;
    get path(): string;
    get subPath(): string;
}
export declare class DataAzurermContainerAppTemplateInitContainerVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateInitContainerVolumeMountsOutputReference;
}
export interface DataAzurermContainerAppTemplateInitContainer {
}
export declare function dataAzurermContainerAppTemplateInitContainerToTerraform(struct?: DataAzurermContainerAppTemplateInitContainer): any;
export declare function dataAzurermContainerAppTemplateInitContainerToHclTerraform(struct?: DataAzurermContainerAppTemplateInitContainer): any;
export declare class DataAzurermContainerAppTemplateInitContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateInitContainer | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateInitContainer | undefined);
    get args(): string[];
    get command(): string[];
    get cpu(): number;
    private _env;
    get env(): DataAzurermContainerAppTemplateInitContainerEnvList;
    get ephemeralStorage(): string;
    get image(): string;
    get memory(): string;
    get name(): string;
    private _volumeMounts;
    get volumeMounts(): DataAzurermContainerAppTemplateInitContainerVolumeMountsList;
}
export declare class DataAzurermContainerAppTemplateInitContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateInitContainerOutputReference;
}
export interface DataAzurermContainerAppTemplateTcpScaleRuleAuthentication {
}
export declare function dataAzurermContainerAppTemplateTcpScaleRuleAuthenticationToTerraform(struct?: DataAzurermContainerAppTemplateTcpScaleRuleAuthentication): any;
export declare function dataAzurermContainerAppTemplateTcpScaleRuleAuthenticationToHclTerraform(struct?: DataAzurermContainerAppTemplateTcpScaleRuleAuthentication): any;
export declare class DataAzurermContainerAppTemplateTcpScaleRuleAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateTcpScaleRuleAuthentication | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateTcpScaleRuleAuthentication | undefined);
    get secretName(): string;
    get triggerParameter(): string;
}
export declare class DataAzurermContainerAppTemplateTcpScaleRuleAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateTcpScaleRuleAuthenticationOutputReference;
}
export interface DataAzurermContainerAppTemplateTcpScaleRule {
}
export declare function dataAzurermContainerAppTemplateTcpScaleRuleToTerraform(struct?: DataAzurermContainerAppTemplateTcpScaleRule): any;
export declare function dataAzurermContainerAppTemplateTcpScaleRuleToHclTerraform(struct?: DataAzurermContainerAppTemplateTcpScaleRule): any;
export declare class DataAzurermContainerAppTemplateTcpScaleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateTcpScaleRule | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateTcpScaleRule | undefined);
    private _authentication;
    get authentication(): DataAzurermContainerAppTemplateTcpScaleRuleAuthenticationList;
    get concurrentRequests(): string;
    get name(): string;
}
export declare class DataAzurermContainerAppTemplateTcpScaleRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateTcpScaleRuleOutputReference;
}
export interface DataAzurermContainerAppTemplateVolume {
}
export declare function dataAzurermContainerAppTemplateVolumeToTerraform(struct?: DataAzurermContainerAppTemplateVolume): any;
export declare function dataAzurermContainerAppTemplateVolumeToHclTerraform(struct?: DataAzurermContainerAppTemplateVolume): any;
export declare class DataAzurermContainerAppTemplateVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplateVolume | undefined;
    set internalValue(value: DataAzurermContainerAppTemplateVolume | undefined);
    get mountOptions(): string;
    get name(): string;
    get storageName(): string;
    get storageType(): string;
}
export declare class DataAzurermContainerAppTemplateVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateVolumeOutputReference;
}
export interface DataAzurermContainerAppTemplate {
}
export declare function dataAzurermContainerAppTemplateToTerraform(struct?: DataAzurermContainerAppTemplate): any;
export declare function dataAzurermContainerAppTemplateToHclTerraform(struct?: DataAzurermContainerAppTemplate): any;
export declare class DataAzurermContainerAppTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermContainerAppTemplate | undefined;
    set internalValue(value: DataAzurermContainerAppTemplate | undefined);
    private _azureQueueScaleRule;
    get azureQueueScaleRule(): DataAzurermContainerAppTemplateAzureQueueScaleRuleList;
    private _container;
    get container(): DataAzurermContainerAppTemplateContainerList;
    private _customScaleRule;
    get customScaleRule(): DataAzurermContainerAppTemplateCustomScaleRuleList;
    private _httpScaleRule;
    get httpScaleRule(): DataAzurermContainerAppTemplateHttpScaleRuleList;
    private _initContainer;
    get initContainer(): DataAzurermContainerAppTemplateInitContainerList;
    get maxReplicas(): number;
    get minReplicas(): number;
    get revisionSuffix(): string;
    private _tcpScaleRule;
    get tcpScaleRule(): DataAzurermContainerAppTemplateTcpScaleRuleList;
    get terminationGracePeriodSeconds(): number;
    private _volume;
    get volume(): DataAzurermContainerAppTemplateVolumeList;
}
export declare class DataAzurermContainerAppTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermContainerAppTemplateOutputReference;
}
export interface DataAzurermContainerAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/container_app#read DataAzurermContainerApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerAppTimeoutsToTerraform(struct?: DataAzurermContainerAppTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermContainerAppTimeoutsToHclTerraform(struct?: DataAzurermContainerAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermContainerAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermContainerAppTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/container_app azurerm_container_app}
*/
export declare class DataAzurermContainerApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_container_app";
    /**
    * Generates CDKTF code for importing a DataAzurermContainerApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermContainerApp to import
    * @param importFromId The id of the existing DataAzurermContainerApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/container_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermContainerApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/container_app azurerm_container_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerAppConfig);
    get containerAppEnvironmentId(): string;
    get customDomainVerificationId(): string;
    private _dapr;
    get dapr(): DataAzurermContainerAppDaprList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermContainerAppIdentityList;
    private _ingress;
    get ingress(): DataAzurermContainerAppIngressList;
    get latestRevisionFqdn(): string;
    get latestRevisionName(): string;
    get location(): string;
    get maxInactiveRevisions(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddresses(): string[];
    private _registry;
    get registry(): DataAzurermContainerAppRegistryList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get revisionMode(): string;
    private _secret;
    get secret(): DataAzurermContainerAppSecretList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _template;
    get template(): DataAzurermContainerAppTemplateList;
    get workloadProfileName(): string;
    private _timeouts;
    get timeouts(): DataAzurermContainerAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermContainerAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
