/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermEventhubSasConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/eventhub_sas#connection_string DataAzurermEventhubSas#connection_string}
    */
    readonly connectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/eventhub_sas#expiry DataAzurermEventhubSas#expiry}
    */
    readonly expiry: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/eventhub_sas#id DataAzurermEventhubSas#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/eventhub_sas#timeouts DataAzurermEventhubSas#timeouts}
    */
    readonly timeouts?: DataAzurermEventhubSasTimeouts;
}
export interface DataAzurermEventhubSasTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/eventhub_sas#read DataAzurermEventhubSas#read}
    */
    readonly read?: string;
}
export declare function dataAzurermEventhubSasTimeoutsToTerraform(struct?: DataAzurermEventhubSasTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermEventhubSasTimeoutsToHclTerraform(struct?: DataAzurermEventhubSasTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermEventhubSasTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermEventhubSasTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermEventhubSasTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/eventhub_sas azurerm_eventhub_sas}
*/
export declare class DataAzurermEventhubSas extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_eventhub_sas";
    /**
    * Generates CDKTF code for importing a DataAzurermEventhubSas resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermEventhubSas to import
    * @param importFromId The id of the existing DataAzurermEventhubSas that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/eventhub_sas#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermEventhubSas to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/eventhub_sas azurerm_eventhub_sas} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermEventhubSasConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermEventhubSasConfig);
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    get connectionStringInput(): string | undefined;
    private _expiry?;
    get expiry(): string;
    set expiry(value: string);
    get expiryInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get sas(): string;
    private _timeouts;
    get timeouts(): DataAzurermEventhubSasTimeoutsOutputReference;
    putTimeouts(value: DataAzurermEventhubSasTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermEventhubSasTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
