/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultCertificateIssuerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_certificate_issuer#id DataAzurermKeyVaultCertificateIssuer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_certificate_issuer#key_vault_id DataAzurermKeyVaultCertificateIssuer#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_certificate_issuer#name DataAzurermKeyVaultCertificateIssuer#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_certificate_issuer#timeouts DataAzurermKeyVaultCertificateIssuer#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultCertificateIssuerTimeouts;
}
export interface DataAzurermKeyVaultCertificateIssuerAdmin {
}
export declare function dataAzurermKeyVaultCertificateIssuerAdminToTerraform(struct?: DataAzurermKeyVaultCertificateIssuerAdmin): any;
export declare function dataAzurermKeyVaultCertificateIssuerAdminToHclTerraform(struct?: DataAzurermKeyVaultCertificateIssuerAdmin): any;
export declare class DataAzurermKeyVaultCertificateIssuerAdminOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateIssuerAdmin | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateIssuerAdmin | undefined);
    get emailAddress(): string;
    get firstName(): string;
    get lastName(): string;
    get phone(): string;
}
export declare class DataAzurermKeyVaultCertificateIssuerAdminList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateIssuerAdminOutputReference;
}
export interface DataAzurermKeyVaultCertificateIssuerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_certificate_issuer#read DataAzurermKeyVaultCertificateIssuer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultCertificateIssuerTimeoutsToTerraform(struct?: DataAzurermKeyVaultCertificateIssuerTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermKeyVaultCertificateIssuerTimeoutsToHclTerraform(struct?: DataAzurermKeyVaultCertificateIssuerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultCertificateIssuerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultCertificateIssuerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateIssuerTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_certificate_issuer azurerm_key_vault_certificate_issuer}
*/
export declare class DataAzurermKeyVaultCertificateIssuer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault_certificate_issuer";
    /**
    * Generates CDKTF code for importing a DataAzurermKeyVaultCertificateIssuer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermKeyVaultCertificateIssuer to import
    * @param importFromId The id of the existing DataAzurermKeyVaultCertificateIssuer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_certificate_issuer#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermKeyVaultCertificateIssuer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_certificate_issuer azurerm_key_vault_certificate_issuer} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultCertificateIssuerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultCertificateIssuerConfig);
    get accountId(): string;
    private _admin;
    get admin(): DataAzurermKeyVaultCertificateIssuerAdminList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get orgId(): string;
    get providerName(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultCertificateIssuerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultCertificateIssuerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKeyVaultCertificateIssuerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
