/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultManagedHardwareSecurityModuleKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_managed_hardware_security_module_key#id DataAzurermKeyVaultManagedHardwareSecurityModuleKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_managed_hardware_security_module_key#managed_hsm_id DataAzurermKeyVaultManagedHardwareSecurityModuleKey#managed_hsm_id}
    */
    readonly managedHsmId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_managed_hardware_security_module_key#name DataAzurermKeyVaultManagedHardwareSecurityModuleKey#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_managed_hardware_security_module_key#timeouts DataAzurermKeyVaultManagedHardwareSecurityModuleKey#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeouts;
}
export interface DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_managed_hardware_security_module_key#read DataAzurermKeyVaultManagedHardwareSecurityModuleKey#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeoutsToTerraform(struct?: DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeoutsToHclTerraform(struct?: DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_managed_hardware_security_module_key azurerm_key_vault_managed_hardware_security_module_key}
*/
export declare class DataAzurermKeyVaultManagedHardwareSecurityModuleKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault_managed_hardware_security_module_key";
    /**
    * Generates CDKTF code for importing a DataAzurermKeyVaultManagedHardwareSecurityModuleKey resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermKeyVaultManagedHardwareSecurityModuleKey to import
    * @param importFromId The id of the existing DataAzurermKeyVaultManagedHardwareSecurityModuleKey that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_managed_hardware_security_module_key#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermKeyVaultManagedHardwareSecurityModuleKey to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/key_vault_managed_hardware_security_module_key azurerm_key_vault_managed_hardware_security_module_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultManagedHardwareSecurityModuleKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultManagedHardwareSecurityModuleKeyConfig);
    get curve(): string;
    get expirationDate(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyOpts(): string[];
    get keySize(): number;
    get keyType(): string;
    private _managedHsmId?;
    get managedHsmId(): string;
    set managedHsmId(value: string);
    get managedHsmIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notBeforeDate(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get version(): string;
    get versionedId(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKeyVaultManagedHardwareSecurityModuleKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
