/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetappSnapshotPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/netapp_snapshot_policy#account_name DataAzurermNetappSnapshotPolicy#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/netapp_snapshot_policy#id DataAzurermNetappSnapshotPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/netapp_snapshot_policy#name DataAzurermNetappSnapshotPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/netapp_snapshot_policy#resource_group_name DataAzurermNetappSnapshotPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/netapp_snapshot_policy#timeouts DataAzurermNetappSnapshotPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermNetappSnapshotPolicyTimeouts;
}
export interface DataAzurermNetappSnapshotPolicyDailySchedule {
}
export declare function dataAzurermNetappSnapshotPolicyDailyScheduleToTerraform(struct?: DataAzurermNetappSnapshotPolicyDailySchedule): any;
export declare function dataAzurermNetappSnapshotPolicyDailyScheduleToHclTerraform(struct?: DataAzurermNetappSnapshotPolicyDailySchedule): any;
export declare class DataAzurermNetappSnapshotPolicyDailyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappSnapshotPolicyDailySchedule | undefined;
    set internalValue(value: DataAzurermNetappSnapshotPolicyDailySchedule | undefined);
    get hour(): number;
    get minute(): number;
    get snapshotsToKeep(): number;
}
export declare class DataAzurermNetappSnapshotPolicyDailyScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappSnapshotPolicyDailyScheduleOutputReference;
}
export interface DataAzurermNetappSnapshotPolicyHourlySchedule {
}
export declare function dataAzurermNetappSnapshotPolicyHourlyScheduleToTerraform(struct?: DataAzurermNetappSnapshotPolicyHourlySchedule): any;
export declare function dataAzurermNetappSnapshotPolicyHourlyScheduleToHclTerraform(struct?: DataAzurermNetappSnapshotPolicyHourlySchedule): any;
export declare class DataAzurermNetappSnapshotPolicyHourlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappSnapshotPolicyHourlySchedule | undefined;
    set internalValue(value: DataAzurermNetappSnapshotPolicyHourlySchedule | undefined);
    get minute(): number;
    get snapshotsToKeep(): number;
}
export declare class DataAzurermNetappSnapshotPolicyHourlyScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappSnapshotPolicyHourlyScheduleOutputReference;
}
export interface DataAzurermNetappSnapshotPolicyMonthlySchedule {
}
export declare function dataAzurermNetappSnapshotPolicyMonthlyScheduleToTerraform(struct?: DataAzurermNetappSnapshotPolicyMonthlySchedule): any;
export declare function dataAzurermNetappSnapshotPolicyMonthlyScheduleToHclTerraform(struct?: DataAzurermNetappSnapshotPolicyMonthlySchedule): any;
export declare class DataAzurermNetappSnapshotPolicyMonthlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappSnapshotPolicyMonthlySchedule | undefined;
    set internalValue(value: DataAzurermNetappSnapshotPolicyMonthlySchedule | undefined);
    get daysOfMonth(): number[];
    get hour(): number;
    get minute(): number;
    get snapshotsToKeep(): number;
}
export declare class DataAzurermNetappSnapshotPolicyMonthlyScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappSnapshotPolicyMonthlyScheduleOutputReference;
}
export interface DataAzurermNetappSnapshotPolicyWeeklySchedule {
}
export declare function dataAzurermNetappSnapshotPolicyWeeklyScheduleToTerraform(struct?: DataAzurermNetappSnapshotPolicyWeeklySchedule): any;
export declare function dataAzurermNetappSnapshotPolicyWeeklyScheduleToHclTerraform(struct?: DataAzurermNetappSnapshotPolicyWeeklySchedule): any;
export declare class DataAzurermNetappSnapshotPolicyWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappSnapshotPolicyWeeklySchedule | undefined;
    set internalValue(value: DataAzurermNetappSnapshotPolicyWeeklySchedule | undefined);
    get daysOfWeek(): string[];
    get hour(): number;
    get minute(): number;
    get snapshotsToKeep(): number;
}
export declare class DataAzurermNetappSnapshotPolicyWeeklyScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappSnapshotPolicyWeeklyScheduleOutputReference;
}
export interface DataAzurermNetappSnapshotPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/netapp_snapshot_policy#read DataAzurermNetappSnapshotPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetappSnapshotPolicyTimeoutsToTerraform(struct?: DataAzurermNetappSnapshotPolicyTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetappSnapshotPolicyTimeoutsToHclTerraform(struct?: DataAzurermNetappSnapshotPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetappSnapshotPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetappSnapshotPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetappSnapshotPolicyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/netapp_snapshot_policy azurerm_netapp_snapshot_policy}
*/
export declare class DataAzurermNetappSnapshotPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_netapp_snapshot_policy";
    /**
    * Generates CDKTF code for importing a DataAzurermNetappSnapshotPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetappSnapshotPolicy to import
    * @param importFromId The id of the existing DataAzurermNetappSnapshotPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/netapp_snapshot_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetappSnapshotPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/netapp_snapshot_policy azurerm_netapp_snapshot_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetappSnapshotPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetappSnapshotPolicyConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _dailySchedule;
    get dailySchedule(): DataAzurermNetappSnapshotPolicyDailyScheduleList;
    get enabled(): cdktf.IResolvable;
    private _hourlySchedule;
    get hourlySchedule(): DataAzurermNetappSnapshotPolicyHourlyScheduleList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _monthlySchedule;
    get monthlySchedule(): DataAzurermNetappSnapshotPolicyMonthlyScheduleList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _weeklySchedule;
    get weeklySchedule(): DataAzurermNetappSnapshotPolicyWeeklyScheduleList;
    private _timeouts;
    get timeouts(): DataAzurermNetappSnapshotPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetappSnapshotPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetappSnapshotPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
