/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleAdbsNationalCharacterSetsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_adbs_national_character_sets#id DataAzurermOracleAdbsNationalCharacterSets#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_adbs_national_character_sets#location DataAzurermOracleAdbsNationalCharacterSets#location}
    */
    readonly location: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_adbs_national_character_sets#timeouts DataAzurermOracleAdbsNationalCharacterSets#timeouts}
    */
    readonly timeouts?: DataAzurermOracleAdbsNationalCharacterSetsTimeouts;
}
export interface DataAzurermOracleAdbsNationalCharacterSetsCharacterSets {
}
export declare function dataAzurermOracleAdbsNationalCharacterSetsCharacterSetsToTerraform(struct?: DataAzurermOracleAdbsNationalCharacterSetsCharacterSets): any;
export declare function dataAzurermOracleAdbsNationalCharacterSetsCharacterSetsToHclTerraform(struct?: DataAzurermOracleAdbsNationalCharacterSetsCharacterSets): any;
export declare class DataAzurermOracleAdbsNationalCharacterSetsCharacterSetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleAdbsNationalCharacterSetsCharacterSets | undefined;
    set internalValue(value: DataAzurermOracleAdbsNationalCharacterSetsCharacterSets | undefined);
    get characterSet(): string;
}
export declare class DataAzurermOracleAdbsNationalCharacterSetsCharacterSetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleAdbsNationalCharacterSetsCharacterSetsOutputReference;
}
export interface DataAzurermOracleAdbsNationalCharacterSetsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_adbs_national_character_sets#read DataAzurermOracleAdbsNationalCharacterSets#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleAdbsNationalCharacterSetsTimeoutsToTerraform(struct?: DataAzurermOracleAdbsNationalCharacterSetsTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleAdbsNationalCharacterSetsTimeoutsToHclTerraform(struct?: DataAzurermOracleAdbsNationalCharacterSetsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleAdbsNationalCharacterSetsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleAdbsNationalCharacterSetsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleAdbsNationalCharacterSetsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_adbs_national_character_sets azurerm_oracle_adbs_national_character_sets}
*/
export declare class DataAzurermOracleAdbsNationalCharacterSets extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_adbs_national_character_sets";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleAdbsNationalCharacterSets resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleAdbsNationalCharacterSets to import
    * @param importFromId The id of the existing DataAzurermOracleAdbsNationalCharacterSets that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_adbs_national_character_sets#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleAdbsNationalCharacterSets to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_adbs_national_character_sets azurerm_oracle_adbs_national_character_sets} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleAdbsNationalCharacterSetsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleAdbsNationalCharacterSetsConfig);
    private _characterSets;
    get characterSets(): DataAzurermOracleAdbsNationalCharacterSetsCharacterSetsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermOracleAdbsNationalCharacterSetsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleAdbsNationalCharacterSetsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleAdbsNationalCharacterSetsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
