/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleDbNodesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_nodes#cloud_vm_cluster_id DataAzurermOracleDbNodes#cloud_vm_cluster_id}
    */
    readonly cloudVmClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_nodes#id DataAzurermOracleDbNodes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_nodes#timeouts DataAzurermOracleDbNodes#timeouts}
    */
    readonly timeouts?: DataAzurermOracleDbNodesTimeouts;
}
export interface DataAzurermOracleDbNodesDbNodes {
}
export declare function dataAzurermOracleDbNodesDbNodesToTerraform(struct?: DataAzurermOracleDbNodesDbNodes): any;
export declare function dataAzurermOracleDbNodesDbNodesToHclTerraform(struct?: DataAzurermOracleDbNodesDbNodes): any;
export declare class DataAzurermOracleDbNodesDbNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleDbNodesDbNodes | undefined;
    set internalValue(value: DataAzurermOracleDbNodesDbNodes | undefined);
    get additionalDetails(): string;
    get backupIpId(): string;
    get backupVnic2Id(): string;
    get backupVnicId(): string;
    get cpuCoreCount(): number;
    get dbNodeStorageSizeInGbs(): number;
    get dbServerId(): string;
    get dbSystemId(): string;
    get faultDomain(): string;
    get hostIpId(): string;
    get hostname(): string;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get maintenanceType(): string;
    get memorySizeInGbs(): number;
    get ocid(): string;
    get softwareStorageSizeInGb(): number;
    get timeCreated(): string;
    get timeMaintenanceWindowEnd(): string;
    get timeMaintenanceWindowStart(): string;
    get vnic2Id(): string;
    get vnicId(): string;
}
export declare class DataAzurermOracleDbNodesDbNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleDbNodesDbNodesOutputReference;
}
export interface DataAzurermOracleDbNodesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_nodes#read DataAzurermOracleDbNodes#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleDbNodesTimeoutsToTerraform(struct?: DataAzurermOracleDbNodesTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleDbNodesTimeoutsToHclTerraform(struct?: DataAzurermOracleDbNodesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleDbNodesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleDbNodesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleDbNodesTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_nodes azurerm_oracle_db_nodes}
*/
export declare class DataAzurermOracleDbNodes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_db_nodes";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleDbNodes resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleDbNodes to import
    * @param importFromId The id of the existing DataAzurermOracleDbNodes that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_nodes#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleDbNodes to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_nodes azurerm_oracle_db_nodes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleDbNodesConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleDbNodesConfig);
    private _cloudVmClusterId?;
    get cloudVmClusterId(): string;
    set cloudVmClusterId(value: string);
    get cloudVmClusterIdInput(): string | undefined;
    private _dbNodes;
    get dbNodes(): DataAzurermOracleDbNodesDbNodesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermOracleDbNodesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleDbNodesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleDbNodesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
