/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleDbServersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_servers#cloud_exadata_infrastructure_name DataAzurermOracleDbServers#cloud_exadata_infrastructure_name}
    */
    readonly cloudExadataInfrastructureName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_servers#id DataAzurermOracleDbServers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_servers#resource_group_name DataAzurermOracleDbServers#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_servers#timeouts DataAzurermOracleDbServers#timeouts}
    */
    readonly timeouts?: DataAzurermOracleDbServersTimeouts;
}
export interface DataAzurermOracleDbServersDbServers {
}
export declare function dataAzurermOracleDbServersDbServersToTerraform(struct?: DataAzurermOracleDbServersDbServers): any;
export declare function dataAzurermOracleDbServersDbServersToHclTerraform(struct?: DataAzurermOracleDbServersDbServers): any;
export declare class DataAzurermOracleDbServersDbServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleDbServersDbServers | undefined;
    set internalValue(value: DataAzurermOracleDbServersDbServers | undefined);
    get autonomousVirtualMachineDs(): string[];
    get autonomousVmClusterIds(): string[];
    get compartmentId(): string;
    get cpuCoreCount(): number;
    get dbNodeIds(): string[];
    get dbNodeStorageSizeInGbs(): number;
    get displayName(): string;
    get exadataInfrastructureId(): string;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get maxCpuCount(): number;
    get maxDbNodeStorageInGbs(): number;
    get maxMemoryInGbs(): number;
    get memorySizeInGbs(): number;
    get ocid(): string;
    get shape(): string;
    get timeCreated(): string;
    get vmClusterIds(): string[];
}
export declare class DataAzurermOracleDbServersDbServersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleDbServersDbServersOutputReference;
}
export interface DataAzurermOracleDbServersTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_servers#read DataAzurermOracleDbServers#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleDbServersTimeoutsToTerraform(struct?: DataAzurermOracleDbServersTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleDbServersTimeoutsToHclTerraform(struct?: DataAzurermOracleDbServersTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleDbServersTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleDbServersTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleDbServersTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_servers azurerm_oracle_db_servers}
*/
export declare class DataAzurermOracleDbServers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_db_servers";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleDbServers resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleDbServers to import
    * @param importFromId The id of the existing DataAzurermOracleDbServers that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_servers#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleDbServers to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/oracle_db_servers azurerm_oracle_db_servers} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleDbServersConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleDbServersConfig);
    private _cloudExadataInfrastructureName?;
    get cloudExadataInfrastructureName(): string;
    set cloudExadataInfrastructureName(value: string);
    get cloudExadataInfrastructureNameInput(): string | undefined;
    private _dbServers;
    get dbServers(): DataAzurermOracleDbServersDbServersList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermOracleDbServersTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleDbServersTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleDbServersTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
