/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSpatialAnchorsAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/spatial_anchors_account#id DataAzurermSpatialAnchorsAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/spatial_anchors_account#name DataAzurermSpatialAnchorsAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/spatial_anchors_account#resource_group_name DataAzurermSpatialAnchorsAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/spatial_anchors_account#timeouts DataAzurermSpatialAnchorsAccount#timeouts}
    */
    readonly timeouts?: DataAzurermSpatialAnchorsAccountTimeouts;
}
export interface DataAzurermSpatialAnchorsAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/spatial_anchors_account#read DataAzurermSpatialAnchorsAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSpatialAnchorsAccountTimeoutsToTerraform(struct?: DataAzurermSpatialAnchorsAccountTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSpatialAnchorsAccountTimeoutsToHclTerraform(struct?: DataAzurermSpatialAnchorsAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSpatialAnchorsAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSpatialAnchorsAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSpatialAnchorsAccountTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/spatial_anchors_account azurerm_spatial_anchors_account}
*/
export declare class DataAzurermSpatialAnchorsAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_spatial_anchors_account";
    /**
    * Generates CDKTF code for importing a DataAzurermSpatialAnchorsAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSpatialAnchorsAccount to import
    * @param importFromId The id of the existing DataAzurermSpatialAnchorsAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/spatial_anchors_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSpatialAnchorsAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/spatial_anchors_account azurerm_spatial_anchors_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSpatialAnchorsAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSpatialAnchorsAccountConfig);
    get accountDomain(): string;
    get accountId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermSpatialAnchorsAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSpatialAnchorsAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSpatialAnchorsAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
