/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualHubRouteTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/virtual_hub_route_table#id DataAzurermVirtualHubRouteTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/virtual_hub_route_table#name DataAzurermVirtualHubRouteTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/virtual_hub_route_table#resource_group_name DataAzurermVirtualHubRouteTable#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/virtual_hub_route_table#virtual_hub_name DataAzurermVirtualHubRouteTable#virtual_hub_name}
    */
    readonly virtualHubName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/virtual_hub_route_table#timeouts DataAzurermVirtualHubRouteTable#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualHubRouteTableTimeouts;
}
export interface DataAzurermVirtualHubRouteTableRoute {
}
export declare function dataAzurermVirtualHubRouteTableRouteToTerraform(struct?: DataAzurermVirtualHubRouteTableRoute): any;
export declare function dataAzurermVirtualHubRouteTableRouteToHclTerraform(struct?: DataAzurermVirtualHubRouteTableRoute): any;
export declare class DataAzurermVirtualHubRouteTableRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualHubRouteTableRoute | undefined;
    set internalValue(value: DataAzurermVirtualHubRouteTableRoute | undefined);
    get destinations(): string[];
    get destinationsType(): string;
    get name(): string;
    get nextHop(): string;
    get nextHopType(): string;
}
export declare class DataAzurermVirtualHubRouteTableRouteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualHubRouteTableRouteOutputReference;
}
export interface DataAzurermVirtualHubRouteTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/virtual_hub_route_table#read DataAzurermVirtualHubRouteTable#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualHubRouteTableTimeoutsToTerraform(struct?: DataAzurermVirtualHubRouteTableTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermVirtualHubRouteTableTimeoutsToHclTerraform(struct?: DataAzurermVirtualHubRouteTableTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualHubRouteTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualHubRouteTableTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualHubRouteTableTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/virtual_hub_route_table azurerm_virtual_hub_route_table}
*/
export declare class DataAzurermVirtualHubRouteTable extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_hub_route_table";
    /**
    * Generates CDKTF code for importing a DataAzurermVirtualHubRouteTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermVirtualHubRouteTable to import
    * @param importFromId The id of the existing DataAzurermVirtualHubRouteTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/virtual_hub_route_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermVirtualHubRouteTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/data-sources/virtual_hub_route_table azurerm_virtual_hub_route_table} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualHubRouteTableConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualHubRouteTableConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get labels(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _route;
    get route(): DataAzurermVirtualHubRouteTableRouteList;
    get virtualHubId(): string;
    private _virtualHubName?;
    get virtualHubName(): string;
    set virtualHubName(value: string);
    get virtualHubNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermVirtualHubRouteTableTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualHubRouteTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualHubRouteTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
