/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExtendedLocationCustomLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#cluster_extension_ids ExtendedLocationCustomLocation#cluster_extension_ids}
    */
    readonly clusterExtensionIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#display_name ExtendedLocationCustomLocation#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#host_resource_id ExtendedLocationCustomLocation#host_resource_id}
    */
    readonly hostResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#host_type ExtendedLocationCustomLocation#host_type}
    */
    readonly hostType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#id ExtendedLocationCustomLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#location ExtendedLocationCustomLocation#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#name ExtendedLocationCustomLocation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#namespace ExtendedLocationCustomLocation#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#resource_group_name ExtendedLocationCustomLocation#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#authentication ExtendedLocationCustomLocation#authentication}
    */
    readonly authentication?: ExtendedLocationCustomLocationAuthentication;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#timeouts ExtendedLocationCustomLocation#timeouts}
    */
    readonly timeouts?: ExtendedLocationCustomLocationTimeouts;
}
export interface ExtendedLocationCustomLocationAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#type ExtendedLocationCustomLocation#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#value ExtendedLocationCustomLocation#value}
    */
    readonly value: string;
}
export declare function extendedLocationCustomLocationAuthenticationToTerraform(struct?: ExtendedLocationCustomLocationAuthenticationOutputReference | ExtendedLocationCustomLocationAuthentication): any;
export declare function extendedLocationCustomLocationAuthenticationToHclTerraform(struct?: ExtendedLocationCustomLocationAuthenticationOutputReference | ExtendedLocationCustomLocationAuthentication): any;
export declare class ExtendedLocationCustomLocationAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExtendedLocationCustomLocationAuthentication | undefined;
    set internalValue(value: ExtendedLocationCustomLocationAuthentication | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface ExtendedLocationCustomLocationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#create ExtendedLocationCustomLocation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#delete ExtendedLocationCustomLocation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#read ExtendedLocationCustomLocation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#update ExtendedLocationCustomLocation#update}
    */
    readonly update?: string;
}
export declare function extendedLocationCustomLocationTimeoutsToTerraform(struct?: ExtendedLocationCustomLocationTimeouts | cdktf.IResolvable): any;
export declare function extendedLocationCustomLocationTimeoutsToHclTerraform(struct?: ExtendedLocationCustomLocationTimeouts | cdktf.IResolvable): any;
export declare class ExtendedLocationCustomLocationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExtendedLocationCustomLocationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ExtendedLocationCustomLocationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location azurerm_extended_location_custom_location}
*/
export declare class ExtendedLocationCustomLocation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_extended_location_custom_location";
    /**
    * Generates CDKTF code for importing a ExtendedLocationCustomLocation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExtendedLocationCustomLocation to import
    * @param importFromId The id of the existing ExtendedLocationCustomLocation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExtendedLocationCustomLocation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/extended_location_custom_location azurerm_extended_location_custom_location} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExtendedLocationCustomLocationConfig
    */
    constructor(scope: Construct, id: string, config: ExtendedLocationCustomLocationConfig);
    private _clusterExtensionIds?;
    get clusterExtensionIds(): string[];
    set clusterExtensionIds(value: string[]);
    get clusterExtensionIdsInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _hostResourceId?;
    get hostResourceId(): string;
    set hostResourceId(value: string);
    get hostResourceIdInput(): string | undefined;
    private _hostType?;
    get hostType(): string;
    set hostType(value: string);
    resetHostType(): void;
    get hostTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _authentication;
    get authentication(): ExtendedLocationCustomLocationAuthenticationOutputReference;
    putAuthentication(value: ExtendedLocationCustomLocationAuthentication): void;
    resetAuthentication(): void;
    get authenticationInput(): ExtendedLocationCustomLocationAuthentication | undefined;
    private _timeouts;
    get timeouts(): ExtendedLocationCustomLocationTimeoutsOutputReference;
    putTimeouts(value: ExtendedLocationCustomLocationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ExtendedLocationCustomLocationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
