/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FunctionAppFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The config for this Function in JSON format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#config_json FunctionAppFunction#config_json}
    */
    readonly configJson: string;
    /**
    * Should this function be enabled. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#enabled FunctionAppFunction#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The ID of the Function App in which this function should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#function_app_id FunctionAppFunction#function_app_id}
    */
    readonly functionAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#id FunctionAppFunction#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The language the Function is written in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#language FunctionAppFunction#language}
    */
    readonly language?: string;
    /**
    * The name of the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#name FunctionAppFunction#name}
    */
    readonly name: string;
    /**
    * The test data for the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#test_data FunctionAppFunction#test_data}
    */
    readonly testData?: string;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#file FunctionAppFunction#file}
    */
    readonly file?: FunctionAppFunctionFile[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#timeouts FunctionAppFunction#timeouts}
    */
    readonly timeouts?: FunctionAppFunctionTimeouts;
}
export interface FunctionAppFunctionFile {
    /**
    * The content of the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#content FunctionAppFunction#content}
    */
    readonly content: string;
    /**
    * The filename of the file to be uploaded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#name FunctionAppFunction#name}
    */
    readonly name: string;
}
export declare function functionAppFunctionFileToTerraform(struct?: FunctionAppFunctionFile | cdktf.IResolvable): any;
export declare function functionAppFunctionFileToHclTerraform(struct?: FunctionAppFunctionFile | cdktf.IResolvable): any;
export declare class FunctionAppFunctionFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionAppFunctionFile | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppFunctionFile | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class FunctionAppFunctionFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionAppFunctionFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionAppFunctionFileOutputReference;
}
export interface FunctionAppFunctionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#create FunctionAppFunction#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#delete FunctionAppFunction#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#read FunctionAppFunction#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#update FunctionAppFunction#update}
    */
    readonly update?: string;
}
export declare function functionAppFunctionTimeoutsToTerraform(struct?: FunctionAppFunctionTimeouts | cdktf.IResolvable): any;
export declare function functionAppFunctionTimeoutsToHclTerraform(struct?: FunctionAppFunctionTimeouts | cdktf.IResolvable): any;
export declare class FunctionAppFunctionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppFunctionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppFunctionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function azurerm_function_app_function}
*/
export declare class FunctionAppFunction extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_function_app_function";
    /**
    * Generates CDKTF code for importing a FunctionAppFunction resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FunctionAppFunction to import
    * @param importFromId The id of the existing FunctionAppFunction that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FunctionAppFunction to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/function_app_function azurerm_function_app_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FunctionAppFunctionConfig
    */
    constructor(scope: Construct, id: string, config: FunctionAppFunctionConfig);
    private _configJson?;
    get configJson(): string;
    set configJson(value: string);
    get configJsonInput(): string | undefined;
    get configUrl(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _functionAppId?;
    get functionAppId(): string;
    set functionAppId(value: string);
    get functionAppIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get invocationUrl(): string;
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get scriptRootPathUrl(): string;
    get scriptUrl(): string;
    get secretsFileUrl(): string;
    private _testData?;
    get testData(): string;
    set testData(value: string);
    resetTestData(): void;
    get testDataInput(): string | undefined;
    get testDataUrl(): string;
    get url(): string;
    private _file;
    get file(): FunctionAppFunctionFileList;
    putFile(value: FunctionAppFunctionFile[] | cdktf.IResolvable): void;
    resetFile(): void;
    get fileInput(): cdktf.IResolvable | FunctionAppFunctionFile[] | undefined;
    private _timeouts;
    get timeouts(): FunctionAppFunctionTimeoutsOutputReference;
    putTimeouts(value: FunctionAppFunctionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FunctionAppFunctionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
