/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KustoScriptConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#continue_on_errors_enabled KustoScript#continue_on_errors_enabled}
    */
    readonly continueOnErrorsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#database_id KustoScript#database_id}
    */
    readonly databaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#force_an_update_when_value_changed KustoScript#force_an_update_when_value_changed}
    */
    readonly forceAnUpdateWhenValueChanged?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#id KustoScript#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#name KustoScript#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#sas_token KustoScript#sas_token}
    */
    readonly sasToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#script_content KustoScript#script_content}
    */
    readonly scriptContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#url KustoScript#url}
    */
    readonly url?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#timeouts KustoScript#timeouts}
    */
    readonly timeouts?: KustoScriptTimeouts;
}
export interface KustoScriptTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#create KustoScript#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#delete KustoScript#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#read KustoScript#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#update KustoScript#update}
    */
    readonly update?: string;
}
export declare function kustoScriptTimeoutsToTerraform(struct?: KustoScriptTimeouts | cdktf.IResolvable): any;
export declare function kustoScriptTimeoutsToHclTerraform(struct?: KustoScriptTimeouts | cdktf.IResolvable): any;
export declare class KustoScriptTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KustoScriptTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KustoScriptTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script azurerm_kusto_script}
*/
export declare class KustoScript extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kusto_script";
    /**
    * Generates CDKTF code for importing a KustoScript resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KustoScript to import
    * @param importFromId The id of the existing KustoScript that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KustoScript to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/kusto_script azurerm_kusto_script} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KustoScriptConfig
    */
    constructor(scope: Construct, id: string, config: KustoScriptConfig);
    private _continueOnErrorsEnabled?;
    get continueOnErrorsEnabled(): boolean | cdktf.IResolvable;
    set continueOnErrorsEnabled(value: boolean | cdktf.IResolvable);
    resetContinueOnErrorsEnabled(): void;
    get continueOnErrorsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _databaseId?;
    get databaseId(): string;
    set databaseId(value: string);
    get databaseIdInput(): string | undefined;
    private _forceAnUpdateWhenValueChanged?;
    get forceAnUpdateWhenValueChanged(): string;
    set forceAnUpdateWhenValueChanged(value: string);
    resetForceAnUpdateWhenValueChanged(): void;
    get forceAnUpdateWhenValueChangedInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sasToken?;
    get sasToken(): string;
    set sasToken(value: string);
    resetSasToken(): void;
    get sasTokenInput(): string | undefined;
    private _scriptContent?;
    get scriptContent(): string;
    set scriptContent(value: string);
    resetScriptContent(): void;
    get scriptContentInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _timeouts;
    get timeouts(): KustoScriptTimeoutsOutputReference;
    putTimeouts(value: KustoScriptTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KustoScriptTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
