/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbNatRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#backend_address_pool_id LbNatRule#backend_address_pool_id}
    */
    readonly backendAddressPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#backend_port LbNatRule#backend_port}
    */
    readonly backendPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#enable_floating_ip LbNatRule#enable_floating_ip}
    */
    readonly enableFloatingIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#enable_tcp_reset LbNatRule#enable_tcp_reset}
    */
    readonly enableTcpReset?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#frontend_ip_configuration_name LbNatRule#frontend_ip_configuration_name}
    */
    readonly frontendIpConfigurationName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#frontend_port LbNatRule#frontend_port}
    */
    readonly frontendPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#frontend_port_end LbNatRule#frontend_port_end}
    */
    readonly frontendPortEnd?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#frontend_port_start LbNatRule#frontend_port_start}
    */
    readonly frontendPortStart?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#id LbNatRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#idle_timeout_in_minutes LbNatRule#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#loadbalancer_id LbNatRule#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#name LbNatRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#protocol LbNatRule#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#resource_group_name LbNatRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#timeouts LbNatRule#timeouts}
    */
    readonly timeouts?: LbNatRuleTimeouts;
}
export interface LbNatRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#create LbNatRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#delete LbNatRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#read LbNatRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#update LbNatRule#update}
    */
    readonly update?: string;
}
export declare function lbNatRuleTimeoutsToTerraform(struct?: LbNatRuleTimeouts | cdktf.IResolvable): any;
export declare function lbNatRuleTimeoutsToHclTerraform(struct?: LbNatRuleTimeouts | cdktf.IResolvable): any;
export declare class LbNatRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbNatRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LbNatRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule azurerm_lb_nat_rule}
*/
export declare class LbNatRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lb_nat_rule";
    /**
    * Generates CDKTF code for importing a LbNatRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LbNatRule to import
    * @param importFromId The id of the existing LbNatRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LbNatRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/lb_nat_rule azurerm_lb_nat_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbNatRuleConfig
    */
    constructor(scope: Construct, id: string, config: LbNatRuleConfig);
    private _backendAddressPoolId?;
    get backendAddressPoolId(): string;
    set backendAddressPoolId(value: string);
    resetBackendAddressPoolId(): void;
    get backendAddressPoolIdInput(): string | undefined;
    get backendIpConfigurationId(): string;
    private _backendPort?;
    get backendPort(): number;
    set backendPort(value: number);
    get backendPortInput(): number | undefined;
    private _enableFloatingIp?;
    get enableFloatingIp(): boolean | cdktf.IResolvable;
    set enableFloatingIp(value: boolean | cdktf.IResolvable);
    resetEnableFloatingIp(): void;
    get enableFloatingIpInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTcpReset?;
    get enableTcpReset(): boolean | cdktf.IResolvable;
    set enableTcpReset(value: boolean | cdktf.IResolvable);
    resetEnableTcpReset(): void;
    get enableTcpResetInput(): boolean | cdktf.IResolvable | undefined;
    get frontendIpConfigurationId(): string;
    private _frontendIpConfigurationName?;
    get frontendIpConfigurationName(): string;
    set frontendIpConfigurationName(value: string);
    get frontendIpConfigurationNameInput(): string | undefined;
    private _frontendPort?;
    get frontendPort(): number;
    set frontendPort(value: number);
    resetFrontendPort(): void;
    get frontendPortInput(): number | undefined;
    private _frontendPortEnd?;
    get frontendPortEnd(): number;
    set frontendPortEnd(value: number);
    resetFrontendPortEnd(): void;
    get frontendPortEndInput(): number | undefined;
    private _frontendPortStart?;
    get frontendPortStart(): number;
    set frontendPortStart(value: number);
    resetFrontendPortStart(): void;
    get frontendPortStartInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): LbNatRuleTimeoutsOutputReference;
    putTimeouts(value: LbNatRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LbNatRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
