/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MaintenanceConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#id MaintenanceConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#in_guest_user_patch_mode MaintenanceConfiguration#in_guest_user_patch_mode}
    */
    readonly inGuestUserPatchMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#location MaintenanceConfiguration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#name MaintenanceConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#properties MaintenanceConfiguration#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#resource_group_name MaintenanceConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#scope MaintenanceConfiguration#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#tags MaintenanceConfiguration#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#visibility MaintenanceConfiguration#visibility}
    */
    readonly visibility?: string;
    /**
    * install_patches block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#install_patches MaintenanceConfiguration#install_patches}
    */
    readonly installPatches?: MaintenanceConfigurationInstallPatches;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#timeouts MaintenanceConfiguration#timeouts}
    */
    readonly timeouts?: MaintenanceConfigurationTimeouts;
    /**
    * window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#window MaintenanceConfiguration#window}
    */
    readonly window?: MaintenanceConfigurationWindow;
}
export interface MaintenanceConfigurationInstallPatchesLinux {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#classifications_to_include MaintenanceConfiguration#classifications_to_include}
    */
    readonly classificationsToInclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#package_names_mask_to_exclude MaintenanceConfiguration#package_names_mask_to_exclude}
    */
    readonly packageNamesMaskToExclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#package_names_mask_to_include MaintenanceConfiguration#package_names_mask_to_include}
    */
    readonly packageNamesMaskToInclude?: string[];
}
export declare function maintenanceConfigurationInstallPatchesLinuxToTerraform(struct?: MaintenanceConfigurationInstallPatchesLinux | cdktf.IResolvable): any;
export declare function maintenanceConfigurationInstallPatchesLinuxToHclTerraform(struct?: MaintenanceConfigurationInstallPatchesLinux | cdktf.IResolvable): any;
export declare class MaintenanceConfigurationInstallPatchesLinuxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MaintenanceConfigurationInstallPatchesLinux | cdktf.IResolvable | undefined;
    set internalValue(value: MaintenanceConfigurationInstallPatchesLinux | cdktf.IResolvable | undefined);
    private _classificationsToInclude?;
    get classificationsToInclude(): string[];
    set classificationsToInclude(value: string[]);
    resetClassificationsToInclude(): void;
    get classificationsToIncludeInput(): string[] | undefined;
    private _packageNamesMaskToExclude?;
    get packageNamesMaskToExclude(): string[];
    set packageNamesMaskToExclude(value: string[]);
    resetPackageNamesMaskToExclude(): void;
    get packageNamesMaskToExcludeInput(): string[] | undefined;
    private _packageNamesMaskToInclude?;
    get packageNamesMaskToInclude(): string[];
    set packageNamesMaskToInclude(value: string[]);
    resetPackageNamesMaskToInclude(): void;
    get packageNamesMaskToIncludeInput(): string[] | undefined;
}
export declare class MaintenanceConfigurationInstallPatchesLinuxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MaintenanceConfigurationInstallPatchesLinux[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MaintenanceConfigurationInstallPatchesLinuxOutputReference;
}
export interface MaintenanceConfigurationInstallPatchesWindows {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#classifications_to_include MaintenanceConfiguration#classifications_to_include}
    */
    readonly classificationsToInclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#kb_numbers_to_exclude MaintenanceConfiguration#kb_numbers_to_exclude}
    */
    readonly kbNumbersToExclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#kb_numbers_to_include MaintenanceConfiguration#kb_numbers_to_include}
    */
    readonly kbNumbersToInclude?: string[];
}
export declare function maintenanceConfigurationInstallPatchesWindowsToTerraform(struct?: MaintenanceConfigurationInstallPatchesWindows | cdktf.IResolvable): any;
export declare function maintenanceConfigurationInstallPatchesWindowsToHclTerraform(struct?: MaintenanceConfigurationInstallPatchesWindows | cdktf.IResolvable): any;
export declare class MaintenanceConfigurationInstallPatchesWindowsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MaintenanceConfigurationInstallPatchesWindows | cdktf.IResolvable | undefined;
    set internalValue(value: MaintenanceConfigurationInstallPatchesWindows | cdktf.IResolvable | undefined);
    private _classificationsToInclude?;
    get classificationsToInclude(): string[];
    set classificationsToInclude(value: string[]);
    resetClassificationsToInclude(): void;
    get classificationsToIncludeInput(): string[] | undefined;
    private _kbNumbersToExclude?;
    get kbNumbersToExclude(): string[];
    set kbNumbersToExclude(value: string[]);
    resetKbNumbersToExclude(): void;
    get kbNumbersToExcludeInput(): string[] | undefined;
    private _kbNumbersToInclude?;
    get kbNumbersToInclude(): string[];
    set kbNumbersToInclude(value: string[]);
    resetKbNumbersToInclude(): void;
    get kbNumbersToIncludeInput(): string[] | undefined;
}
export declare class MaintenanceConfigurationInstallPatchesWindowsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MaintenanceConfigurationInstallPatchesWindows[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MaintenanceConfigurationInstallPatchesWindowsOutputReference;
}
export interface MaintenanceConfigurationInstallPatches {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#reboot MaintenanceConfiguration#reboot}
    */
    readonly reboot?: string;
    /**
    * linux block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#linux MaintenanceConfiguration#linux}
    */
    readonly linux?: MaintenanceConfigurationInstallPatchesLinux[] | cdktf.IResolvable;
    /**
    * windows block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#windows MaintenanceConfiguration#windows}
    */
    readonly windows?: MaintenanceConfigurationInstallPatchesWindows[] | cdktf.IResolvable;
}
export declare function maintenanceConfigurationInstallPatchesToTerraform(struct?: MaintenanceConfigurationInstallPatchesOutputReference | MaintenanceConfigurationInstallPatches): any;
export declare function maintenanceConfigurationInstallPatchesToHclTerraform(struct?: MaintenanceConfigurationInstallPatchesOutputReference | MaintenanceConfigurationInstallPatches): any;
export declare class MaintenanceConfigurationInstallPatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MaintenanceConfigurationInstallPatches | undefined;
    set internalValue(value: MaintenanceConfigurationInstallPatches | undefined);
    private _reboot?;
    get reboot(): string;
    set reboot(value: string);
    resetReboot(): void;
    get rebootInput(): string | undefined;
    private _linux;
    get linux(): MaintenanceConfigurationInstallPatchesLinuxList;
    putLinux(value: MaintenanceConfigurationInstallPatchesLinux[] | cdktf.IResolvable): void;
    resetLinux(): void;
    get linuxInput(): cdktf.IResolvable | MaintenanceConfigurationInstallPatchesLinux[] | undefined;
    private _windows;
    get windows(): MaintenanceConfigurationInstallPatchesWindowsList;
    putWindows(value: MaintenanceConfigurationInstallPatchesWindows[] | cdktf.IResolvable): void;
    resetWindows(): void;
    get windowsInput(): cdktf.IResolvable | MaintenanceConfigurationInstallPatchesWindows[] | undefined;
}
export interface MaintenanceConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#create MaintenanceConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#delete MaintenanceConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#read MaintenanceConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#update MaintenanceConfiguration#update}
    */
    readonly update?: string;
}
export declare function maintenanceConfigurationTimeoutsToTerraform(struct?: MaintenanceConfigurationTimeouts | cdktf.IResolvable): any;
export declare function maintenanceConfigurationTimeoutsToHclTerraform(struct?: MaintenanceConfigurationTimeouts | cdktf.IResolvable): any;
export declare class MaintenanceConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MaintenanceConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MaintenanceConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MaintenanceConfigurationWindow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#duration MaintenanceConfiguration#duration}
    */
    readonly duration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#expiration_date_time MaintenanceConfiguration#expiration_date_time}
    */
    readonly expirationDateTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#recur_every MaintenanceConfiguration#recur_every}
    */
    readonly recurEvery?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#start_date_time MaintenanceConfiguration#start_date_time}
    */
    readonly startDateTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#time_zone MaintenanceConfiguration#time_zone}
    */
    readonly timeZone: string;
}
export declare function maintenanceConfigurationWindowToTerraform(struct?: MaintenanceConfigurationWindowOutputReference | MaintenanceConfigurationWindow): any;
export declare function maintenanceConfigurationWindowToHclTerraform(struct?: MaintenanceConfigurationWindowOutputReference | MaintenanceConfigurationWindow): any;
export declare class MaintenanceConfigurationWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MaintenanceConfigurationWindow | undefined;
    set internalValue(value: MaintenanceConfigurationWindow | undefined);
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
    private _expirationDateTime?;
    get expirationDateTime(): string;
    set expirationDateTime(value: string);
    resetExpirationDateTime(): void;
    get expirationDateTimeInput(): string | undefined;
    private _recurEvery?;
    get recurEvery(): string;
    set recurEvery(value: string);
    resetRecurEvery(): void;
    get recurEveryInput(): string | undefined;
    private _startDateTime?;
    get startDateTime(): string;
    set startDateTime(value: string);
    get startDateTimeInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration azurerm_maintenance_configuration}
*/
export declare class MaintenanceConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_maintenance_configuration";
    /**
    * Generates CDKTF code for importing a MaintenanceConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MaintenanceConfiguration to import
    * @param importFromId The id of the existing MaintenanceConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MaintenanceConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/maintenance_configuration azurerm_maintenance_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MaintenanceConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: MaintenanceConfigurationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inGuestUserPatchMode?;
    get inGuestUserPatchMode(): string;
    set inGuestUserPatchMode(value: string);
    resetInGuestUserPatchMode(): void;
    get inGuestUserPatchModeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _installPatches;
    get installPatches(): MaintenanceConfigurationInstallPatchesOutputReference;
    putInstallPatches(value: MaintenanceConfigurationInstallPatches): void;
    resetInstallPatches(): void;
    get installPatchesInput(): MaintenanceConfigurationInstallPatches | undefined;
    private _timeouts;
    get timeouts(): MaintenanceConfigurationTimeoutsOutputReference;
    putTimeouts(value: MaintenanceConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MaintenanceConfigurationTimeouts | undefined;
    private _window;
    get window(): MaintenanceConfigurationWindowOutputReference;
    putWindow(value: MaintenanceConfigurationWindow): void;
    resetWindow(): void;
    get windowInput(): MaintenanceConfigurationWindow | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
