/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MarketplaceRoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#condition MarketplaceRoleAssignment#condition}
    */
    readonly condition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#condition_version MarketplaceRoleAssignment#condition_version}
    */
    readonly conditionVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#delegated_managed_identity_resource_id MarketplaceRoleAssignment#delegated_managed_identity_resource_id}
    */
    readonly delegatedManagedIdentityResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#description MarketplaceRoleAssignment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#id MarketplaceRoleAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#name MarketplaceRoleAssignment#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#principal_id MarketplaceRoleAssignment#principal_id}
    */
    readonly principalId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#role_definition_id MarketplaceRoleAssignment#role_definition_id}
    */
    readonly roleDefinitionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#role_definition_name MarketplaceRoleAssignment#role_definition_name}
    */
    readonly roleDefinitionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#skip_service_principal_aad_check MarketplaceRoleAssignment#skip_service_principal_aad_check}
    */
    readonly skipServicePrincipalAadCheck?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#timeouts MarketplaceRoleAssignment#timeouts}
    */
    readonly timeouts?: MarketplaceRoleAssignmentTimeouts;
}
export interface MarketplaceRoleAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#create MarketplaceRoleAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#delete MarketplaceRoleAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#read MarketplaceRoleAssignment#read}
    */
    readonly read?: string;
}
export declare function marketplaceRoleAssignmentTimeoutsToTerraform(struct?: MarketplaceRoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare function marketplaceRoleAssignmentTimeoutsToHclTerraform(struct?: MarketplaceRoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare class MarketplaceRoleAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MarketplaceRoleAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MarketplaceRoleAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment azurerm_marketplace_role_assignment}
*/
export declare class MarketplaceRoleAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_marketplace_role_assignment";
    /**
    * Generates CDKTF code for importing a MarketplaceRoleAssignment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MarketplaceRoleAssignment to import
    * @param importFromId The id of the existing MarketplaceRoleAssignment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MarketplaceRoleAssignment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/marketplace_role_assignment azurerm_marketplace_role_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MarketplaceRoleAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: MarketplaceRoleAssignmentConfig);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _conditionVersion?;
    get conditionVersion(): string;
    set conditionVersion(value: string);
    resetConditionVersion(): void;
    get conditionVersionInput(): string | undefined;
    private _delegatedManagedIdentityResourceId?;
    get delegatedManagedIdentityResourceId(): string;
    set delegatedManagedIdentityResourceId(value: string);
    resetDelegatedManagedIdentityResourceId(): void;
    get delegatedManagedIdentityResourceIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    get principalIdInput(): string | undefined;
    get principalType(): string;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    resetRoleDefinitionId(): void;
    get roleDefinitionIdInput(): string | undefined;
    private _roleDefinitionName?;
    get roleDefinitionName(): string;
    set roleDefinitionName(value: string);
    resetRoleDefinitionName(): void;
    get roleDefinitionNameInput(): string | undefined;
    private _skipServicePrincipalAadCheck?;
    get skipServicePrincipalAadCheck(): boolean | cdktf.IResolvable;
    set skipServicePrincipalAadCheck(value: boolean | cdktf.IResolvable);
    resetSkipServicePrincipalAadCheck(): void;
    get skipServicePrincipalAadCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): MarketplaceRoleAssignmentTimeoutsOutputReference;
    putTimeouts(value: MarketplaceRoleAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MarketplaceRoleAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
