/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlJobStepConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#id MssqlJobStep#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#initial_retry_interval_seconds MssqlJobStep#initial_retry_interval_seconds}
    */
    readonly initialRetryIntervalSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#job_credential_id MssqlJobStep#job_credential_id}
    */
    readonly jobCredentialId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#job_id MssqlJobStep#job_id}
    */
    readonly jobId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#job_step_index MssqlJobStep#job_step_index}
    */
    readonly jobStepIndex: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#job_target_group_id MssqlJobStep#job_target_group_id}
    */
    readonly jobTargetGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#maximum_retry_interval_seconds MssqlJobStep#maximum_retry_interval_seconds}
    */
    readonly maximumRetryIntervalSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#name MssqlJobStep#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#retry_attempts MssqlJobStep#retry_attempts}
    */
    readonly retryAttempts?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#retry_interval_backoff_multiplier MssqlJobStep#retry_interval_backoff_multiplier}
    */
    readonly retryIntervalBackoffMultiplier?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#sql_script MssqlJobStep#sql_script}
    */
    readonly sqlScript: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#timeout_seconds MssqlJobStep#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * output_target block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#output_target MssqlJobStep#output_target}
    */
    readonly outputTarget?: MssqlJobStepOutputTarget;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#timeouts MssqlJobStep#timeouts}
    */
    readonly timeouts?: MssqlJobStepTimeouts;
}
export interface MssqlJobStepOutputTarget {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#job_credential_id MssqlJobStep#job_credential_id}
    */
    readonly jobCredentialId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#mssql_database_id MssqlJobStep#mssql_database_id}
    */
    readonly mssqlDatabaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#schema_name MssqlJobStep#schema_name}
    */
    readonly schemaName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#table_name MssqlJobStep#table_name}
    */
    readonly tableName: string;
}
export declare function mssqlJobStepOutputTargetToTerraform(struct?: MssqlJobStepOutputTargetOutputReference | MssqlJobStepOutputTarget): any;
export declare function mssqlJobStepOutputTargetToHclTerraform(struct?: MssqlJobStepOutputTargetOutputReference | MssqlJobStepOutputTarget): any;
export declare class MssqlJobStepOutputTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlJobStepOutputTarget | undefined;
    set internalValue(value: MssqlJobStepOutputTarget | undefined);
    private _jobCredentialId?;
    get jobCredentialId(): string;
    set jobCredentialId(value: string);
    get jobCredentialIdInput(): string | undefined;
    private _mssqlDatabaseId?;
    get mssqlDatabaseId(): string;
    set mssqlDatabaseId(value: string);
    get mssqlDatabaseIdInput(): string | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    resetSchemaName(): void;
    get schemaNameInput(): string | undefined;
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    get tableNameInput(): string | undefined;
}
export interface MssqlJobStepTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#create MssqlJobStep#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#delete MssqlJobStep#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#read MssqlJobStep#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#update MssqlJobStep#update}
    */
    readonly update?: string;
}
export declare function mssqlJobStepTimeoutsToTerraform(struct?: MssqlJobStepTimeouts | cdktf.IResolvable): any;
export declare function mssqlJobStepTimeoutsToHclTerraform(struct?: MssqlJobStepTimeouts | cdktf.IResolvable): any;
export declare class MssqlJobStepTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlJobStepTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlJobStepTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step azurerm_mssql_job_step}
*/
export declare class MssqlJobStep extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_job_step";
    /**
    * Generates CDKTF code for importing a MssqlJobStep resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlJobStep to import
    * @param importFromId The id of the existing MssqlJobStep that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlJobStep to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/mssql_job_step azurerm_mssql_job_step} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlJobStepConfig
    */
    constructor(scope: Construct, id: string, config: MssqlJobStepConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialRetryIntervalSeconds?;
    get initialRetryIntervalSeconds(): number;
    set initialRetryIntervalSeconds(value: number);
    resetInitialRetryIntervalSeconds(): void;
    get initialRetryIntervalSecondsInput(): number | undefined;
    private _jobCredentialId?;
    get jobCredentialId(): string;
    set jobCredentialId(value: string);
    get jobCredentialIdInput(): string | undefined;
    private _jobId?;
    get jobId(): string;
    set jobId(value: string);
    get jobIdInput(): string | undefined;
    private _jobStepIndex?;
    get jobStepIndex(): number;
    set jobStepIndex(value: number);
    get jobStepIndexInput(): number | undefined;
    private _jobTargetGroupId?;
    get jobTargetGroupId(): string;
    set jobTargetGroupId(value: string);
    get jobTargetGroupIdInput(): string | undefined;
    private _maximumRetryIntervalSeconds?;
    get maximumRetryIntervalSeconds(): number;
    set maximumRetryIntervalSeconds(value: number);
    resetMaximumRetryIntervalSeconds(): void;
    get maximumRetryIntervalSecondsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _retryAttempts?;
    get retryAttempts(): number;
    set retryAttempts(value: number);
    resetRetryAttempts(): void;
    get retryAttemptsInput(): number | undefined;
    private _retryIntervalBackoffMultiplier?;
    get retryIntervalBackoffMultiplier(): number;
    set retryIntervalBackoffMultiplier(value: number);
    resetRetryIntervalBackoffMultiplier(): void;
    get retryIntervalBackoffMultiplierInput(): number | undefined;
    private _sqlScript?;
    get sqlScript(): string;
    set sqlScript(value: string);
    get sqlScriptInput(): string | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _outputTarget;
    get outputTarget(): MssqlJobStepOutputTargetOutputReference;
    putOutputTarget(value: MssqlJobStepOutputTarget): void;
    resetOutputTarget(): void;
    get outputTargetInput(): MssqlJobStepOutputTarget | undefined;
    private _timeouts;
    get timeouts(): MssqlJobStepTimeoutsOutputReference;
    putTimeouts(value: MssqlJobStepTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlJobStepTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
