/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkManagerConnectivityConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#connectivity_topology NetworkManagerConnectivityConfiguration#connectivity_topology}
    */
    readonly connectivityTopology: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#delete_existing_peering_enabled NetworkManagerConnectivityConfiguration#delete_existing_peering_enabled}
    */
    readonly deleteExistingPeeringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#description NetworkManagerConnectivityConfiguration#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#global_mesh_enabled NetworkManagerConnectivityConfiguration#global_mesh_enabled}
    */
    readonly globalMeshEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#id NetworkManagerConnectivityConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#name NetworkManagerConnectivityConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#network_manager_id NetworkManagerConnectivityConfiguration#network_manager_id}
    */
    readonly networkManagerId: string;
    /**
    * applies_to_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#applies_to_group NetworkManagerConnectivityConfiguration#applies_to_group}
    */
    readonly appliesToGroup: NetworkManagerConnectivityConfigurationAppliesToGroup[] | cdktf.IResolvable;
    /**
    * hub block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#hub NetworkManagerConnectivityConfiguration#hub}
    */
    readonly hub?: NetworkManagerConnectivityConfigurationHub;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#timeouts NetworkManagerConnectivityConfiguration#timeouts}
    */
    readonly timeouts?: NetworkManagerConnectivityConfigurationTimeouts;
}
export interface NetworkManagerConnectivityConfigurationAppliesToGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#global_mesh_enabled NetworkManagerConnectivityConfiguration#global_mesh_enabled}
    */
    readonly globalMeshEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#group_connectivity NetworkManagerConnectivityConfiguration#group_connectivity}
    */
    readonly groupConnectivity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#network_group_id NetworkManagerConnectivityConfiguration#network_group_id}
    */
    readonly networkGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#use_hub_gateway NetworkManagerConnectivityConfiguration#use_hub_gateway}
    */
    readonly useHubGateway?: boolean | cdktf.IResolvable;
}
export declare function networkManagerConnectivityConfigurationAppliesToGroupToTerraform(struct?: NetworkManagerConnectivityConfigurationAppliesToGroup | cdktf.IResolvable): any;
export declare function networkManagerConnectivityConfigurationAppliesToGroupToHclTerraform(struct?: NetworkManagerConnectivityConfigurationAppliesToGroup | cdktf.IResolvable): any;
export declare class NetworkManagerConnectivityConfigurationAppliesToGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkManagerConnectivityConfigurationAppliesToGroup | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerConnectivityConfigurationAppliesToGroup | cdktf.IResolvable | undefined);
    private _globalMeshEnabled?;
    get globalMeshEnabled(): boolean | cdktf.IResolvable;
    set globalMeshEnabled(value: boolean | cdktf.IResolvable);
    resetGlobalMeshEnabled(): void;
    get globalMeshEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _groupConnectivity?;
    get groupConnectivity(): string;
    set groupConnectivity(value: string);
    get groupConnectivityInput(): string | undefined;
    private _networkGroupId?;
    get networkGroupId(): string;
    set networkGroupId(value: string);
    get networkGroupIdInput(): string | undefined;
    private _useHubGateway?;
    get useHubGateway(): boolean | cdktf.IResolvable;
    set useHubGateway(value: boolean | cdktf.IResolvable);
    resetUseHubGateway(): void;
    get useHubGatewayInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class NetworkManagerConnectivityConfigurationAppliesToGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetworkManagerConnectivityConfigurationAppliesToGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkManagerConnectivityConfigurationAppliesToGroupOutputReference;
}
export interface NetworkManagerConnectivityConfigurationHub {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#resource_id NetworkManagerConnectivityConfiguration#resource_id}
    */
    readonly resourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#resource_type NetworkManagerConnectivityConfiguration#resource_type}
    */
    readonly resourceType: string;
}
export declare function networkManagerConnectivityConfigurationHubToTerraform(struct?: NetworkManagerConnectivityConfigurationHubOutputReference | NetworkManagerConnectivityConfigurationHub): any;
export declare function networkManagerConnectivityConfigurationHubToHclTerraform(struct?: NetworkManagerConnectivityConfigurationHubOutputReference | NetworkManagerConnectivityConfigurationHub): any;
export declare class NetworkManagerConnectivityConfigurationHubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerConnectivityConfigurationHub | undefined;
    set internalValue(value: NetworkManagerConnectivityConfigurationHub | undefined);
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    get resourceTypeInput(): string | undefined;
}
export interface NetworkManagerConnectivityConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#create NetworkManagerConnectivityConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#delete NetworkManagerConnectivityConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#read NetworkManagerConnectivityConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#update NetworkManagerConnectivityConfiguration#update}
    */
    readonly update?: string;
}
export declare function networkManagerConnectivityConfigurationTimeoutsToTerraform(struct?: NetworkManagerConnectivityConfigurationTimeouts | cdktf.IResolvable): any;
export declare function networkManagerConnectivityConfigurationTimeoutsToHclTerraform(struct?: NetworkManagerConnectivityConfigurationTimeouts | cdktf.IResolvable): any;
export declare class NetworkManagerConnectivityConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerConnectivityConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerConnectivityConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration azurerm_network_manager_connectivity_configuration}
*/
export declare class NetworkManagerConnectivityConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_manager_connectivity_configuration";
    /**
    * Generates CDKTF code for importing a NetworkManagerConnectivityConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkManagerConnectivityConfiguration to import
    * @param importFromId The id of the existing NetworkManagerConnectivityConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkManagerConnectivityConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/network_manager_connectivity_configuration azurerm_network_manager_connectivity_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkManagerConnectivityConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: NetworkManagerConnectivityConfigurationConfig);
    private _connectivityTopology?;
    get connectivityTopology(): string;
    set connectivityTopology(value: string);
    get connectivityTopologyInput(): string | undefined;
    private _deleteExistingPeeringEnabled?;
    get deleteExistingPeeringEnabled(): boolean | cdktf.IResolvable;
    set deleteExistingPeeringEnabled(value: boolean | cdktf.IResolvable);
    resetDeleteExistingPeeringEnabled(): void;
    get deleteExistingPeeringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _globalMeshEnabled?;
    get globalMeshEnabled(): boolean | cdktf.IResolvable;
    set globalMeshEnabled(value: boolean | cdktf.IResolvable);
    resetGlobalMeshEnabled(): void;
    get globalMeshEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkManagerId?;
    get networkManagerId(): string;
    set networkManagerId(value: string);
    get networkManagerIdInput(): string | undefined;
    private _appliesToGroup;
    get appliesToGroup(): NetworkManagerConnectivityConfigurationAppliesToGroupList;
    putAppliesToGroup(value: NetworkManagerConnectivityConfigurationAppliesToGroup[] | cdktf.IResolvable): void;
    get appliesToGroupInput(): cdktf.IResolvable | NetworkManagerConnectivityConfigurationAppliesToGroup[] | undefined;
    private _hub;
    get hub(): NetworkManagerConnectivityConfigurationHubOutputReference;
    putHub(value: NetworkManagerConnectivityConfigurationHub): void;
    resetHub(): void;
    get hubInput(): NetworkManagerConnectivityConfigurationHub | undefined;
    private _timeouts;
    get timeouts(): NetworkManagerConnectivityConfigurationTimeoutsOutputReference;
    putTimeouts(value: NetworkManagerConnectivityConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkManagerConnectivityConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
