/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrbitalSpacecraftConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#id OrbitalSpacecraft#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#location OrbitalSpacecraft#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#name OrbitalSpacecraft#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#norad_id OrbitalSpacecraft#norad_id}
    */
    readonly noradId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#resource_group_name OrbitalSpacecraft#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#tags OrbitalSpacecraft#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#title_line OrbitalSpacecraft#title_line}
    */
    readonly titleLine: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#two_line_elements OrbitalSpacecraft#two_line_elements}
    */
    readonly twoLineElements: string[];
    /**
    * links block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#links OrbitalSpacecraft#links}
    */
    readonly links: OrbitalSpacecraftLinks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#timeouts OrbitalSpacecraft#timeouts}
    */
    readonly timeouts?: OrbitalSpacecraftTimeouts;
}
export interface OrbitalSpacecraftLinks {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#bandwidth_mhz OrbitalSpacecraft#bandwidth_mhz}
    */
    readonly bandwidthMhz: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#center_frequency_mhz OrbitalSpacecraft#center_frequency_mhz}
    */
    readonly centerFrequencyMhz: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#direction OrbitalSpacecraft#direction}
    */
    readonly direction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#name OrbitalSpacecraft#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#polarization OrbitalSpacecraft#polarization}
    */
    readonly polarization: string;
}
export declare function orbitalSpacecraftLinksToTerraform(struct?: OrbitalSpacecraftLinks | cdktf.IResolvable): any;
export declare function orbitalSpacecraftLinksToHclTerraform(struct?: OrbitalSpacecraftLinks | cdktf.IResolvable): any;
export declare class OrbitalSpacecraftLinksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrbitalSpacecraftLinks | cdktf.IResolvable | undefined;
    set internalValue(value: OrbitalSpacecraftLinks | cdktf.IResolvable | undefined);
    private _bandwidthMhz?;
    get bandwidthMhz(): number;
    set bandwidthMhz(value: number);
    get bandwidthMhzInput(): number | undefined;
    private _centerFrequencyMhz?;
    get centerFrequencyMhz(): number;
    set centerFrequencyMhz(value: number);
    get centerFrequencyMhzInput(): number | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _polarization?;
    get polarization(): string;
    set polarization(value: string);
    get polarizationInput(): string | undefined;
}
export declare class OrbitalSpacecraftLinksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrbitalSpacecraftLinks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrbitalSpacecraftLinksOutputReference;
}
export interface OrbitalSpacecraftTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#create OrbitalSpacecraft#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#delete OrbitalSpacecraft#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#read OrbitalSpacecraft#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#update OrbitalSpacecraft#update}
    */
    readonly update?: string;
}
export declare function orbitalSpacecraftTimeoutsToTerraform(struct?: OrbitalSpacecraftTimeouts | cdktf.IResolvable): any;
export declare function orbitalSpacecraftTimeoutsToHclTerraform(struct?: OrbitalSpacecraftTimeouts | cdktf.IResolvable): any;
export declare class OrbitalSpacecraftTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrbitalSpacecraftTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OrbitalSpacecraftTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft azurerm_orbital_spacecraft}
*/
export declare class OrbitalSpacecraft extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_orbital_spacecraft";
    /**
    * Generates CDKTF code for importing a OrbitalSpacecraft resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OrbitalSpacecraft to import
    * @param importFromId The id of the existing OrbitalSpacecraft that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OrbitalSpacecraft to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/orbital_spacecraft azurerm_orbital_spacecraft} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrbitalSpacecraftConfig
    */
    constructor(scope: Construct, id: string, config: OrbitalSpacecraftConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _noradId?;
    get noradId(): string;
    set noradId(value: string);
    get noradIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _titleLine?;
    get titleLine(): string;
    set titleLine(value: string);
    get titleLineInput(): string | undefined;
    private _twoLineElements?;
    get twoLineElements(): string[];
    set twoLineElements(value: string[]);
    get twoLineElementsInput(): string[] | undefined;
    private _links;
    get links(): OrbitalSpacecraftLinksList;
    putLinks(value: OrbitalSpacecraftLinks[] | cdktf.IResolvable): void;
    get linksInput(): cdktf.IResolvable | OrbitalSpacecraftLinks[] | undefined;
    private _timeouts;
    get timeouts(): OrbitalSpacecraftTimeoutsOutputReference;
    putTimeouts(value: OrbitalSpacecraftTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OrbitalSpacecraftTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
