/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PointToSiteVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#dns_servers PointToSiteVpnGateway#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#id PointToSiteVpnGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#location PointToSiteVpnGateway#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#name PointToSiteVpnGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#resource_group_name PointToSiteVpnGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#routing_preference_internet_enabled PointToSiteVpnGateway#routing_preference_internet_enabled}
    */
    readonly routingPreferenceInternetEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#scale_unit PointToSiteVpnGateway#scale_unit}
    */
    readonly scaleUnit: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#tags PointToSiteVpnGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#virtual_hub_id PointToSiteVpnGateway#virtual_hub_id}
    */
    readonly virtualHubId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#vpn_server_configuration_id PointToSiteVpnGateway#vpn_server_configuration_id}
    */
    readonly vpnServerConfigurationId: string;
    /**
    * connection_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#connection_configuration PointToSiteVpnGateway#connection_configuration}
    */
    readonly connectionConfiguration: PointToSiteVpnGatewayConnectionConfiguration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#timeouts PointToSiteVpnGateway#timeouts}
    */
    readonly timeouts?: PointToSiteVpnGatewayTimeouts;
}
export interface PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#ids PointToSiteVpnGateway#ids}
    */
    readonly ids: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#labels PointToSiteVpnGateway#labels}
    */
    readonly labels?: string[];
}
export declare function pointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableToTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableOutputReference | PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable): any;
export declare function pointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableToHclTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableOutputReference | PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable): any;
export declare class PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable | undefined;
    set internalValue(value: PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable | undefined);
    private _ids?;
    get ids(): string[];
    set ids(value: string[]);
    get idsInput(): string[] | undefined;
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
}
export interface PointToSiteVpnGatewayConnectionConfigurationRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#associated_route_table_id PointToSiteVpnGateway#associated_route_table_id}
    */
    readonly associatedRouteTableId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#inbound_route_map_id PointToSiteVpnGateway#inbound_route_map_id}
    */
    readonly inboundRouteMapId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#outbound_route_map_id PointToSiteVpnGateway#outbound_route_map_id}
    */
    readonly outboundRouteMapId?: string;
    /**
    * propagated_route_table block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#propagated_route_table PointToSiteVpnGateway#propagated_route_table}
    */
    readonly propagatedRouteTable?: PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable;
}
export declare function pointToSiteVpnGatewayConnectionConfigurationRouteToTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationRouteOutputReference | PointToSiteVpnGatewayConnectionConfigurationRoute): any;
export declare function pointToSiteVpnGatewayConnectionConfigurationRouteToHclTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationRouteOutputReference | PointToSiteVpnGatewayConnectionConfigurationRoute): any;
export declare class PointToSiteVpnGatewayConnectionConfigurationRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PointToSiteVpnGatewayConnectionConfigurationRoute | undefined;
    set internalValue(value: PointToSiteVpnGatewayConnectionConfigurationRoute | undefined);
    private _associatedRouteTableId?;
    get associatedRouteTableId(): string;
    set associatedRouteTableId(value: string);
    get associatedRouteTableIdInput(): string | undefined;
    private _inboundRouteMapId?;
    get inboundRouteMapId(): string;
    set inboundRouteMapId(value: string);
    resetInboundRouteMapId(): void;
    get inboundRouteMapIdInput(): string | undefined;
    private _outboundRouteMapId?;
    get outboundRouteMapId(): string;
    set outboundRouteMapId(value: string);
    resetOutboundRouteMapId(): void;
    get outboundRouteMapIdInput(): string | undefined;
    private _propagatedRouteTable;
    get propagatedRouteTable(): PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableOutputReference;
    putPropagatedRouteTable(value: PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable): void;
    resetPropagatedRouteTable(): void;
    get propagatedRouteTableInput(): PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable | undefined;
}
export interface PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#address_prefixes PointToSiteVpnGateway#address_prefixes}
    */
    readonly addressPrefixes: string[];
}
export declare function pointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolToTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolOutputReference | PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool): any;
export declare function pointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolToHclTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolOutputReference | PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool): any;
export declare class PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool | undefined;
    set internalValue(value: PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool | undefined);
    private _addressPrefixes?;
    get addressPrefixes(): string[];
    set addressPrefixes(value: string[]);
    get addressPrefixesInput(): string[] | undefined;
}
export interface PointToSiteVpnGatewayConnectionConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#internet_security_enabled PointToSiteVpnGateway#internet_security_enabled}
    */
    readonly internetSecurityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#name PointToSiteVpnGateway#name}
    */
    readonly name: string;
    /**
    * route block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#route PointToSiteVpnGateway#route}
    */
    readonly route?: PointToSiteVpnGatewayConnectionConfigurationRoute;
    /**
    * vpn_client_address_pool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#vpn_client_address_pool PointToSiteVpnGateway#vpn_client_address_pool}
    */
    readonly vpnClientAddressPool: PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool;
}
export declare function pointToSiteVpnGatewayConnectionConfigurationToTerraform(struct?: PointToSiteVpnGatewayConnectionConfiguration | cdktf.IResolvable): any;
export declare function pointToSiteVpnGatewayConnectionConfigurationToHclTerraform(struct?: PointToSiteVpnGatewayConnectionConfiguration | cdktf.IResolvable): any;
export declare class PointToSiteVpnGatewayConnectionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PointToSiteVpnGatewayConnectionConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: PointToSiteVpnGatewayConnectionConfiguration | cdktf.IResolvable | undefined);
    private _internetSecurityEnabled?;
    get internetSecurityEnabled(): boolean | cdktf.IResolvable;
    set internetSecurityEnabled(value: boolean | cdktf.IResolvable);
    resetInternetSecurityEnabled(): void;
    get internetSecurityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _route;
    get route(): PointToSiteVpnGatewayConnectionConfigurationRouteOutputReference;
    putRoute(value: PointToSiteVpnGatewayConnectionConfigurationRoute): void;
    resetRoute(): void;
    get routeInput(): PointToSiteVpnGatewayConnectionConfigurationRoute | undefined;
    private _vpnClientAddressPool;
    get vpnClientAddressPool(): PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolOutputReference;
    putVpnClientAddressPool(value: PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool): void;
    get vpnClientAddressPoolInput(): PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool | undefined;
}
export declare class PointToSiteVpnGatewayConnectionConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PointToSiteVpnGatewayConnectionConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PointToSiteVpnGatewayConnectionConfigurationOutputReference;
}
export interface PointToSiteVpnGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#create PointToSiteVpnGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#delete PointToSiteVpnGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#read PointToSiteVpnGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#update PointToSiteVpnGateway#update}
    */
    readonly update?: string;
}
export declare function pointToSiteVpnGatewayTimeoutsToTerraform(struct?: PointToSiteVpnGatewayTimeouts | cdktf.IResolvable): any;
export declare function pointToSiteVpnGatewayTimeoutsToHclTerraform(struct?: PointToSiteVpnGatewayTimeouts | cdktf.IResolvable): any;
export declare class PointToSiteVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PointToSiteVpnGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PointToSiteVpnGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway azurerm_point_to_site_vpn_gateway}
*/
export declare class PointToSiteVpnGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_point_to_site_vpn_gateway";
    /**
    * Generates CDKTF code for importing a PointToSiteVpnGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PointToSiteVpnGateway to import
    * @param importFromId The id of the existing PointToSiteVpnGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PointToSiteVpnGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/point_to_site_vpn_gateway azurerm_point_to_site_vpn_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PointToSiteVpnGatewayConfig
    */
    constructor(scope: Construct, id: string, config: PointToSiteVpnGatewayConfig);
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _routingPreferenceInternetEnabled?;
    get routingPreferenceInternetEnabled(): boolean | cdktf.IResolvable;
    set routingPreferenceInternetEnabled(value: boolean | cdktf.IResolvable);
    resetRoutingPreferenceInternetEnabled(): void;
    get routingPreferenceInternetEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scaleUnit?;
    get scaleUnit(): number;
    set scaleUnit(value: number);
    get scaleUnitInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
    private _vpnServerConfigurationId?;
    get vpnServerConfigurationId(): string;
    set vpnServerConfigurationId(value: string);
    get vpnServerConfigurationIdInput(): string | undefined;
    private _connectionConfiguration;
    get connectionConfiguration(): PointToSiteVpnGatewayConnectionConfigurationList;
    putConnectionConfiguration(value: PointToSiteVpnGatewayConnectionConfiguration[] | cdktf.IResolvable): void;
    get connectionConfigurationInput(): cdktf.IResolvable | PointToSiteVpnGatewayConnectionConfiguration[] | undefined;
    private _timeouts;
    get timeouts(): PointToSiteVpnGatewayTimeoutsOutputReference;
    putTimeouts(value: PointToSiteVpnGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PointToSiteVpnGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
