/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleManagementPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#id RoleManagementPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the Azure Role to which this policy is assigned
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#role_definition_id RoleManagementPolicy#role_definition_id}
    */
    readonly roleDefinitionId: string;
    /**
    * The scope of the role to which this policy will apply
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#scope RoleManagementPolicy#scope}
    */
    readonly scope: string;
    /**
    * activation_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#activation_rules RoleManagementPolicy#activation_rules}
    */
    readonly activationRules?: RoleManagementPolicyActivationRules;
    /**
    * active_assignment_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#active_assignment_rules RoleManagementPolicy#active_assignment_rules}
    */
    readonly activeAssignmentRules?: RoleManagementPolicyActiveAssignmentRules;
    /**
    * eligible_assignment_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#eligible_assignment_rules RoleManagementPolicy#eligible_assignment_rules}
    */
    readonly eligibleAssignmentRules?: RoleManagementPolicyEligibleAssignmentRules;
    /**
    * notification_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_rules RoleManagementPolicy#notification_rules}
    */
    readonly notificationRules?: RoleManagementPolicyNotificationRules;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#timeouts RoleManagementPolicy#timeouts}
    */
    readonly timeouts?: RoleManagementPolicyTimeouts;
}
export interface RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover {
    /**
    * The ID of the object to act as an approver
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#object_id RoleManagementPolicy#object_id}
    */
    readonly objectId: string;
    /**
    * The type of object acting as an approver
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#type RoleManagementPolicy#type}
    */
    readonly type: string;
}
export declare function roleManagementPolicyActivationRulesApprovalStagePrimaryApproverToTerraform(struct?: RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover | cdktf.IResolvable): any;
export declare function roleManagementPolicyActivationRulesApprovalStagePrimaryApproverToHclTerraform(struct?: RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover | cdktf.IResolvable): any;
export declare class RoleManagementPolicyActivationRulesApprovalStagePrimaryApproverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover | cdktf.IResolvable | undefined;
    set internalValue(value: RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover | cdktf.IResolvable | undefined);
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    get objectIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class RoleManagementPolicyActivationRulesApprovalStagePrimaryApproverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RoleManagementPolicyActivationRulesApprovalStagePrimaryApproverOutputReference;
}
export interface RoleManagementPolicyActivationRulesApprovalStage {
    /**
    * primary_approver block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#primary_approver RoleManagementPolicy#primary_approver}
    */
    readonly primaryApprover: RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover[] | cdktf.IResolvable;
}
export declare function roleManagementPolicyActivationRulesApprovalStageToTerraform(struct?: RoleManagementPolicyActivationRulesApprovalStageOutputReference | RoleManagementPolicyActivationRulesApprovalStage): any;
export declare function roleManagementPolicyActivationRulesApprovalStageToHclTerraform(struct?: RoleManagementPolicyActivationRulesApprovalStageOutputReference | RoleManagementPolicyActivationRulesApprovalStage): any;
export declare class RoleManagementPolicyActivationRulesApprovalStageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyActivationRulesApprovalStage | undefined;
    set internalValue(value: RoleManagementPolicyActivationRulesApprovalStage | undefined);
    private _primaryApprover;
    get primaryApprover(): RoleManagementPolicyActivationRulesApprovalStagePrimaryApproverList;
    putPrimaryApprover(value: RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover[] | cdktf.IResolvable): void;
    get primaryApproverInput(): cdktf.IResolvable | RoleManagementPolicyActivationRulesApprovalStagePrimaryApprover[] | undefined;
}
export interface RoleManagementPolicyActivationRules {
    /**
    * The time after which the an activation can be valid for
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#maximum_duration RoleManagementPolicy#maximum_duration}
    */
    readonly maximumDuration?: string;
    /**
    * Whether an approval is required for activation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#require_approval RoleManagementPolicy#require_approval}
    */
    readonly requireApproval?: boolean | cdktf.IResolvable;
    /**
    * Whether a justification is required during activation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#require_justification RoleManagementPolicy#require_justification}
    */
    readonly requireJustification?: boolean | cdktf.IResolvable;
    /**
    * Whether multi-factor authentication is required during activation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#require_multifactor_authentication RoleManagementPolicy#require_multifactor_authentication}
    */
    readonly requireMultifactorAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Whether ticket information is required during activation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#require_ticket_info RoleManagementPolicy#require_ticket_info}
    */
    readonly requireTicketInfo?: boolean | cdktf.IResolvable;
    /**
    * Whether a conditional access context is required during activation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#required_conditional_access_authentication_context RoleManagementPolicy#required_conditional_access_authentication_context}
    */
    readonly requiredConditionalAccessAuthenticationContext?: string;
    /**
    * approval_stage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#approval_stage RoleManagementPolicy#approval_stage}
    */
    readonly approvalStage?: RoleManagementPolicyActivationRulesApprovalStage;
}
export declare function roleManagementPolicyActivationRulesToTerraform(struct?: RoleManagementPolicyActivationRulesOutputReference | RoleManagementPolicyActivationRules): any;
export declare function roleManagementPolicyActivationRulesToHclTerraform(struct?: RoleManagementPolicyActivationRulesOutputReference | RoleManagementPolicyActivationRules): any;
export declare class RoleManagementPolicyActivationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyActivationRules | undefined;
    set internalValue(value: RoleManagementPolicyActivationRules | undefined);
    private _maximumDuration?;
    get maximumDuration(): string;
    set maximumDuration(value: string);
    resetMaximumDuration(): void;
    get maximumDurationInput(): string | undefined;
    private _requireApproval?;
    get requireApproval(): boolean | cdktf.IResolvable;
    set requireApproval(value: boolean | cdktf.IResolvable);
    resetRequireApproval(): void;
    get requireApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _requireJustification?;
    get requireJustification(): boolean | cdktf.IResolvable;
    set requireJustification(value: boolean | cdktf.IResolvable);
    resetRequireJustification(): void;
    get requireJustificationInput(): boolean | cdktf.IResolvable | undefined;
    private _requireMultifactorAuthentication?;
    get requireMultifactorAuthentication(): boolean | cdktf.IResolvable;
    set requireMultifactorAuthentication(value: boolean | cdktf.IResolvable);
    resetRequireMultifactorAuthentication(): void;
    get requireMultifactorAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _requireTicketInfo?;
    get requireTicketInfo(): boolean | cdktf.IResolvable;
    set requireTicketInfo(value: boolean | cdktf.IResolvable);
    resetRequireTicketInfo(): void;
    get requireTicketInfoInput(): boolean | cdktf.IResolvable | undefined;
    private _requiredConditionalAccessAuthenticationContext?;
    get requiredConditionalAccessAuthenticationContext(): string;
    set requiredConditionalAccessAuthenticationContext(value: string);
    resetRequiredConditionalAccessAuthenticationContext(): void;
    get requiredConditionalAccessAuthenticationContextInput(): string | undefined;
    private _approvalStage;
    get approvalStage(): RoleManagementPolicyActivationRulesApprovalStageOutputReference;
    putApprovalStage(value: RoleManagementPolicyActivationRulesApprovalStage): void;
    resetApprovalStage(): void;
    get approvalStageInput(): RoleManagementPolicyActivationRulesApprovalStage | undefined;
}
export interface RoleManagementPolicyActiveAssignmentRules {
    /**
    * Must the assignment have an expiry date
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#expiration_required RoleManagementPolicy#expiration_required}
    */
    readonly expirationRequired?: boolean | cdktf.IResolvable;
    /**
    * The duration after which assignments expire
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#expire_after RoleManagementPolicy#expire_after}
    */
    readonly expireAfter?: string;
    /**
    * Whether a justification is required to make an assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#require_justification RoleManagementPolicy#require_justification}
    */
    readonly requireJustification?: boolean | cdktf.IResolvable;
    /**
    * Whether multi-factor authentication is required to make an assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#require_multifactor_authentication RoleManagementPolicy#require_multifactor_authentication}
    */
    readonly requireMultifactorAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Whether ticket information is required to make an assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#require_ticket_info RoleManagementPolicy#require_ticket_info}
    */
    readonly requireTicketInfo?: boolean | cdktf.IResolvable;
}
export declare function roleManagementPolicyActiveAssignmentRulesToTerraform(struct?: RoleManagementPolicyActiveAssignmentRulesOutputReference | RoleManagementPolicyActiveAssignmentRules): any;
export declare function roleManagementPolicyActiveAssignmentRulesToHclTerraform(struct?: RoleManagementPolicyActiveAssignmentRulesOutputReference | RoleManagementPolicyActiveAssignmentRules): any;
export declare class RoleManagementPolicyActiveAssignmentRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyActiveAssignmentRules | undefined;
    set internalValue(value: RoleManagementPolicyActiveAssignmentRules | undefined);
    private _expirationRequired?;
    get expirationRequired(): boolean | cdktf.IResolvable;
    set expirationRequired(value: boolean | cdktf.IResolvable);
    resetExpirationRequired(): void;
    get expirationRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _expireAfter?;
    get expireAfter(): string;
    set expireAfter(value: string);
    resetExpireAfter(): void;
    get expireAfterInput(): string | undefined;
    private _requireJustification?;
    get requireJustification(): boolean | cdktf.IResolvable;
    set requireJustification(value: boolean | cdktf.IResolvable);
    resetRequireJustification(): void;
    get requireJustificationInput(): boolean | cdktf.IResolvable | undefined;
    private _requireMultifactorAuthentication?;
    get requireMultifactorAuthentication(): boolean | cdktf.IResolvable;
    set requireMultifactorAuthentication(value: boolean | cdktf.IResolvable);
    resetRequireMultifactorAuthentication(): void;
    get requireMultifactorAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _requireTicketInfo?;
    get requireTicketInfo(): boolean | cdktf.IResolvable;
    set requireTicketInfo(value: boolean | cdktf.IResolvable);
    resetRequireTicketInfo(): void;
    get requireTicketInfoInput(): boolean | cdktf.IResolvable | undefined;
}
export interface RoleManagementPolicyEligibleAssignmentRules {
    /**
    * Must the assignment have an expiry date
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#expiration_required RoleManagementPolicy#expiration_required}
    */
    readonly expirationRequired?: boolean | cdktf.IResolvable;
    /**
    * The duration after which assignments expire
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#expire_after RoleManagementPolicy#expire_after}
    */
    readonly expireAfter?: string;
}
export declare function roleManagementPolicyEligibleAssignmentRulesToTerraform(struct?: RoleManagementPolicyEligibleAssignmentRulesOutputReference | RoleManagementPolicyEligibleAssignmentRules): any;
export declare function roleManagementPolicyEligibleAssignmentRulesToHclTerraform(struct?: RoleManagementPolicyEligibleAssignmentRulesOutputReference | RoleManagementPolicyEligibleAssignmentRules): any;
export declare class RoleManagementPolicyEligibleAssignmentRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyEligibleAssignmentRules | undefined;
    set internalValue(value: RoleManagementPolicyEligibleAssignmentRules | undefined);
    private _expirationRequired?;
    get expirationRequired(): boolean | cdktf.IResolvable;
    set expirationRequired(value: boolean | cdktf.IResolvable);
    resetExpirationRequired(): void;
    get expirationRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _expireAfter?;
    get expireAfter(): string;
    set expireAfter(value: string);
    resetExpireAfter(): void;
    get expireAfterInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications {
    /**
    * The additional recipients to notify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#additional_recipients RoleManagementPolicy#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Whether the default recipients are notified
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#default_recipients RoleManagementPolicy#default_recipients}
    */
    readonly defaultRecipients: boolean | cdktf.IResolvable;
    /**
    * What level of notifications are sent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_level RoleManagementPolicy#notification_level}
    */
    readonly notificationLevel: string;
}
export declare function roleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsToTerraform(struct?: RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsOutputReference | RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications): any;
export declare function roleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsOutputReference | RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications): any;
export declare class RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _defaultRecipients?;
    get defaultRecipients(): boolean | cdktf.IResolvable;
    set defaultRecipients(value: boolean | cdktf.IResolvable);
    get defaultRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _notificationLevel?;
    get notificationLevel(): string;
    set notificationLevel(value: string);
    get notificationLevelInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications {
    /**
    * The additional recipients to notify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#additional_recipients RoleManagementPolicy#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Whether the default recipients are notified
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#default_recipients RoleManagementPolicy#default_recipients}
    */
    readonly defaultRecipients: boolean | cdktf.IResolvable;
    /**
    * What level of notifications are sent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_level RoleManagementPolicy#notification_level}
    */
    readonly notificationLevel: string;
}
export declare function roleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsToTerraform(struct?: RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsOutputReference | RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications): any;
export declare function roleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsOutputReference | RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications): any;
export declare class RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _defaultRecipients?;
    get defaultRecipients(): boolean | cdktf.IResolvable;
    set defaultRecipients(value: boolean | cdktf.IResolvable);
    get defaultRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _notificationLevel?;
    get notificationLevel(): string;
    set notificationLevel(value: string);
    get notificationLevelInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications {
    /**
    * The additional recipients to notify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#additional_recipients RoleManagementPolicy#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Whether the default recipients are notified
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#default_recipients RoleManagementPolicy#default_recipients}
    */
    readonly defaultRecipients: boolean | cdktf.IResolvable;
    /**
    * What level of notifications are sent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_level RoleManagementPolicy#notification_level}
    */
    readonly notificationLevel: string;
}
export declare function roleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsToTerraform(struct?: RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsOutputReference | RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications): any;
export declare function roleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsOutputReference | RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications): any;
export declare class RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _defaultRecipients?;
    get defaultRecipients(): boolean | cdktf.IResolvable;
    set defaultRecipients(value: boolean | cdktf.IResolvable);
    get defaultRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _notificationLevel?;
    get notificationLevel(): string;
    set notificationLevel(value: string);
    get notificationLevelInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesActiveAssignments {
    /**
    * admin_notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#admin_notifications RoleManagementPolicy#admin_notifications}
    */
    readonly adminNotifications?: RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications;
    /**
    * approver_notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#approver_notifications RoleManagementPolicy#approver_notifications}
    */
    readonly approverNotifications?: RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications;
    /**
    * assignee_notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#assignee_notifications RoleManagementPolicy#assignee_notifications}
    */
    readonly assigneeNotifications?: RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications;
}
export declare function roleManagementPolicyNotificationRulesActiveAssignmentsToTerraform(struct?: RoleManagementPolicyNotificationRulesActiveAssignmentsOutputReference | RoleManagementPolicyNotificationRulesActiveAssignments): any;
export declare function roleManagementPolicyNotificationRulesActiveAssignmentsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesActiveAssignmentsOutputReference | RoleManagementPolicyNotificationRulesActiveAssignments): any;
export declare class RoleManagementPolicyNotificationRulesActiveAssignmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesActiveAssignments | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesActiveAssignments | undefined);
    private _adminNotifications;
    get adminNotifications(): RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsOutputReference;
    putAdminNotifications(value: RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications): void;
    resetAdminNotifications(): void;
    get adminNotificationsInput(): RoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications | undefined;
    private _approverNotifications;
    get approverNotifications(): RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsOutputReference;
    putApproverNotifications(value: RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications): void;
    resetApproverNotifications(): void;
    get approverNotificationsInput(): RoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications | undefined;
    private _assigneeNotifications;
    get assigneeNotifications(): RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsOutputReference;
    putAssigneeNotifications(value: RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications): void;
    resetAssigneeNotifications(): void;
    get assigneeNotificationsInput(): RoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications | undefined;
}
export interface RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications {
    /**
    * The additional recipients to notify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#additional_recipients RoleManagementPolicy#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Whether the default recipients are notified
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#default_recipients RoleManagementPolicy#default_recipients}
    */
    readonly defaultRecipients: boolean | cdktf.IResolvable;
    /**
    * What level of notifications are sent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_level RoleManagementPolicy#notification_level}
    */
    readonly notificationLevel: string;
}
export declare function roleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsToTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications): any;
export declare function roleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications): any;
export declare class RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _defaultRecipients?;
    get defaultRecipients(): boolean | cdktf.IResolvable;
    set defaultRecipients(value: boolean | cdktf.IResolvable);
    get defaultRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _notificationLevel?;
    get notificationLevel(): string;
    set notificationLevel(value: string);
    get notificationLevelInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications {
    /**
    * The additional recipients to notify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#additional_recipients RoleManagementPolicy#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Whether the default recipients are notified
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#default_recipients RoleManagementPolicy#default_recipients}
    */
    readonly defaultRecipients: boolean | cdktf.IResolvable;
    /**
    * What level of notifications are sent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_level RoleManagementPolicy#notification_level}
    */
    readonly notificationLevel: string;
}
export declare function roleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsToTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications): any;
export declare function roleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications): any;
export declare class RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _defaultRecipients?;
    get defaultRecipients(): boolean | cdktf.IResolvable;
    set defaultRecipients(value: boolean | cdktf.IResolvable);
    get defaultRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _notificationLevel?;
    get notificationLevel(): string;
    set notificationLevel(value: string);
    get notificationLevelInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications {
    /**
    * The additional recipients to notify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#additional_recipients RoleManagementPolicy#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Whether the default recipients are notified
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#default_recipients RoleManagementPolicy#default_recipients}
    */
    readonly defaultRecipients: boolean | cdktf.IResolvable;
    /**
    * What level of notifications are sent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_level RoleManagementPolicy#notification_level}
    */
    readonly notificationLevel: string;
}
export declare function roleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsToTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications): any;
export declare function roleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications): any;
export declare class RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _defaultRecipients?;
    get defaultRecipients(): boolean | cdktf.IResolvable;
    set defaultRecipients(value: boolean | cdktf.IResolvable);
    get defaultRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _notificationLevel?;
    get notificationLevel(): string;
    set notificationLevel(value: string);
    get notificationLevelInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesEligibleActivations {
    /**
    * admin_notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#admin_notifications RoleManagementPolicy#admin_notifications}
    */
    readonly adminNotifications?: RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications;
    /**
    * approver_notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#approver_notifications RoleManagementPolicy#approver_notifications}
    */
    readonly approverNotifications?: RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications;
    /**
    * assignee_notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#assignee_notifications RoleManagementPolicy#assignee_notifications}
    */
    readonly assigneeNotifications?: RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications;
}
export declare function roleManagementPolicyNotificationRulesEligibleActivationsToTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleActivationsOutputReference | RoleManagementPolicyNotificationRulesEligibleActivations): any;
export declare function roleManagementPolicyNotificationRulesEligibleActivationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleActivationsOutputReference | RoleManagementPolicyNotificationRulesEligibleActivations): any;
export declare class RoleManagementPolicyNotificationRulesEligibleActivationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesEligibleActivations | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesEligibleActivations | undefined);
    private _adminNotifications;
    get adminNotifications(): RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsOutputReference;
    putAdminNotifications(value: RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications): void;
    resetAdminNotifications(): void;
    get adminNotificationsInput(): RoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications | undefined;
    private _approverNotifications;
    get approverNotifications(): RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsOutputReference;
    putApproverNotifications(value: RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications): void;
    resetApproverNotifications(): void;
    get approverNotificationsInput(): RoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications | undefined;
    private _assigneeNotifications;
    get assigneeNotifications(): RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsOutputReference;
    putAssigneeNotifications(value: RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications): void;
    resetAssigneeNotifications(): void;
    get assigneeNotificationsInput(): RoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications | undefined;
}
export interface RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications {
    /**
    * The additional recipients to notify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#additional_recipients RoleManagementPolicy#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Whether the default recipients are notified
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#default_recipients RoleManagementPolicy#default_recipients}
    */
    readonly defaultRecipients: boolean | cdktf.IResolvable;
    /**
    * What level of notifications are sent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_level RoleManagementPolicy#notification_level}
    */
    readonly notificationLevel: string;
}
export declare function roleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsToTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications): any;
export declare function roleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications): any;
export declare class RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _defaultRecipients?;
    get defaultRecipients(): boolean | cdktf.IResolvable;
    set defaultRecipients(value: boolean | cdktf.IResolvable);
    get defaultRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _notificationLevel?;
    get notificationLevel(): string;
    set notificationLevel(value: string);
    get notificationLevelInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications {
    /**
    * The additional recipients to notify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#additional_recipients RoleManagementPolicy#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Whether the default recipients are notified
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#default_recipients RoleManagementPolicy#default_recipients}
    */
    readonly defaultRecipients: boolean | cdktf.IResolvable;
    /**
    * What level of notifications are sent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_level RoleManagementPolicy#notification_level}
    */
    readonly notificationLevel: string;
}
export declare function roleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsToTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications): any;
export declare function roleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications): any;
export declare class RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _defaultRecipients?;
    get defaultRecipients(): boolean | cdktf.IResolvable;
    set defaultRecipients(value: boolean | cdktf.IResolvable);
    get defaultRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _notificationLevel?;
    get notificationLevel(): string;
    set notificationLevel(value: string);
    get notificationLevelInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications {
    /**
    * The additional recipients to notify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#additional_recipients RoleManagementPolicy#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Whether the default recipients are notified
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#default_recipients RoleManagementPolicy#default_recipients}
    */
    readonly defaultRecipients: boolean | cdktf.IResolvable;
    /**
    * What level of notifications are sent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#notification_level RoleManagementPolicy#notification_level}
    */
    readonly notificationLevel: string;
}
export declare function roleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsToTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications): any;
export declare function roleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsOutputReference | RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications): any;
export declare class RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _defaultRecipients?;
    get defaultRecipients(): boolean | cdktf.IResolvable;
    set defaultRecipients(value: boolean | cdktf.IResolvable);
    get defaultRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _notificationLevel?;
    get notificationLevel(): string;
    set notificationLevel(value: string);
    get notificationLevelInput(): string | undefined;
}
export interface RoleManagementPolicyNotificationRulesEligibleAssignments {
    /**
    * admin_notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#admin_notifications RoleManagementPolicy#admin_notifications}
    */
    readonly adminNotifications?: RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications;
    /**
    * approver_notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#approver_notifications RoleManagementPolicy#approver_notifications}
    */
    readonly approverNotifications?: RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications;
    /**
    * assignee_notifications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#assignee_notifications RoleManagementPolicy#assignee_notifications}
    */
    readonly assigneeNotifications?: RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications;
}
export declare function roleManagementPolicyNotificationRulesEligibleAssignmentsToTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleAssignmentsOutputReference | RoleManagementPolicyNotificationRulesEligibleAssignments): any;
export declare function roleManagementPolicyNotificationRulesEligibleAssignmentsToHclTerraform(struct?: RoleManagementPolicyNotificationRulesEligibleAssignmentsOutputReference | RoleManagementPolicyNotificationRulesEligibleAssignments): any;
export declare class RoleManagementPolicyNotificationRulesEligibleAssignmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRulesEligibleAssignments | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRulesEligibleAssignments | undefined);
    private _adminNotifications;
    get adminNotifications(): RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsOutputReference;
    putAdminNotifications(value: RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications): void;
    resetAdminNotifications(): void;
    get adminNotificationsInput(): RoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications | undefined;
    private _approverNotifications;
    get approverNotifications(): RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsOutputReference;
    putApproverNotifications(value: RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications): void;
    resetApproverNotifications(): void;
    get approverNotificationsInput(): RoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications | undefined;
    private _assigneeNotifications;
    get assigneeNotifications(): RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsOutputReference;
    putAssigneeNotifications(value: RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications): void;
    resetAssigneeNotifications(): void;
    get assigneeNotificationsInput(): RoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications | undefined;
}
export interface RoleManagementPolicyNotificationRules {
    /**
    * active_assignments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#active_assignments RoleManagementPolicy#active_assignments}
    */
    readonly activeAssignments?: RoleManagementPolicyNotificationRulesActiveAssignments;
    /**
    * eligible_activations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#eligible_activations RoleManagementPolicy#eligible_activations}
    */
    readonly eligibleActivations?: RoleManagementPolicyNotificationRulesEligibleActivations;
    /**
    * eligible_assignments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#eligible_assignments RoleManagementPolicy#eligible_assignments}
    */
    readonly eligibleAssignments?: RoleManagementPolicyNotificationRulesEligibleAssignments;
}
export declare function roleManagementPolicyNotificationRulesToTerraform(struct?: RoleManagementPolicyNotificationRulesOutputReference | RoleManagementPolicyNotificationRules): any;
export declare function roleManagementPolicyNotificationRulesToHclTerraform(struct?: RoleManagementPolicyNotificationRulesOutputReference | RoleManagementPolicyNotificationRules): any;
export declare class RoleManagementPolicyNotificationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyNotificationRules | undefined;
    set internalValue(value: RoleManagementPolicyNotificationRules | undefined);
    private _activeAssignments;
    get activeAssignments(): RoleManagementPolicyNotificationRulesActiveAssignmentsOutputReference;
    putActiveAssignments(value: RoleManagementPolicyNotificationRulesActiveAssignments): void;
    resetActiveAssignments(): void;
    get activeAssignmentsInput(): RoleManagementPolicyNotificationRulesActiveAssignments | undefined;
    private _eligibleActivations;
    get eligibleActivations(): RoleManagementPolicyNotificationRulesEligibleActivationsOutputReference;
    putEligibleActivations(value: RoleManagementPolicyNotificationRulesEligibleActivations): void;
    resetEligibleActivations(): void;
    get eligibleActivationsInput(): RoleManagementPolicyNotificationRulesEligibleActivations | undefined;
    private _eligibleAssignments;
    get eligibleAssignments(): RoleManagementPolicyNotificationRulesEligibleAssignmentsOutputReference;
    putEligibleAssignments(value: RoleManagementPolicyNotificationRulesEligibleAssignments): void;
    resetEligibleAssignments(): void;
    get eligibleAssignmentsInput(): RoleManagementPolicyNotificationRulesEligibleAssignments | undefined;
}
export interface RoleManagementPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#create RoleManagementPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#delete RoleManagementPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#read RoleManagementPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#update RoleManagementPolicy#update}
    */
    readonly update?: string;
}
export declare function roleManagementPolicyTimeoutsToTerraform(struct?: RoleManagementPolicyTimeouts | cdktf.IResolvable): any;
export declare function roleManagementPolicyTimeoutsToHclTerraform(struct?: RoleManagementPolicyTimeouts | cdktf.IResolvable): any;
export declare class RoleManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleManagementPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RoleManagementPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy azurerm_role_management_policy}
*/
export declare class RoleManagementPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_role_management_policy";
    /**
    * Generates CDKTF code for importing a RoleManagementPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RoleManagementPolicy to import
    * @param importFromId The id of the existing RoleManagementPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RoleManagementPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/role_management_policy azurerm_role_management_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleManagementPolicyConfig
    */
    constructor(scope: Construct, id: string, config: RoleManagementPolicyConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    get roleDefinitionIdInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _activationRules;
    get activationRules(): RoleManagementPolicyActivationRulesOutputReference;
    putActivationRules(value: RoleManagementPolicyActivationRules): void;
    resetActivationRules(): void;
    get activationRulesInput(): RoleManagementPolicyActivationRules | undefined;
    private _activeAssignmentRules;
    get activeAssignmentRules(): RoleManagementPolicyActiveAssignmentRulesOutputReference;
    putActiveAssignmentRules(value: RoleManagementPolicyActiveAssignmentRules): void;
    resetActiveAssignmentRules(): void;
    get activeAssignmentRulesInput(): RoleManagementPolicyActiveAssignmentRules | undefined;
    private _eligibleAssignmentRules;
    get eligibleAssignmentRules(): RoleManagementPolicyEligibleAssignmentRulesOutputReference;
    putEligibleAssignmentRules(value: RoleManagementPolicyEligibleAssignmentRules): void;
    resetEligibleAssignmentRules(): void;
    get eligibleAssignmentRulesInput(): RoleManagementPolicyEligibleAssignmentRules | undefined;
    private _notificationRules;
    get notificationRules(): RoleManagementPolicyNotificationRulesOutputReference;
    putNotificationRules(value: RoleManagementPolicyNotificationRules): void;
    resetNotificationRules(): void;
    get notificationRulesInput(): RoleManagementPolicyNotificationRules | undefined;
    private _timeouts;
    get timeouts(): RoleManagementPolicyTimeoutsOutputReference;
    putTimeouts(value: RoleManagementPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RoleManagementPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
