/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StaticWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#app_settings StaticWebApp#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#configuration_file_changes_enabled StaticWebApp#configuration_file_changes_enabled}
    */
    readonly configurationFileChangesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#id StaticWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#location StaticWebApp#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#name StaticWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#preview_environments_enabled StaticWebApp#preview_environments_enabled}
    */
    readonly previewEnvironmentsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#public_network_access_enabled StaticWebApp#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#repository_branch StaticWebApp#repository_branch}
    */
    readonly repositoryBranch?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#repository_token StaticWebApp#repository_token}
    */
    readonly repositoryToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#repository_url StaticWebApp#repository_url}
    */
    readonly repositoryUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#resource_group_name StaticWebApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#sku_size StaticWebApp#sku_size}
    */
    readonly skuSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#sku_tier StaticWebApp#sku_tier}
    */
    readonly skuTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#tags StaticWebApp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#basic_auth StaticWebApp#basic_auth}
    */
    readonly basicAuth?: StaticWebAppBasicAuth;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#identity StaticWebApp#identity}
    */
    readonly identity?: StaticWebAppIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#timeouts StaticWebApp#timeouts}
    */
    readonly timeouts?: StaticWebAppTimeouts;
}
export interface StaticWebAppBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#environments StaticWebApp#environments}
    */
    readonly environments: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#password StaticWebApp#password}
    */
    readonly password: string;
}
export declare function staticWebAppBasicAuthToTerraform(struct?: StaticWebAppBasicAuthOutputReference | StaticWebAppBasicAuth): any;
export declare function staticWebAppBasicAuthToHclTerraform(struct?: StaticWebAppBasicAuthOutputReference | StaticWebAppBasicAuth): any;
export declare class StaticWebAppBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StaticWebAppBasicAuth | undefined;
    set internalValue(value: StaticWebAppBasicAuth | undefined);
    private _environments?;
    get environments(): string;
    set environments(value: string);
    get environmentsInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
}
export interface StaticWebAppIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#identity_ids StaticWebApp#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#type StaticWebApp#type}
    */
    readonly type: string;
}
export declare function staticWebAppIdentityToTerraform(struct?: StaticWebAppIdentityOutputReference | StaticWebAppIdentity): any;
export declare function staticWebAppIdentityToHclTerraform(struct?: StaticWebAppIdentityOutputReference | StaticWebAppIdentity): any;
export declare class StaticWebAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StaticWebAppIdentity | undefined;
    set internalValue(value: StaticWebAppIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StaticWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#create StaticWebApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#delete StaticWebApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#read StaticWebApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#update StaticWebApp#update}
    */
    readonly update?: string;
}
export declare function staticWebAppTimeoutsToTerraform(struct?: StaticWebAppTimeouts | cdktf.IResolvable): any;
export declare function staticWebAppTimeoutsToHclTerraform(struct?: StaticWebAppTimeouts | cdktf.IResolvable): any;
export declare class StaticWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StaticWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StaticWebAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app azurerm_static_web_app}
*/
export declare class StaticWebApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_static_web_app";
    /**
    * Generates CDKTF code for importing a StaticWebApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StaticWebApp to import
    * @param importFromId The id of the existing StaticWebApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StaticWebApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/static_web_app azurerm_static_web_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StaticWebAppConfig
    */
    constructor(scope: Construct, id: string, config: StaticWebAppConfig);
    get apiKey(): string;
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _configurationFileChangesEnabled?;
    get configurationFileChangesEnabled(): boolean | cdktf.IResolvable;
    set configurationFileChangesEnabled(value: boolean | cdktf.IResolvable);
    resetConfigurationFileChangesEnabled(): void;
    get configurationFileChangesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get defaultHostName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _previewEnvironmentsEnabled?;
    get previewEnvironmentsEnabled(): boolean | cdktf.IResolvable;
    set previewEnvironmentsEnabled(value: boolean | cdktf.IResolvable);
    resetPreviewEnvironmentsEnabled(): void;
    get previewEnvironmentsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _repositoryBranch?;
    get repositoryBranch(): string;
    set repositoryBranch(value: string);
    resetRepositoryBranch(): void;
    get repositoryBranchInput(): string | undefined;
    private _repositoryToken?;
    get repositoryToken(): string;
    set repositoryToken(value: string);
    resetRepositoryToken(): void;
    get repositoryTokenInput(): string | undefined;
    private _repositoryUrl?;
    get repositoryUrl(): string;
    set repositoryUrl(value: string);
    resetRepositoryUrl(): void;
    get repositoryUrlInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuSize?;
    get skuSize(): string;
    set skuSize(value: string);
    resetSkuSize(): void;
    get skuSizeInput(): string | undefined;
    private _skuTier?;
    get skuTier(): string;
    set skuTier(value: string);
    resetSkuTier(): void;
    get skuTierInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _basicAuth;
    get basicAuth(): StaticWebAppBasicAuthOutputReference;
    putBasicAuth(value: StaticWebAppBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): StaticWebAppBasicAuth | undefined;
    private _identity;
    get identity(): StaticWebAppIdentityOutputReference;
    putIdentity(value: StaticWebAppIdentity): void;
    resetIdentity(): void;
    get identityInput(): StaticWebAppIdentity | undefined;
    private _timeouts;
    get timeouts(): StaticWebAppTimeoutsOutputReference;
    putTimeouts(value: StaticWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StaticWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
