/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageAccountQueuePropertiesAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#id StorageAccountQueuePropertiesA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#storage_account_id StorageAccountQueuePropertiesA#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * cors_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#cors_rule StorageAccountQueuePropertiesA#cors_rule}
    */
    readonly corsRule?: StorageAccountQueuePropertiesCorsRuleA[] | cdktf.IResolvable;
    /**
    * hour_metrics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#hour_metrics StorageAccountQueuePropertiesA#hour_metrics}
    */
    readonly hourMetrics?: StorageAccountQueuePropertiesHourMetricsA;
    /**
    * logging block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#logging StorageAccountQueuePropertiesA#logging}
    */
    readonly logging?: StorageAccountQueuePropertiesLoggingA;
    /**
    * minute_metrics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#minute_metrics StorageAccountQueuePropertiesA#minute_metrics}
    */
    readonly minuteMetrics?: StorageAccountQueuePropertiesMinuteMetricsA;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#timeouts StorageAccountQueuePropertiesA#timeouts}
    */
    readonly timeouts?: StorageAccountQueuePropertiesTimeouts;
}
export interface StorageAccountQueuePropertiesCorsRuleA {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#allowed_headers StorageAccountQueuePropertiesA#allowed_headers}
    */
    readonly allowedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#allowed_methods StorageAccountQueuePropertiesA#allowed_methods}
    */
    readonly allowedMethods: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#allowed_origins StorageAccountQueuePropertiesA#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#exposed_headers StorageAccountQueuePropertiesA#exposed_headers}
    */
    readonly exposedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#max_age_in_seconds StorageAccountQueuePropertiesA#max_age_in_seconds}
    */
    readonly maxAgeInSeconds: number;
}
export declare function storageAccountQueuePropertiesCorsRuleAToTerraform(struct?: StorageAccountQueuePropertiesCorsRuleA | cdktf.IResolvable): any;
export declare function storageAccountQueuePropertiesCorsRuleAToHclTerraform(struct?: StorageAccountQueuePropertiesCorsRuleA | cdktf.IResolvable): any;
export declare class StorageAccountQueuePropertiesCorsRuleAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageAccountQueuePropertiesCorsRuleA | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountQueuePropertiesCorsRuleA | cdktf.IResolvable | undefined);
    private _allowedHeaders?;
    get allowedHeaders(): string[];
    set allowedHeaders(value: string[]);
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    get allowedMethods(): string[];
    set allowedMethods(value: string[]);
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _exposedHeaders?;
    get exposedHeaders(): string[];
    set exposedHeaders(value: string[]);
    get exposedHeadersInput(): string[] | undefined;
    private _maxAgeInSeconds?;
    get maxAgeInSeconds(): number;
    set maxAgeInSeconds(value: number);
    get maxAgeInSecondsInput(): number | undefined;
}
export declare class StorageAccountQueuePropertiesCorsRuleAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageAccountQueuePropertiesCorsRuleA[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageAccountQueuePropertiesCorsRuleAOutputReference;
}
export interface StorageAccountQueuePropertiesHourMetricsA {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#include_apis StorageAccountQueuePropertiesA#include_apis}
    */
    readonly includeApis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#retention_policy_days StorageAccountQueuePropertiesA#retention_policy_days}
    */
    readonly retentionPolicyDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#version StorageAccountQueuePropertiesA#version}
    */
    readonly version: string;
}
export declare function storageAccountQueuePropertiesHourMetricsAToTerraform(struct?: StorageAccountQueuePropertiesHourMetricsAOutputReference | StorageAccountQueuePropertiesHourMetricsA): any;
export declare function storageAccountQueuePropertiesHourMetricsAToHclTerraform(struct?: StorageAccountQueuePropertiesHourMetricsAOutputReference | StorageAccountQueuePropertiesHourMetricsA): any;
export declare class StorageAccountQueuePropertiesHourMetricsAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountQueuePropertiesHourMetricsA | undefined;
    set internalValue(value: StorageAccountQueuePropertiesHourMetricsA | undefined);
    private _includeApis?;
    get includeApis(): boolean | cdktf.IResolvable;
    set includeApis(value: boolean | cdktf.IResolvable);
    resetIncludeApis(): void;
    get includeApisInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicyDays?;
    get retentionPolicyDays(): number;
    set retentionPolicyDays(value: number);
    resetRetentionPolicyDays(): void;
    get retentionPolicyDaysInput(): number | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface StorageAccountQueuePropertiesLoggingA {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#delete StorageAccountQueuePropertiesA#delete}
    */
    readonly delete: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#read StorageAccountQueuePropertiesA#read}
    */
    readonly read: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#retention_policy_days StorageAccountQueuePropertiesA#retention_policy_days}
    */
    readonly retentionPolicyDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#version StorageAccountQueuePropertiesA#version}
    */
    readonly version: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#write StorageAccountQueuePropertiesA#write}
    */
    readonly write: boolean | cdktf.IResolvable;
}
export declare function storageAccountQueuePropertiesLoggingAToTerraform(struct?: StorageAccountQueuePropertiesLoggingAOutputReference | StorageAccountQueuePropertiesLoggingA): any;
export declare function storageAccountQueuePropertiesLoggingAToHclTerraform(struct?: StorageAccountQueuePropertiesLoggingAOutputReference | StorageAccountQueuePropertiesLoggingA): any;
export declare class StorageAccountQueuePropertiesLoggingAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountQueuePropertiesLoggingA | undefined;
    set internalValue(value: StorageAccountQueuePropertiesLoggingA | undefined);
    private _delete?;
    get delete(): boolean | cdktf.IResolvable;
    set delete(value: boolean | cdktf.IResolvable);
    get deleteInput(): boolean | cdktf.IResolvable | undefined;
    private _read?;
    get read(): boolean | cdktf.IResolvable;
    set read(value: boolean | cdktf.IResolvable);
    get readInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicyDays?;
    get retentionPolicyDays(): number;
    set retentionPolicyDays(value: number);
    resetRetentionPolicyDays(): void;
    get retentionPolicyDaysInput(): number | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _write?;
    get write(): boolean | cdktf.IResolvable;
    set write(value: boolean | cdktf.IResolvable);
    get writeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StorageAccountQueuePropertiesMinuteMetricsA {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#include_apis StorageAccountQueuePropertiesA#include_apis}
    */
    readonly includeApis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#retention_policy_days StorageAccountQueuePropertiesA#retention_policy_days}
    */
    readonly retentionPolicyDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#version StorageAccountQueuePropertiesA#version}
    */
    readonly version: string;
}
export declare function storageAccountQueuePropertiesMinuteMetricsAToTerraform(struct?: StorageAccountQueuePropertiesMinuteMetricsAOutputReference | StorageAccountQueuePropertiesMinuteMetricsA): any;
export declare function storageAccountQueuePropertiesMinuteMetricsAToHclTerraform(struct?: StorageAccountQueuePropertiesMinuteMetricsAOutputReference | StorageAccountQueuePropertiesMinuteMetricsA): any;
export declare class StorageAccountQueuePropertiesMinuteMetricsAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountQueuePropertiesMinuteMetricsA | undefined;
    set internalValue(value: StorageAccountQueuePropertiesMinuteMetricsA | undefined);
    private _includeApis?;
    get includeApis(): boolean | cdktf.IResolvable;
    set includeApis(value: boolean | cdktf.IResolvable);
    resetIncludeApis(): void;
    get includeApisInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicyDays?;
    get retentionPolicyDays(): number;
    set retentionPolicyDays(value: number);
    resetRetentionPolicyDays(): void;
    get retentionPolicyDaysInput(): number | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface StorageAccountQueuePropertiesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#create StorageAccountQueuePropertiesA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#delete StorageAccountQueuePropertiesA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#read StorageAccountQueuePropertiesA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#update StorageAccountQueuePropertiesA#update}
    */
    readonly update?: string;
}
export declare function storageAccountQueuePropertiesTimeoutsToTerraform(struct?: StorageAccountQueuePropertiesTimeouts | cdktf.IResolvable): any;
export declare function storageAccountQueuePropertiesTimeoutsToHclTerraform(struct?: StorageAccountQueuePropertiesTimeouts | cdktf.IResolvable): any;
export declare class StorageAccountQueuePropertiesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountQueuePropertiesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountQueuePropertiesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties azurerm_storage_account_queue_properties}
*/
export declare class StorageAccountQueuePropertiesA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_account_queue_properties";
    /**
    * Generates CDKTF code for importing a StorageAccountQueuePropertiesA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageAccountQueuePropertiesA to import
    * @param importFromId The id of the existing StorageAccountQueuePropertiesA that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageAccountQueuePropertiesA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_account_queue_properties azurerm_storage_account_queue_properties} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageAccountQueuePropertiesAConfig
    */
    constructor(scope: Construct, id: string, config: StorageAccountQueuePropertiesAConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _corsRule;
    get corsRule(): StorageAccountQueuePropertiesCorsRuleAList;
    putCorsRule(value: StorageAccountQueuePropertiesCorsRuleA[] | cdktf.IResolvable): void;
    resetCorsRule(): void;
    get corsRuleInput(): cdktf.IResolvable | StorageAccountQueuePropertiesCorsRuleA[] | undefined;
    private _hourMetrics;
    get hourMetrics(): StorageAccountQueuePropertiesHourMetricsAOutputReference;
    putHourMetrics(value: StorageAccountQueuePropertiesHourMetricsA): void;
    resetHourMetrics(): void;
    get hourMetricsInput(): StorageAccountQueuePropertiesHourMetricsA | undefined;
    private _logging;
    get logging(): StorageAccountQueuePropertiesLoggingAOutputReference;
    putLogging(value: StorageAccountQueuePropertiesLoggingA): void;
    resetLogging(): void;
    get loggingInput(): StorageAccountQueuePropertiesLoggingA | undefined;
    private _minuteMetrics;
    get minuteMetrics(): StorageAccountQueuePropertiesMinuteMetricsAOutputReference;
    putMinuteMetrics(value: StorageAccountQueuePropertiesMinuteMetricsA): void;
    resetMinuteMetrics(): void;
    get minuteMetricsInput(): StorageAccountQueuePropertiesMinuteMetricsA | undefined;
    private _timeouts;
    get timeouts(): StorageAccountQueuePropertiesTimeoutsOutputReference;
    putTimeouts(value: StorageAccountQueuePropertiesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageAccountQueuePropertiesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
