/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBlobInventoryPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#id StorageBlobInventoryPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#storage_account_id StorageBlobInventoryPolicy#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#rules StorageBlobInventoryPolicy#rules}
    */
    readonly rules: StorageBlobInventoryPolicyRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#timeouts StorageBlobInventoryPolicy#timeouts}
    */
    readonly timeouts?: StorageBlobInventoryPolicyTimeouts;
}
export interface StorageBlobInventoryPolicyRulesFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#blob_types StorageBlobInventoryPolicy#blob_types}
    */
    readonly blobTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#exclude_prefixes StorageBlobInventoryPolicy#exclude_prefixes}
    */
    readonly excludePrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#include_blob_versions StorageBlobInventoryPolicy#include_blob_versions}
    */
    readonly includeBlobVersions?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#include_deleted StorageBlobInventoryPolicy#include_deleted}
    */
    readonly includeDeleted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#include_snapshots StorageBlobInventoryPolicy#include_snapshots}
    */
    readonly includeSnapshots?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#prefix_match StorageBlobInventoryPolicy#prefix_match}
    */
    readonly prefixMatch?: string[];
}
export declare function storageBlobInventoryPolicyRulesFilterToTerraform(struct?: StorageBlobInventoryPolicyRulesFilterOutputReference | StorageBlobInventoryPolicyRulesFilter): any;
export declare function storageBlobInventoryPolicyRulesFilterToHclTerraform(struct?: StorageBlobInventoryPolicyRulesFilterOutputReference | StorageBlobInventoryPolicyRulesFilter): any;
export declare class StorageBlobInventoryPolicyRulesFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBlobInventoryPolicyRulesFilter | undefined;
    set internalValue(value: StorageBlobInventoryPolicyRulesFilter | undefined);
    private _blobTypes?;
    get blobTypes(): string[];
    set blobTypes(value: string[]);
    get blobTypesInput(): string[] | undefined;
    private _excludePrefixes?;
    get excludePrefixes(): string[];
    set excludePrefixes(value: string[]);
    resetExcludePrefixes(): void;
    get excludePrefixesInput(): string[] | undefined;
    private _includeBlobVersions?;
    get includeBlobVersions(): boolean | cdktf.IResolvable;
    set includeBlobVersions(value: boolean | cdktf.IResolvable);
    resetIncludeBlobVersions(): void;
    get includeBlobVersionsInput(): boolean | cdktf.IResolvable | undefined;
    private _includeDeleted?;
    get includeDeleted(): boolean | cdktf.IResolvable;
    set includeDeleted(value: boolean | cdktf.IResolvable);
    resetIncludeDeleted(): void;
    get includeDeletedInput(): boolean | cdktf.IResolvable | undefined;
    private _includeSnapshots?;
    get includeSnapshots(): boolean | cdktf.IResolvable;
    set includeSnapshots(value: boolean | cdktf.IResolvable);
    resetIncludeSnapshots(): void;
    get includeSnapshotsInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string[];
    set prefixMatch(value: string[]);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string[] | undefined;
}
export interface StorageBlobInventoryPolicyRules {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#format StorageBlobInventoryPolicy#format}
    */
    readonly format: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#name StorageBlobInventoryPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#schedule StorageBlobInventoryPolicy#schedule}
    */
    readonly schedule: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#schema_fields StorageBlobInventoryPolicy#schema_fields}
    */
    readonly schemaFields: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#scope StorageBlobInventoryPolicy#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#storage_container_name StorageBlobInventoryPolicy#storage_container_name}
    */
    readonly storageContainerName: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#filter StorageBlobInventoryPolicy#filter}
    */
    readonly filter?: StorageBlobInventoryPolicyRulesFilter;
}
export declare function storageBlobInventoryPolicyRulesToTerraform(struct?: StorageBlobInventoryPolicyRules | cdktf.IResolvable): any;
export declare function storageBlobInventoryPolicyRulesToHclTerraform(struct?: StorageBlobInventoryPolicyRules | cdktf.IResolvable): any;
export declare class StorageBlobInventoryPolicyRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageBlobInventoryPolicyRules | cdktf.IResolvable | undefined;
    set internalValue(value: StorageBlobInventoryPolicyRules | cdktf.IResolvable | undefined);
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    get scheduleInput(): string | undefined;
    private _schemaFields?;
    get schemaFields(): string[];
    set schemaFields(value: string[]);
    get schemaFieldsInput(): string[] | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _storageContainerName?;
    get storageContainerName(): string;
    set storageContainerName(value: string);
    get storageContainerNameInput(): string | undefined;
    private _filter;
    get filter(): StorageBlobInventoryPolicyRulesFilterOutputReference;
    putFilter(value: StorageBlobInventoryPolicyRulesFilter): void;
    resetFilter(): void;
    get filterInput(): StorageBlobInventoryPolicyRulesFilter | undefined;
}
export declare class StorageBlobInventoryPolicyRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageBlobInventoryPolicyRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageBlobInventoryPolicyRulesOutputReference;
}
export interface StorageBlobInventoryPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#create StorageBlobInventoryPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#delete StorageBlobInventoryPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#read StorageBlobInventoryPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#update StorageBlobInventoryPolicy#update}
    */
    readonly update?: string;
}
export declare function storageBlobInventoryPolicyTimeoutsToTerraform(struct?: StorageBlobInventoryPolicyTimeouts | cdktf.IResolvable): any;
export declare function storageBlobInventoryPolicyTimeoutsToHclTerraform(struct?: StorageBlobInventoryPolicyTimeouts | cdktf.IResolvable): any;
export declare class StorageBlobInventoryPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBlobInventoryPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageBlobInventoryPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy azurerm_storage_blob_inventory_policy}
*/
export declare class StorageBlobInventoryPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_blob_inventory_policy";
    /**
    * Generates CDKTF code for importing a StorageBlobInventoryPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageBlobInventoryPolicy to import
    * @param importFromId The id of the existing StorageBlobInventoryPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageBlobInventoryPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/storage_blob_inventory_policy azurerm_storage_blob_inventory_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageBlobInventoryPolicyConfig
    */
    constructor(scope: Construct, id: string, config: StorageBlobInventoryPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _rules;
    get rules(): StorageBlobInventoryPolicyRulesList;
    putRules(value: StorageBlobInventoryPolicyRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | StorageBlobInventoryPolicyRules[] | undefined;
    private _timeouts;
    get timeouts(): StorageBlobInventoryPolicyTimeoutsOutputReference;
    putTimeouts(value: StorageBlobInventoryPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageBlobInventoryPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
