/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SystemCenterVirtualMachineManagerVirtualMachineInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#custom_location_id SystemCenterVirtualMachineManagerVirtualMachineInstance#custom_location_id}
    */
    readonly customLocationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#id SystemCenterVirtualMachineManagerVirtualMachineInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#scoped_resource_id SystemCenterVirtualMachineManagerVirtualMachineInstance#scoped_resource_id}
    */
    readonly scopedResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#system_center_virtual_machine_manager_availability_set_ids SystemCenterVirtualMachineManagerVirtualMachineInstance#system_center_virtual_machine_manager_availability_set_ids}
    */
    readonly systemCenterVirtualMachineManagerAvailabilitySetIds?: string[];
    /**
    * hardware block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#hardware SystemCenterVirtualMachineManagerVirtualMachineInstance#hardware}
    */
    readonly hardware?: SystemCenterVirtualMachineManagerVirtualMachineInstanceHardware;
    /**
    * infrastructure block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#infrastructure SystemCenterVirtualMachineManagerVirtualMachineInstance#infrastructure}
    */
    readonly infrastructure: SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructure;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#network_interface SystemCenterVirtualMachineManagerVirtualMachineInstance#network_interface}
    */
    readonly networkInterface?: SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterface[] | cdktf.IResolvable;
    /**
    * operating_system block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#operating_system SystemCenterVirtualMachineManagerVirtualMachineInstance#operating_system}
    */
    readonly operatingSystem?: SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystem;
    /**
    * storage_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#storage_disk SystemCenterVirtualMachineManagerVirtualMachineInstance#storage_disk}
    */
    readonly storageDisk?: SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDisk[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#timeouts SystemCenterVirtualMachineManagerVirtualMachineInstance#timeouts}
    */
    readonly timeouts?: SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeouts;
}
export interface SystemCenterVirtualMachineManagerVirtualMachineInstanceHardware {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#cpu_count SystemCenterVirtualMachineManagerVirtualMachineInstance#cpu_count}
    */
    readonly cpuCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#dynamic_memory_max_in_mb SystemCenterVirtualMachineManagerVirtualMachineInstance#dynamic_memory_max_in_mb}
    */
    readonly dynamicMemoryMaxInMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#dynamic_memory_min_in_mb SystemCenterVirtualMachineManagerVirtualMachineInstance#dynamic_memory_min_in_mb}
    */
    readonly dynamicMemoryMinInMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#limit_cpu_for_migration_enabled SystemCenterVirtualMachineManagerVirtualMachineInstance#limit_cpu_for_migration_enabled}
    */
    readonly limitCpuForMigrationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#memory_in_mb SystemCenterVirtualMachineManagerVirtualMachineInstance#memory_in_mb}
    */
    readonly memoryInMb?: number;
}
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceHardwareToTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceHardwareOutputReference | SystemCenterVirtualMachineManagerVirtualMachineInstanceHardware): any;
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceHardwareToHclTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceHardwareOutputReference | SystemCenterVirtualMachineManagerVirtualMachineInstanceHardware): any;
export declare class SystemCenterVirtualMachineManagerVirtualMachineInstanceHardwareOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SystemCenterVirtualMachineManagerVirtualMachineInstanceHardware | undefined;
    set internalValue(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceHardware | undefined);
    private _cpuCount?;
    get cpuCount(): number;
    set cpuCount(value: number);
    resetCpuCount(): void;
    get cpuCountInput(): number | undefined;
    private _dynamicMemoryMaxInMb?;
    get dynamicMemoryMaxInMb(): number;
    set dynamicMemoryMaxInMb(value: number);
    resetDynamicMemoryMaxInMb(): void;
    get dynamicMemoryMaxInMbInput(): number | undefined;
    private _dynamicMemoryMinInMb?;
    get dynamicMemoryMinInMb(): number;
    set dynamicMemoryMinInMb(value: number);
    resetDynamicMemoryMinInMb(): void;
    get dynamicMemoryMinInMbInput(): number | undefined;
    private _limitCpuForMigrationEnabled?;
    get limitCpuForMigrationEnabled(): boolean | cdktf.IResolvable;
    set limitCpuForMigrationEnabled(value: boolean | cdktf.IResolvable);
    resetLimitCpuForMigrationEnabled(): void;
    get limitCpuForMigrationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _memoryInMb?;
    get memoryInMb(): number;
    set memoryInMb(value: number);
    resetMemoryInMb(): void;
    get memoryInMbInput(): number | undefined;
}
export interface SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructure {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#checkpoint_type SystemCenterVirtualMachineManagerVirtualMachineInstance#checkpoint_type}
    */
    readonly checkpointType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#system_center_virtual_machine_manager_cloud_id SystemCenterVirtualMachineManagerVirtualMachineInstance#system_center_virtual_machine_manager_cloud_id}
    */
    readonly systemCenterVirtualMachineManagerCloudId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#system_center_virtual_machine_manager_inventory_item_id SystemCenterVirtualMachineManagerVirtualMachineInstance#system_center_virtual_machine_manager_inventory_item_id}
    */
    readonly systemCenterVirtualMachineManagerInventoryItemId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#system_center_virtual_machine_manager_template_id SystemCenterVirtualMachineManagerVirtualMachineInstance#system_center_virtual_machine_manager_template_id}
    */
    readonly systemCenterVirtualMachineManagerTemplateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#system_center_virtual_machine_manager_virtual_machine_server_id SystemCenterVirtualMachineManagerVirtualMachineInstance#system_center_virtual_machine_manager_virtual_machine_server_id}
    */
    readonly systemCenterVirtualMachineManagerVirtualMachineServerId?: string;
}
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructureToTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructureOutputReference | SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructure): any;
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructureToHclTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructureOutputReference | SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructure): any;
export declare class SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructure | undefined;
    set internalValue(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructure | undefined);
    private _checkpointType?;
    get checkpointType(): string;
    set checkpointType(value: string);
    resetCheckpointType(): void;
    get checkpointTypeInput(): string | undefined;
    private _systemCenterVirtualMachineManagerCloudId?;
    get systemCenterVirtualMachineManagerCloudId(): string;
    set systemCenterVirtualMachineManagerCloudId(value: string);
    resetSystemCenterVirtualMachineManagerCloudId(): void;
    get systemCenterVirtualMachineManagerCloudIdInput(): string | undefined;
    private _systemCenterVirtualMachineManagerInventoryItemId?;
    get systemCenterVirtualMachineManagerInventoryItemId(): string;
    set systemCenterVirtualMachineManagerInventoryItemId(value: string);
    resetSystemCenterVirtualMachineManagerInventoryItemId(): void;
    get systemCenterVirtualMachineManagerInventoryItemIdInput(): string | undefined;
    private _systemCenterVirtualMachineManagerTemplateId?;
    get systemCenterVirtualMachineManagerTemplateId(): string;
    set systemCenterVirtualMachineManagerTemplateId(value: string);
    resetSystemCenterVirtualMachineManagerTemplateId(): void;
    get systemCenterVirtualMachineManagerTemplateIdInput(): string | undefined;
    private _systemCenterVirtualMachineManagerVirtualMachineServerId?;
    get systemCenterVirtualMachineManagerVirtualMachineServerId(): string;
    set systemCenterVirtualMachineManagerVirtualMachineServerId(value: string);
    resetSystemCenterVirtualMachineManagerVirtualMachineServerId(): void;
    get systemCenterVirtualMachineManagerVirtualMachineServerIdInput(): string | undefined;
}
export interface SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#ipv4_address_type SystemCenterVirtualMachineManagerVirtualMachineInstance#ipv4_address_type}
    */
    readonly ipv4AddressType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#ipv6_address_type SystemCenterVirtualMachineManagerVirtualMachineInstance#ipv6_address_type}
    */
    readonly ipv6AddressType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#mac_address_type SystemCenterVirtualMachineManagerVirtualMachineInstance#mac_address_type}
    */
    readonly macAddressType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#name SystemCenterVirtualMachineManagerVirtualMachineInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#virtual_network_id SystemCenterVirtualMachineManagerVirtualMachineInstance#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
}
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterfaceToTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterface | cdktf.IResolvable): any;
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterfaceToHclTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterface | cdktf.IResolvable): any;
export declare class SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterface | cdktf.IResolvable | undefined);
    private _ipv4AddressType?;
    get ipv4AddressType(): string;
    set ipv4AddressType(value: string);
    resetIpv4AddressType(): void;
    get ipv4AddressTypeInput(): string | undefined;
    private _ipv6AddressType?;
    get ipv6AddressType(): string;
    set ipv6AddressType(value: string);
    resetIpv6AddressType(): void;
    get ipv6AddressTypeInput(): string | undefined;
    private _macAddressType?;
    get macAddressType(): string;
    set macAddressType(value: string);
    resetMacAddressType(): void;
    get macAddressTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
}
export declare class SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterfaceOutputReference;
}
export interface SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystem {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#admin_password SystemCenterVirtualMachineManagerVirtualMachineInstance#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#computer_name SystemCenterVirtualMachineManagerVirtualMachineInstance#computer_name}
    */
    readonly computerName: string;
}
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystemToTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystemOutputReference | SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystem): any;
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystemToHclTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystemOutputReference | SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystem): any;
export declare class SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystem | undefined;
    set internalValue(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystem | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _computerName?;
    get computerName(): string;
    set computerName(value: string);
    get computerNameInput(): string | undefined;
}
export interface SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#bus SystemCenterVirtualMachineManagerVirtualMachineInstance#bus}
    */
    readonly bus?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#bus_type SystemCenterVirtualMachineManagerVirtualMachineInstance#bus_type}
    */
    readonly busType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#disk_size_gb SystemCenterVirtualMachineManagerVirtualMachineInstance#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#lun SystemCenterVirtualMachineManagerVirtualMachineInstance#lun}
    */
    readonly lun?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#name SystemCenterVirtualMachineManagerVirtualMachineInstance#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#storage_qos_policy_name SystemCenterVirtualMachineManagerVirtualMachineInstance#storage_qos_policy_name}
    */
    readonly storageQosPolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#template_disk_id SystemCenterVirtualMachineManagerVirtualMachineInstance#template_disk_id}
    */
    readonly templateDiskId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#vhd_type SystemCenterVirtualMachineManagerVirtualMachineInstance#vhd_type}
    */
    readonly vhdType?: string;
}
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceStorageDiskToTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDisk | cdktf.IResolvable): any;
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceStorageDiskToHclTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDisk | cdktf.IResolvable): any;
export declare class SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDisk | cdktf.IResolvable | undefined;
    set internalValue(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDisk | cdktf.IResolvable | undefined);
    private _bus?;
    get bus(): number;
    set bus(value: number);
    resetBus(): void;
    get busInput(): number | undefined;
    private _busType?;
    get busType(): string;
    set busType(value: string);
    resetBusType(): void;
    get busTypeInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    resetLun(): void;
    get lunInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _storageQosPolicyName?;
    get storageQosPolicyName(): string;
    set storageQosPolicyName(value: string);
    resetStorageQosPolicyName(): void;
    get storageQosPolicyNameInput(): string | undefined;
    private _templateDiskId?;
    get templateDiskId(): string;
    set templateDiskId(value: string);
    resetTemplateDiskId(): void;
    get templateDiskIdInput(): string | undefined;
    private _vhdType?;
    get vhdType(): string;
    set vhdType(value: string);
    resetVhdType(): void;
    get vhdTypeInput(): string | undefined;
}
export declare class SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDiskOutputReference;
}
export interface SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#create SystemCenterVirtualMachineManagerVirtualMachineInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#delete SystemCenterVirtualMachineManagerVirtualMachineInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#read SystemCenterVirtualMachineManagerVirtualMachineInstance#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#update SystemCenterVirtualMachineManagerVirtualMachineInstance#update}
    */
    readonly update?: string;
}
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceTimeoutsToTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeouts | cdktf.IResolvable): any;
export declare function systemCenterVirtualMachineManagerVirtualMachineInstanceTimeoutsToHclTerraform(struct?: SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeouts | cdktf.IResolvable): any;
export declare class SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance azurerm_system_center_virtual_machine_manager_virtual_machine_instance}
*/
export declare class SystemCenterVirtualMachineManagerVirtualMachineInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_system_center_virtual_machine_manager_virtual_machine_instance";
    /**
    * Generates CDKTF code for importing a SystemCenterVirtualMachineManagerVirtualMachineInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SystemCenterVirtualMachineManagerVirtualMachineInstance to import
    * @param importFromId The id of the existing SystemCenterVirtualMachineManagerVirtualMachineInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SystemCenterVirtualMachineManagerVirtualMachineInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/system_center_virtual_machine_manager_virtual_machine_instance azurerm_system_center_virtual_machine_manager_virtual_machine_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SystemCenterVirtualMachineManagerVirtualMachineInstanceConfig
    */
    constructor(scope: Construct, id: string, config: SystemCenterVirtualMachineManagerVirtualMachineInstanceConfig);
    private _customLocationId?;
    get customLocationId(): string;
    set customLocationId(value: string);
    get customLocationIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _scopedResourceId?;
    get scopedResourceId(): string;
    set scopedResourceId(value: string);
    get scopedResourceIdInput(): string | undefined;
    private _systemCenterVirtualMachineManagerAvailabilitySetIds?;
    get systemCenterVirtualMachineManagerAvailabilitySetIds(): string[];
    set systemCenterVirtualMachineManagerAvailabilitySetIds(value: string[]);
    resetSystemCenterVirtualMachineManagerAvailabilitySetIds(): void;
    get systemCenterVirtualMachineManagerAvailabilitySetIdsInput(): string[] | undefined;
    private _hardware;
    get hardware(): SystemCenterVirtualMachineManagerVirtualMachineInstanceHardwareOutputReference;
    putHardware(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceHardware): void;
    resetHardware(): void;
    get hardwareInput(): SystemCenterVirtualMachineManagerVirtualMachineInstanceHardware | undefined;
    private _infrastructure;
    get infrastructure(): SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructureOutputReference;
    putInfrastructure(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructure): void;
    get infrastructureInput(): SystemCenterVirtualMachineManagerVirtualMachineInstanceInfrastructure | undefined;
    private _networkInterface;
    get networkInterface(): SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterfaceList;
    putNetworkInterface(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | SystemCenterVirtualMachineManagerVirtualMachineInstanceNetworkInterface[] | undefined;
    private _operatingSystem;
    get operatingSystem(): SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystemOutputReference;
    putOperatingSystem(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystem): void;
    resetOperatingSystem(): void;
    get operatingSystemInput(): SystemCenterVirtualMachineManagerVirtualMachineInstanceOperatingSystem | undefined;
    private _storageDisk;
    get storageDisk(): SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDiskList;
    putStorageDisk(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDisk[] | cdktf.IResolvable): void;
    resetStorageDisk(): void;
    get storageDiskInput(): cdktf.IResolvable | SystemCenterVirtualMachineManagerVirtualMachineInstanceStorageDisk[] | undefined;
    private _timeouts;
    get timeouts(): SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeoutsOutputReference;
    putTimeouts(value: SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SystemCenterVirtualMachineManagerVirtualMachineInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
