/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#address_prefix VirtualHub#address_prefix}
    */
    readonly addressPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#hub_routing_preference VirtualHub#hub_routing_preference}
    */
    readonly hubRoutingPreference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#id VirtualHub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#location VirtualHub#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#name VirtualHub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#resource_group_name VirtualHub#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#sku VirtualHub#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#tags VirtualHub#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#virtual_router_auto_scale_min_capacity VirtualHub#virtual_router_auto_scale_min_capacity}
    */
    readonly virtualRouterAutoScaleMinCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#virtual_wan_id VirtualHub#virtual_wan_id}
    */
    readonly virtualWanId?: string;
    /**
    * route block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#route VirtualHub#route}
    */
    readonly route?: VirtualHubRoute[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#timeouts VirtualHub#timeouts}
    */
    readonly timeouts?: VirtualHubTimeouts;
}
export interface VirtualHubRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#address_prefixes VirtualHub#address_prefixes}
    */
    readonly addressPrefixes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#next_hop_ip_address VirtualHub#next_hop_ip_address}
    */
    readonly nextHopIpAddress: string;
}
export declare function virtualHubRouteToTerraform(struct?: VirtualHubRoute | cdktf.IResolvable): any;
export declare function virtualHubRouteToHclTerraform(struct?: VirtualHubRoute | cdktf.IResolvable): any;
export declare class VirtualHubRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualHubRoute | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualHubRoute | cdktf.IResolvable | undefined);
    private _addressPrefixes?;
    get addressPrefixes(): string[];
    set addressPrefixes(value: string[]);
    get addressPrefixesInput(): string[] | undefined;
    private _nextHopIpAddress?;
    get nextHopIpAddress(): string;
    set nextHopIpAddress(value: string);
    get nextHopIpAddressInput(): string | undefined;
}
export declare class VirtualHubRouteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualHubRoute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualHubRouteOutputReference;
}
export interface VirtualHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#create VirtualHub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#delete VirtualHub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#read VirtualHub#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#update VirtualHub#update}
    */
    readonly update?: string;
}
export declare function virtualHubTimeoutsToTerraform(struct?: VirtualHubTimeouts | cdktf.IResolvable): any;
export declare function virtualHubTimeoutsToHclTerraform(struct?: VirtualHubTimeouts | cdktf.IResolvable): any;
export declare class VirtualHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualHubTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualHubTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub azurerm_virtual_hub}
*/
export declare class VirtualHub extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_hub";
    /**
    * Generates CDKTF code for importing a VirtualHub resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualHub to import
    * @param importFromId The id of the existing VirtualHub that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualHub to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_hub azurerm_virtual_hub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualHubConfig
    */
    constructor(scope: Construct, id: string, config: VirtualHubConfig);
    private _addressPrefix?;
    get addressPrefix(): string;
    set addressPrefix(value: string);
    resetAddressPrefix(): void;
    get addressPrefixInput(): string | undefined;
    get defaultRouteTableId(): string;
    private _hubRoutingPreference?;
    get hubRoutingPreference(): string;
    set hubRoutingPreference(value: string);
    resetHubRoutingPreference(): void;
    get hubRoutingPreferenceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get virtualRouterAsn(): number;
    private _virtualRouterAutoScaleMinCapacity?;
    get virtualRouterAutoScaleMinCapacity(): number;
    set virtualRouterAutoScaleMinCapacity(value: number);
    resetVirtualRouterAutoScaleMinCapacity(): void;
    get virtualRouterAutoScaleMinCapacityInput(): number | undefined;
    get virtualRouterIps(): string[];
    private _virtualWanId?;
    get virtualWanId(): string;
    set virtualWanId(value: string);
    resetVirtualWanId(): void;
    get virtualWanIdInput(): string | undefined;
    private _route;
    get route(): VirtualHubRouteList;
    putRoute(value: VirtualHubRoute[] | cdktf.IResolvable): void;
    resetRoute(): void;
    get routeInput(): cdktf.IResolvable | VirtualHubRoute[] | undefined;
    private _timeouts;
    get timeouts(): VirtualHubTimeoutsOutputReference;
    putTimeouts(value: VirtualHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
