/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineRestorePointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#crash_consistency_mode_enabled VirtualMachineRestorePoint#crash_consistency_mode_enabled}
    */
    readonly crashConsistencyModeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#excluded_disks VirtualMachineRestorePoint#excluded_disks}
    */
    readonly excludedDisks?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#id VirtualMachineRestorePoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#name VirtualMachineRestorePoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#virtual_machine_restore_point_collection_id VirtualMachineRestorePoint#virtual_machine_restore_point_collection_id}
    */
    readonly virtualMachineRestorePointCollectionId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#timeouts VirtualMachineRestorePoint#timeouts}
    */
    readonly timeouts?: VirtualMachineRestorePointTimeouts;
}
export interface VirtualMachineRestorePointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#create VirtualMachineRestorePoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#delete VirtualMachineRestorePoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#read VirtualMachineRestorePoint#read}
    */
    readonly read?: string;
}
export declare function virtualMachineRestorePointTimeoutsToTerraform(struct?: VirtualMachineRestorePointTimeouts | cdktf.IResolvable): any;
export declare function virtualMachineRestorePointTimeoutsToHclTerraform(struct?: VirtualMachineRestorePointTimeouts | cdktf.IResolvable): any;
export declare class VirtualMachineRestorePointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineRestorePointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineRestorePointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point azurerm_virtual_machine_restore_point}
*/
export declare class VirtualMachineRestorePoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_machine_restore_point";
    /**
    * Generates CDKTF code for importing a VirtualMachineRestorePoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualMachineRestorePoint to import
    * @param importFromId The id of the existing VirtualMachineRestorePoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualMachineRestorePoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_machine_restore_point azurerm_virtual_machine_restore_point} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineRestorePointConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineRestorePointConfig);
    private _crashConsistencyModeEnabled?;
    get crashConsistencyModeEnabled(): boolean | cdktf.IResolvable;
    set crashConsistencyModeEnabled(value: boolean | cdktf.IResolvable);
    resetCrashConsistencyModeEnabled(): void;
    get crashConsistencyModeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedDisks?;
    get excludedDisks(): string[];
    set excludedDisks(value: string[]);
    resetExcludedDisks(): void;
    get excludedDisksInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualMachineRestorePointCollectionId?;
    get virtualMachineRestorePointCollectionId(): string;
    set virtualMachineRestorePointCollectionId(value: string);
    get virtualMachineRestorePointCollectionIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VirtualMachineRestorePointTimeoutsOutputReference;
    putTimeouts(value: VirtualMachineRestorePointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualMachineRestorePointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
