/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualNetworkGatewayConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#authorization_key VirtualNetworkGatewayConnection#authorization_key}
    */
    readonly authorizationKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#connection_mode VirtualNetworkGatewayConnection#connection_mode}
    */
    readonly connectionMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#connection_protocol VirtualNetworkGatewayConnection#connection_protocol}
    */
    readonly connectionProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#dpd_timeout_seconds VirtualNetworkGatewayConnection#dpd_timeout_seconds}
    */
    readonly dpdTimeoutSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#egress_nat_rule_ids VirtualNetworkGatewayConnection#egress_nat_rule_ids}
    */
    readonly egressNatRuleIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#enable_bgp VirtualNetworkGatewayConnection#enable_bgp}
    */
    readonly enableBgp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#express_route_circuit_id VirtualNetworkGatewayConnection#express_route_circuit_id}
    */
    readonly expressRouteCircuitId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#express_route_gateway_bypass VirtualNetworkGatewayConnection#express_route_gateway_bypass}
    */
    readonly expressRouteGatewayBypass?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#id VirtualNetworkGatewayConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#ingress_nat_rule_ids VirtualNetworkGatewayConnection#ingress_nat_rule_ids}
    */
    readonly ingressNatRuleIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#local_azure_ip_address_enabled VirtualNetworkGatewayConnection#local_azure_ip_address_enabled}
    */
    readonly localAzureIpAddressEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#local_network_gateway_id VirtualNetworkGatewayConnection#local_network_gateway_id}
    */
    readonly localNetworkGatewayId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#location VirtualNetworkGatewayConnection#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#name VirtualNetworkGatewayConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#peer_virtual_network_gateway_id VirtualNetworkGatewayConnection#peer_virtual_network_gateway_id}
    */
    readonly peerVirtualNetworkGatewayId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#private_link_fast_path_enabled VirtualNetworkGatewayConnection#private_link_fast_path_enabled}
    */
    readonly privateLinkFastPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#resource_group_name VirtualNetworkGatewayConnection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#routing_weight VirtualNetworkGatewayConnection#routing_weight}
    */
    readonly routingWeight?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#shared_key VirtualNetworkGatewayConnection#shared_key}
    */
    readonly sharedKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#tags VirtualNetworkGatewayConnection#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#type VirtualNetworkGatewayConnection#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#use_policy_based_traffic_selectors VirtualNetworkGatewayConnection#use_policy_based_traffic_selectors}
    */
    readonly usePolicyBasedTrafficSelectors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#virtual_network_gateway_id VirtualNetworkGatewayConnection#virtual_network_gateway_id}
    */
    readonly virtualNetworkGatewayId: string;
    /**
    * custom_bgp_addresses block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#custom_bgp_addresses VirtualNetworkGatewayConnection#custom_bgp_addresses}
    */
    readonly customBgpAddresses?: VirtualNetworkGatewayConnectionCustomBgpAddresses;
    /**
    * ipsec_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#ipsec_policy VirtualNetworkGatewayConnection#ipsec_policy}
    */
    readonly ipsecPolicy?: VirtualNetworkGatewayConnectionIpsecPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#timeouts VirtualNetworkGatewayConnection#timeouts}
    */
    readonly timeouts?: VirtualNetworkGatewayConnectionTimeouts;
    /**
    * traffic_selector_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#traffic_selector_policy VirtualNetworkGatewayConnection#traffic_selector_policy}
    */
    readonly trafficSelectorPolicy?: VirtualNetworkGatewayConnectionTrafficSelectorPolicy[] | cdktf.IResolvable;
}
export interface VirtualNetworkGatewayConnectionCustomBgpAddresses {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#primary VirtualNetworkGatewayConnection#primary}
    */
    readonly primary: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#secondary VirtualNetworkGatewayConnection#secondary}
    */
    readonly secondary?: string;
}
export declare function virtualNetworkGatewayConnectionCustomBgpAddressesToTerraform(struct?: VirtualNetworkGatewayConnectionCustomBgpAddressesOutputReference | VirtualNetworkGatewayConnectionCustomBgpAddresses): any;
export declare function virtualNetworkGatewayConnectionCustomBgpAddressesToHclTerraform(struct?: VirtualNetworkGatewayConnectionCustomBgpAddressesOutputReference | VirtualNetworkGatewayConnectionCustomBgpAddresses): any;
export declare class VirtualNetworkGatewayConnectionCustomBgpAddressesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkGatewayConnectionCustomBgpAddresses | undefined;
    set internalValue(value: VirtualNetworkGatewayConnectionCustomBgpAddresses | undefined);
    private _primary?;
    get primary(): string;
    set primary(value: string);
    get primaryInput(): string | undefined;
    private _secondary?;
    get secondary(): string;
    set secondary(value: string);
    resetSecondary(): void;
    get secondaryInput(): string | undefined;
}
export interface VirtualNetworkGatewayConnectionIpsecPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#dh_group VirtualNetworkGatewayConnection#dh_group}
    */
    readonly dhGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#ike_encryption VirtualNetworkGatewayConnection#ike_encryption}
    */
    readonly ikeEncryption: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#ike_integrity VirtualNetworkGatewayConnection#ike_integrity}
    */
    readonly ikeIntegrity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#ipsec_encryption VirtualNetworkGatewayConnection#ipsec_encryption}
    */
    readonly ipsecEncryption: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#ipsec_integrity VirtualNetworkGatewayConnection#ipsec_integrity}
    */
    readonly ipsecIntegrity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#pfs_group VirtualNetworkGatewayConnection#pfs_group}
    */
    readonly pfsGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#sa_datasize VirtualNetworkGatewayConnection#sa_datasize}
    */
    readonly saDatasize?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#sa_lifetime VirtualNetworkGatewayConnection#sa_lifetime}
    */
    readonly saLifetime?: number;
}
export declare function virtualNetworkGatewayConnectionIpsecPolicyToTerraform(struct?: VirtualNetworkGatewayConnectionIpsecPolicyOutputReference | VirtualNetworkGatewayConnectionIpsecPolicy): any;
export declare function virtualNetworkGatewayConnectionIpsecPolicyToHclTerraform(struct?: VirtualNetworkGatewayConnectionIpsecPolicyOutputReference | VirtualNetworkGatewayConnectionIpsecPolicy): any;
export declare class VirtualNetworkGatewayConnectionIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkGatewayConnectionIpsecPolicy | undefined;
    set internalValue(value: VirtualNetworkGatewayConnectionIpsecPolicy | undefined);
    private _dhGroup?;
    get dhGroup(): string;
    set dhGroup(value: string);
    get dhGroupInput(): string | undefined;
    private _ikeEncryption?;
    get ikeEncryption(): string;
    set ikeEncryption(value: string);
    get ikeEncryptionInput(): string | undefined;
    private _ikeIntegrity?;
    get ikeIntegrity(): string;
    set ikeIntegrity(value: string);
    get ikeIntegrityInput(): string | undefined;
    private _ipsecEncryption?;
    get ipsecEncryption(): string;
    set ipsecEncryption(value: string);
    get ipsecEncryptionInput(): string | undefined;
    private _ipsecIntegrity?;
    get ipsecIntegrity(): string;
    set ipsecIntegrity(value: string);
    get ipsecIntegrityInput(): string | undefined;
    private _pfsGroup?;
    get pfsGroup(): string;
    set pfsGroup(value: string);
    get pfsGroupInput(): string | undefined;
    private _saDatasize?;
    get saDatasize(): number;
    set saDatasize(value: number);
    resetSaDatasize(): void;
    get saDatasizeInput(): number | undefined;
    private _saLifetime?;
    get saLifetime(): number;
    set saLifetime(value: number);
    resetSaLifetime(): void;
    get saLifetimeInput(): number | undefined;
}
export interface VirtualNetworkGatewayConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#create VirtualNetworkGatewayConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#delete VirtualNetworkGatewayConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#read VirtualNetworkGatewayConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#update VirtualNetworkGatewayConnection#update}
    */
    readonly update?: string;
}
export declare function virtualNetworkGatewayConnectionTimeoutsToTerraform(struct?: VirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable): any;
export declare function virtualNetworkGatewayConnectionTimeoutsToHclTerraform(struct?: VirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable): any;
export declare class VirtualNetworkGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface VirtualNetworkGatewayConnectionTrafficSelectorPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#local_address_cidrs VirtualNetworkGatewayConnection#local_address_cidrs}
    */
    readonly localAddressCidrs: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#remote_address_cidrs VirtualNetworkGatewayConnection#remote_address_cidrs}
    */
    readonly remoteAddressCidrs: string[];
}
export declare function virtualNetworkGatewayConnectionTrafficSelectorPolicyToTerraform(struct?: VirtualNetworkGatewayConnectionTrafficSelectorPolicy | cdktf.IResolvable): any;
export declare function virtualNetworkGatewayConnectionTrafficSelectorPolicyToHclTerraform(struct?: VirtualNetworkGatewayConnectionTrafficSelectorPolicy | cdktf.IResolvable): any;
export declare class VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualNetworkGatewayConnectionTrafficSelectorPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualNetworkGatewayConnectionTrafficSelectorPolicy | cdktf.IResolvable | undefined);
    private _localAddressCidrs?;
    get localAddressCidrs(): string[];
    set localAddressCidrs(value: string[]);
    get localAddressCidrsInput(): string[] | undefined;
    private _remoteAddressCidrs?;
    get remoteAddressCidrs(): string[];
    set remoteAddressCidrs(value: string[]);
    get remoteAddressCidrsInput(): string[] | undefined;
}
export declare class VirtualNetworkGatewayConnectionTrafficSelectorPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualNetworkGatewayConnectionTrafficSelectorPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection azurerm_virtual_network_gateway_connection}
*/
export declare class VirtualNetworkGatewayConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_network_gateway_connection";
    /**
    * Generates CDKTF code for importing a VirtualNetworkGatewayConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualNetworkGatewayConnection to import
    * @param importFromId The id of the existing VirtualNetworkGatewayConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualNetworkGatewayConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.28.0/docs/resources/virtual_network_gateway_connection azurerm_virtual_network_gateway_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualNetworkGatewayConnectionConfig
    */
    constructor(scope: Construct, id: string, config: VirtualNetworkGatewayConnectionConfig);
    private _authorizationKey?;
    get authorizationKey(): string;
    set authorizationKey(value: string);
    resetAuthorizationKey(): void;
    get authorizationKeyInput(): string | undefined;
    private _connectionMode?;
    get connectionMode(): string;
    set connectionMode(value: string);
    resetConnectionMode(): void;
    get connectionModeInput(): string | undefined;
    private _connectionProtocol?;
    get connectionProtocol(): string;
    set connectionProtocol(value: string);
    resetConnectionProtocol(): void;
    get connectionProtocolInput(): string | undefined;
    private _dpdTimeoutSeconds?;
    get dpdTimeoutSeconds(): number;
    set dpdTimeoutSeconds(value: number);
    resetDpdTimeoutSeconds(): void;
    get dpdTimeoutSecondsInput(): number | undefined;
    private _egressNatRuleIds?;
    get egressNatRuleIds(): string[];
    set egressNatRuleIds(value: string[]);
    resetEgressNatRuleIds(): void;
    get egressNatRuleIdsInput(): string[] | undefined;
    private _enableBgp?;
    get enableBgp(): boolean | cdktf.IResolvable;
    set enableBgp(value: boolean | cdktf.IResolvable);
    resetEnableBgp(): void;
    get enableBgpInput(): boolean | cdktf.IResolvable | undefined;
    private _expressRouteCircuitId?;
    get expressRouteCircuitId(): string;
    set expressRouteCircuitId(value: string);
    resetExpressRouteCircuitId(): void;
    get expressRouteCircuitIdInput(): string | undefined;
    private _expressRouteGatewayBypass?;
    get expressRouteGatewayBypass(): boolean | cdktf.IResolvable;
    set expressRouteGatewayBypass(value: boolean | cdktf.IResolvable);
    resetExpressRouteGatewayBypass(): void;
    get expressRouteGatewayBypassInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingressNatRuleIds?;
    get ingressNatRuleIds(): string[];
    set ingressNatRuleIds(value: string[]);
    resetIngressNatRuleIds(): void;
    get ingressNatRuleIdsInput(): string[] | undefined;
    private _localAzureIpAddressEnabled?;
    get localAzureIpAddressEnabled(): boolean | cdktf.IResolvable;
    set localAzureIpAddressEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAzureIpAddressEnabled(): void;
    get localAzureIpAddressEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _localNetworkGatewayId?;
    get localNetworkGatewayId(): string;
    set localNetworkGatewayId(value: string);
    resetLocalNetworkGatewayId(): void;
    get localNetworkGatewayIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerVirtualNetworkGatewayId?;
    get peerVirtualNetworkGatewayId(): string;
    set peerVirtualNetworkGatewayId(value: string);
    resetPeerVirtualNetworkGatewayId(): void;
    get peerVirtualNetworkGatewayIdInput(): string | undefined;
    private _privateLinkFastPathEnabled?;
    get privateLinkFastPathEnabled(): boolean | cdktf.IResolvable;
    set privateLinkFastPathEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateLinkFastPathEnabled(): void;
    get privateLinkFastPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _routingWeight?;
    get routingWeight(): number;
    set routingWeight(value: number);
    resetRoutingWeight(): void;
    get routingWeightInput(): number | undefined;
    private _sharedKey?;
    get sharedKey(): string;
    set sharedKey(value: string);
    resetSharedKey(): void;
    get sharedKeyInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _usePolicyBasedTrafficSelectors?;
    get usePolicyBasedTrafficSelectors(): boolean | cdktf.IResolvable;
    set usePolicyBasedTrafficSelectors(value: boolean | cdktf.IResolvable);
    resetUsePolicyBasedTrafficSelectors(): void;
    get usePolicyBasedTrafficSelectorsInput(): boolean | cdktf.IResolvable | undefined;
    private _virtualNetworkGatewayId?;
    get virtualNetworkGatewayId(): string;
    set virtualNetworkGatewayId(value: string);
    get virtualNetworkGatewayIdInput(): string | undefined;
    private _customBgpAddresses;
    get customBgpAddresses(): VirtualNetworkGatewayConnectionCustomBgpAddressesOutputReference;
    putCustomBgpAddresses(value: VirtualNetworkGatewayConnectionCustomBgpAddresses): void;
    resetCustomBgpAddresses(): void;
    get customBgpAddressesInput(): VirtualNetworkGatewayConnectionCustomBgpAddresses | undefined;
    private _ipsecPolicy;
    get ipsecPolicy(): VirtualNetworkGatewayConnectionIpsecPolicyOutputReference;
    putIpsecPolicy(value: VirtualNetworkGatewayConnectionIpsecPolicy): void;
    resetIpsecPolicy(): void;
    get ipsecPolicyInput(): VirtualNetworkGatewayConnectionIpsecPolicy | undefined;
    private _timeouts;
    get timeouts(): VirtualNetworkGatewayConnectionTimeoutsOutputReference;
    putTimeouts(value: VirtualNetworkGatewayConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualNetworkGatewayConnectionTimeouts | undefined;
    private _trafficSelectorPolicy;
    get trafficSelectorPolicy(): VirtualNetworkGatewayConnectionTrafficSelectorPolicyList;
    putTrafficSelectorPolicy(value: VirtualNetworkGatewayConnectionTrafficSelectorPolicy[] | cdktf.IResolvable): void;
    resetTrafficSelectorPolicy(): void;
    get trafficSelectorPolicyInput(): cdktf.IResolvable | VirtualNetworkGatewayConnectionTrafficSelectorPolicy[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
